/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.net.InetAddress;
import phex.interfaces.IMsg;
import phex.msg.MsgHeader;
import phex.utils.IOUtil;
import phex.utils.IPUtils;

public class MsgInitResponse
implements IMsg {
    private static final int sDataLength = 14;
    private MsgHeader mHeader;
    private short mPort;
    private byte[] mIP;
    private int mFileCount;
    private int mTotalSize;

    public MsgInitResponse(MsgHeader msgHeader) {
        this.setHeader(msgHeader);
        this.mPort = 0;
        this.mIP = null;
        this.mFileCount = 0;
        this.mTotalSize = 0;
    }

    public void setHeader(MsgHeader msgHeader) {
        this.mHeader = msgHeader;
        this.mHeader.setFunction(1);
    }

    public MsgHeader getHeader() {
        return this.mHeader;
    }

    public void setPort(short s) {
        this.mPort = s;
    }

    public short getPort() {
        return this.mPort;
    }

    public void setIP(byte[] byArray) {
        if (byArray.length != 4) {
            throw new IllegalArgumentException("Can't accept ip that is not 4 bytes in length: " + byArray.length);
        }
        this.mIP = byArray;
    }

    public byte[] getIP() {
        return this.mIP;
    }

    public void setFileCount(int n) {
        this.mFileCount = n;
    }

    public int getFileCount() {
        return this.mFileCount;
    }

    public void setTotalSize(int n) {
        this.mTotalSize = n;
    }

    public int getTotalSize() {
        return this.mTotalSize;
    }

    public void computeHeaderLen() {
        this.mHeader.setDataLen(this.getSize() - this.mHeader.getSize());
    }

    public int getSize() {
        return this.mHeader.getSize() + 14;
    }

    public void copy(MsgInitResponse msgInitResponse) {
        this.mHeader.copy(msgInitResponse.getHeader());
        this.mPort = msgInitResponse.mPort;
        this.mIP = msgInitResponse.mIP;
        this.mFileCount = msgInitResponse.mFileCount;
        this.mTotalSize = msgInitResponse.mTotalSize;
    }

    public int serialize(byte[] byArray, int n) throws Exception {
        n = this.mHeader.serialize(byArray, n);
        n = IOUtil.serializeShortLE(this.mPort, byArray, n);
        System.arraycopy(this.mIP, 0, byArray, n, 4);
        n += 4;
        n = IOUtil.serializeIntLE(this.mFileCount, byArray, n);
        n = IOUtil.serializeIntLE(this.mTotalSize, byArray, n);
        return n;
    }

    public int deserialize(byte[] byArray, int n) throws Exception {
        this.mPort = IOUtil.deserializeShortLE(byArray, n);
        n += 2;
        StringBuffer stringBuffer = new StringBuffer();
        n = IOUtil.deserializeIP(byArray, n, stringBuffer);
        this.mIP = InetAddress.getByName(stringBuffer.toString()).getAddress();
        this.mFileCount = IOUtil.deserializeIntLE(byArray, n);
        this.mTotalSize = IOUtil.deserializeIntLE(byArray, n += 4);
        return n += 4;
    }

    public String toString() {
        return "[" + this.mHeader + " " + "Port=" + this.mPort + ", " + "IP=" + IPUtils.ip2string(this.mIP) + ", " + "FileCount=" + this.mFileCount + ", " + "TotalSize=" + this.mTotalSize + "]";
    }
}

