/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.net.NoRouteToHostException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import phex.GUID;
import phex.Listener;
import phex.SendManager;
import phex.ServiceManager;
import phex.common.URN;
import phex.cqueue.CQueue;
import phex.cqueue.CQueueElement;
import phex.download.PushRequestSleeper;
import phex.download.RemoteFile;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SwarmingManager;
import phex.host.Host;
import phex.host.HostAddress;
import phex.host.HostManager;
import phex.interfaces.IMonitorSearch;
import phex.interfaces.IMsg;
import phex.msg.MsgHeader;
import phex.msg.MsgInit;
import phex.msg.MsgPushRequest;
import phex.msg.MsgQueryResponse;
import phex.msg.MsgResRecord;
import phex.query.QueryHitHost;
import phex.query.QueryManager;
import phex.query.Search;
import phex.utils.IPUtils;
import phex.utils.Logger;
import phex.utils.SearchEngine;

public final class MsgManager {
    private HostManager mHostMgr = ServiceManager.getHostManager();
    private SendManager sendMgr = ServiceManager.getSendManager();
    private QueryManager queryMgr = ServiceManager.getQueryManager();
    private Hashtable mMsgSeen;
    private Hashtable mRoutingTable;
    private Hashtable mPushRoutingTable;
    private CQueue mMsgLRU;
    private CQueue mRoutingLRU;
    private CQueue mPushRoutingLRU;
    private MsgInit mMyMsgInit;
    private Vector mPassiveResults = new Vector();
    private IMonitorSearch mMonitorSearchListener;
    private String mPassiveSearching = null;
    private ArrayList passiveSearchList;
    private SearchEngine passiveSearchEngine;

    public MsgManager() {
        this.mMsgSeen = new Hashtable();
        this.mRoutingTable = new Hashtable();
        this.mPushRoutingTable = new Hashtable();
        this.mMsgLRU = new CQueue(10000, false);
        this.mRoutingLRU = new CQueue(10000, false);
        this.mPushRoutingLRU = new CQueue(1000, false);
        this.mMyMsgInit = new MsgInit();
        this.mMyMsgInit.getHeader().setTTL(ServiceManager.sCfg.mNetTTL);
        this.passiveSearchList = new ArrayList(3);
        this.checkAndAddMsgSeen(this.mMyMsgInit.getHeader());
    }

    public void setMonitorSearchListener(IMonitorSearch iMonitorSearch) {
        this.mMonitorSearchListener = iMonitorSearch;
    }

    public synchronized boolean checkAndAddMsgSeen(MsgHeader msgHeader) {
        GUID gUID = msgHeader.getMsgID();
        if (this.mMsgSeen.get(gUID.getHashCode()) != null) {
            return true;
        }
        this.mMsgSeen.put(gUID.getHashCode(), msgHeader);
        try {
            this.mMsgLRU.addToHead(new CQueueElement(gUID));
            if (this.mMsgLRU.isExceedingMax()) {
                CQueueElement cQueueElement = (CQueueElement)this.mMsgLRU.removeFromTail();
                GUID gUID2 = (GUID)cQueueElement.getObj();
                this.mMsgSeen.remove(gUID2.getHashCode());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public synchronized void addToRoutingTable(GUID gUID, Host host) {
        try {
            this.mRoutingTable.put(gUID.getHashCode(), host);
            this.mRoutingLRU.addToHead(new CQueueElement(gUID));
            if (this.mRoutingLRU.isExceedingMax()) {
                CQueueElement cQueueElement = (CQueueElement)this.mRoutingLRU.removeFromTail();
                GUID gUID2 = (GUID)cQueueElement.getObj();
                this.mRoutingTable.remove(gUID2.getHashCode());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void addToPushRoutingTable(GUID gUID, Host host) {
        try {
            this.mPushRoutingTable.put(gUID.getHashCode(), host);
            this.mPushRoutingLRU.addToHead(new CQueueElement(gUID));
            if (this.mPushRoutingLRU.isExceedingMax()) {
                CQueueElement cQueueElement = (CQueueElement)this.mPushRoutingLRU.removeFromTail();
                GUID gUID2 = (GUID)cQueueElement.getObj();
                this.mPushRoutingTable.remove(gUID2.getHashCode());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized Host getRouting(GUID gUID) {
        return (Host)this.mRoutingTable.get(gUID.getHashCode());
    }

    public synchronized Host getPushRouting(GUID gUID) {
        Host host = (Host)this.mPushRoutingTable.get(gUID.getHashCode());
        if (host == null) {
            return null;
        }
        if (!host.isConnected()) {
            this.mPushRoutingTable.remove(gUID.getHashCode());
            return null;
        }
        return host;
    }

    public MsgInit getMyMsgInit() {
        return this.mMyMsgInit;
    }

    public void resetMyMsgInit() {
        this.mMyMsgInit = new MsgInit();
    }

    public synchronized void processQueryResponse(Host host, MsgQueryResponse msgQueryResponse) {
        if (IPUtils.isHostInUserFilter(msgQueryResponse.getHostIP())) {
            return;
        }
        this.queryMgr.getSearchContainer().processQueryResponse(msgQueryResponse);
        this.queryMgr.getBackgroundSearchContainer().processQueryResponse(msgQueryResponse);
        this.passiveMonitorResult(msgQueryResponse);
        this.snoopMonitorResult(msgQueryResponse);
    }

    public String getPassiveSearching() {
        return this.mPassiveSearching;
    }

    public void setPassiveSearching(String string) {
        this.mPassiveSearching = string;
        this.passiveSearchList.clear();
        if (this.mPassiveSearching != null && this.mPassiveSearching.length() > 0) {
            if (this.passiveSearchEngine == null) {
                this.passiveSearchEngine = new SearchEngine();
            }
            this.mPassiveSearching = this.mPassiveSearching.toLowerCase();
            StringTokenizer stringTokenizer = new StringTokenizer(this.mPassiveSearching, " ");
            this.passiveSearchList.ensureCapacity(stringTokenizer.countTokens());
            while (stringTokenizer.hasMoreTokens()) {
                this.passiveSearchList.add(stringTokenizer.nextToken());
            }
        }
    }

    public Vector getPassiveResults() {
        return this.mPassiveResults;
    }

    public void snoopMonitorResult(MsgQueryResponse msgQueryResponse) {
        if (!ServiceManager.sCfg.enableHitSnooping) {
            return;
        }
        SwarmingManager swarmingManager = ServiceManager.getSwarmingManager();
        int n = 0;
        while (n < swarmingManager.getDownloadFileCount()) {
            SWDownloadFile sWDownloadFile = swarmingManager.getDownloadFile(n);
            if (sWDownloadFile != null) {
                Object object;
                SearchEngine searchEngine = new SearchEngine();
                ArrayList<Object> arrayList = new ArrayList<Object>();
                StringTokenizer stringTokenizer = new StringTokenizer(sWDownloadFile.getResearchSetting().getSearchTerm().toLowerCase(), " _,()");
                while (stringTokenizer.hasMoreTokens()) {
                    object = stringTokenizer.nextToken();
                    if (((String)object).length() < 3 || ((String)object).length() > 25) continue;
                    arrayList.add(object);
                }
                object = sWDownloadFile.getResearchSetting().getSearchURN();
                int n2 = 0;
                while (n2 < msgQueryResponse.getRecordCount()) {
                    block9: {
                        MsgResRecord msgResRecord = msgQueryResponse.getMsgRecord(n2);
                        if (sWDownloadFile.getTransferDataSize() == (long)msgResRecord.getFileSize()) {
                            URN uRN = msgResRecord.getURN();
                            if (object == null || uRN == null || ((URN)object).equals(uRN)) {
                                searchEngine.setText(msgResRecord.getFilename().toLowerCase(), true);
                                Object object2 = arrayList.iterator();
                                while (object2.hasNext()) {
                                    searchEngine.setPattern((String)object2.next(), true);
                                    if (searchEngine.match()) {
                                        continue;
                                    }
                                    break block9;
                                }
                                object2 = new QueryHitHost(msgQueryResponse.getRemoteClientID(), msgQueryResponse.getHostAddress(), msgQueryResponse.getRemoteHostSpeed());
                                RemoteFile remoteFile = new RemoteFile((QueryHitHost)object2, msgResRecord.getFileIndex(), msgResRecord.getFilename(), msgResRecord.getFileSize(), msgResRecord.getURN(), msgResRecord.getMetaData(), -1);
                                sWDownloadFile.addDownloadCandidate(remoteFile);
                            }
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    public void passiveMonitorResult(MsgQueryResponse msgQueryResponse) {
        if (this.mPassiveSearching == null) {
            return;
        }
        if (this.mPassiveResults.size() >= ServiceManager.sCfg.mSearchMaxSearch) {
            return;
        }
        HostAddress hostAddress = msgQueryResponse.getHostAddress();
        int n = msgQueryResponse.getRemoteHostSpeed();
        GUID gUID = msgQueryResponse.getRemoteClientID();
        QueryHitHost queryHitHost = new QueryHitHost(gUID, hostAddress, n);
        queryHitHost.setVendorCode(msgQueryResponse.getVendorCode());
        int n2 = 0;
        while (n2 < msgQueryResponse.getRecordCount()) {
            MsgResRecord msgResRecord = msgQueryResponse.getMsgRecord(n2);
            if (this.mPassiveSearching.length() == 0) {
                RemoteFile remoteFile = new RemoteFile(queryHitHost, msgResRecord.getFileIndex(), msgResRecord.getFilename(), msgResRecord.getFileSize(), msgResRecord.getURN(), msgResRecord.getMetaData(), 100);
                if (!this.passiveResultExists(remoteFile)) {
                    this.mPassiveResults.addElement(remoteFile);
                    this.mMonitorSearchListener.passiveResultArrived();
                }
            } else {
                boolean bl = true;
                this.passiveSearchEngine.setText(msgResRecord.getFilename(), false);
                int n3 = 0;
                while (n3 < this.passiveSearchList.size()) {
                    this.passiveSearchEngine.setPattern((String)this.passiveSearchList.get(n3), true);
                    if (!this.passiveSearchEngine.match()) {
                        bl = false;
                        break;
                    }
                    ++n3;
                }
                if (bl) {
                    short s = Search.calculateSearchScore(this.mPassiveSearching, msgResRecord.getFilename());
                    RemoteFile remoteFile = new RemoteFile(queryHitHost, msgResRecord.getFileIndex(), msgResRecord.getFilename(), msgResRecord.getFileSize(), msgResRecord.getURN(), msgResRecord.getMetaData(), s);
                    if (!this.passiveResultExists(remoteFile)) {
                        this.mPassiveResults.addElement(remoteFile);
                        this.mMonitorSearchListener.passiveResultArrived();
                    }
                }
            }
            ++n2;
        }
    }

    private boolean passiveResultExists(RemoteFile remoteFile) {
        int n = 0;
        while (n < this.mPassiveResults.size()) {
            RemoteFile remoteFile2 = (RemoteFile)this.mPassiveResults.elementAt(n);
            if (remoteFile2.equals(remoteFile)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void resetPassiveResults() {
        this.mPassiveResults.removeAllElements();
        this.mMonitorSearchListener.passiveResultArrived();
    }

    public void forwardMsg(IMsg iMsg, Host host) {
        if (this.decTTL(iMsg)) {
            return;
        }
        int n = this.mHostMgr.getConnectedHostCount();
        int n2 = 0;
        while (n2 < n) {
            Host host2 = this.mHostMgr.getConnectedHostAt(n2);
            if (host2 != host) {
                this.sendMsgToHost(iMsg, host2);
            }
            ++n2;
        }
    }

    public void sendMsgToHosts(IMsg iMsg) {
        int n = this.mHostMgr.getConnectedHostCount();
        int n2 = 0;
        while (n2 < n) {
            Host host = this.mHostMgr.getConnectedHostAt(n2);
            this.sendMsgToHost(iMsg, host);
            ++n2;
        }
    }

    public void pingNeighbors() {
        int n = this.mHostMgr.getConnectedHostCount();
        int n2 = 0;
        while (n2 < n) {
            Host host = this.mHostMgr.getConnectedHostAt(n2);
            if (host != null) {
                host.pingHost();
            }
            ++n2;
        }
    }

    public void sendMsgToHost(IMsg iMsg, Host host) {
        if (host == null) {
            return;
        }
        if (host.sendQueueInRed() || host.latencyInRed()) {
            return;
        }
        this.sendMgr.queueMsgToSend(host, iMsg, false);
    }

    public boolean decTTL(IMsg iMsg) {
        MsgHeader msgHeader = iMsg.getHeader();
        int n = msgHeader.getTTL() - 1;
        if (n <= 0) {
            return true;
        }
        if (n > ServiceManager.sCfg.mNetMaxTTL) {
            n = ServiceManager.sCfg.mNetMaxTTL;
        }
        msgHeader.setTTL(n);
        msgHeader.setHopsTaken(msgHeader.getHopsTaken() + 1);
        return false;
    }

    public void sendPushRequest(PushRequestSleeper pushRequestSleeper) throws NoRouteToHostException {
        Listener listener = ServiceManager.getListener();
        GUID gUID = pushRequestSleeper.getGUID();
        long l = pushRequestSleeper.getFileIndex();
        HostAddress hostAddress = listener.getLocalAddress();
        MsgPushRequest msgPushRequest = new MsgPushRequest(gUID, l, hostAddress);
        Host host = this.getPushRouting(gUID);
        Logger.logMessage(Logger.FINER, (short)2, "Push route for " + gUID + " is " + host);
        if (host == null) {
            throw new NoRouteToHostException("Routing table has no info to route back to sharing host.");
        }
        ServiceManager.getSendManager().queueMsgToSend(host, msgPushRequest, false);
    }
}

