/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import phex.GUID;
import phex.host.HostAddress;
import phex.interfaces.IMsg;
import phex.msg.MsgHeader;
import phex.utils.IOUtil;

public class MsgPushRequest
implements IMsg {
    private MsgHeader mHeader;
    private GUID clientGUID;
    private long fileIndex;
    private HostAddress requestAddress;

    public MsgPushRequest(MsgHeader msgHeader) {
        this.setHeader(msgHeader);
        this.clientGUID = new GUID();
        this.fileIndex = -1L;
        this.requestAddress = null;
    }

    public MsgPushRequest(GUID gUID, long l, HostAddress hostAddress) {
        this.setHeader(new MsgHeader());
        this.clientGUID = gUID;
        this.fileIndex = l;
        this.requestAddress = hostAddress;
    }

    public void setHeader(MsgHeader msgHeader) {
        this.mHeader = msgHeader;
        this.mHeader.setFunction(64);
    }

    public MsgHeader getHeader() {
        return this.mHeader;
    }

    public GUID getClientGUID() {
        return this.clientGUID;
    }

    public void setClientGUID(GUID gUID) {
        this.clientGUID = gUID;
    }

    public long getFileIndex() {
        return this.fileIndex;
    }

    public void setFileIndex(long l) {
        this.fileIndex = l;
    }

    public HostAddress getRequestAddress() {
        return this.requestAddress;
    }

    public void computeHeaderLen() {
        this.mHeader.setDataLen(this.getSize() - this.mHeader.getSize());
    }

    public int getSize() {
        return this.mHeader.getSize() + this.clientGUID.getSize() + 4 + 4 + 2;
    }

    public void copy(MsgPushRequest msgPushRequest) {
        this.mHeader.copy(msgPushRequest.getHeader());
        this.clientGUID = msgPushRequest.clientGUID;
        this.fileIndex = msgPushRequest.fileIndex;
        this.requestAddress = msgPushRequest.requestAddress;
    }

    public int serialize(byte[] byArray, int n) throws Exception {
        n = this.mHeader.serialize(byArray, n);
        n = this.clientGUID.serialize(byArray, n);
        n = IOUtil.serializeIntLE((int)this.fileIndex, byArray, n);
        System.arraycopy(this.requestAddress.getHostIP(), 0, byArray, n, 4);
        n += 4;
        n = IOUtil.serializeShortLE((short)this.requestAddress.getPort(), byArray, n);
        return n;
    }

    public int deserialize(byte[] byArray, int n) throws Exception {
        n = this.clientGUID.deserialize(byArray, n);
        this.fileIndex = IOUtil.unsignedInt2Long(IOUtil.deserializeIntLE(byArray, n));
        byte[] byArray2 = new byte[]{byArray[n += 4], byArray[n + 1], byArray[n + 2], byArray[n + 3]};
        short s = IOUtil.deserializeShortLE(byArray, n += 4);
        if (this.requestAddress == null) {
            this.requestAddress = new HostAddress(byArray2, (int)s);
        } else {
            this.requestAddress.updateAddress(byArray2, (int)s);
        }
        return n += 2;
    }

    public String toString() {
        return "[" + this.mHeader + " " + "ClientGUID=" + this.clientGUID + ", " + "FileIndex=" + this.fileIndex + ", " + "RequestAddress=" + this.requestAddress + ", " + "]";
    }
}

