/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import phex.interfaces.IMsg;
import phex.msg.MsgHeader;
import phex.utils.IOUtil;

public class MsgUnknown
implements IMsg {
    private MsgHeader mHeader;
    private byte[] mBody;
    private String mBodyStr;

    private MsgUnknown() {
    }

    public MsgUnknown(MsgHeader msgHeader) {
        this.setHeader(msgHeader);
        this.mBody = null;
    }

    public void setHeader(MsgHeader msgHeader) {
        this.mHeader = msgHeader;
    }

    public MsgHeader getHeader() {
        return this.mHeader;
    }

    public void setBody(byte[] byArray) {
        this.mBody = byArray;
    }

    public byte[] getBody() {
        return this.mBody;
    }

    public void computeHeaderLen() {
        this.mHeader.setDataLen(this.getSize() - this.mHeader.getSize());
    }

    public int getSize() {
        return this.mHeader.getSize() + this.mBody.length;
    }

    public void copy(MsgUnknown msgUnknown) {
        this.mHeader.copy(msgUnknown.getHeader());
        this.mBody = msgUnknown.mBody;
    }

    public int serialize(byte[] byArray, int n) throws Exception {
        n = this.mHeader.serialize(byArray, n);
        System.arraycopy(this.mBody, 0, byArray, n, this.mBody.length);
        return n += this.mBody.length;
    }

    public int deserialize(byte[] byArray, int n) throws Exception {
        this.mBody = new byte[this.mHeader.getDataLen()];
        System.arraycopy(byArray, n, this.mBody, 0, this.mBody.length);
        StringBuffer stringBuffer = new StringBuffer();
        IOUtil.deserializeString(this.mBody, 0, stringBuffer);
        this.mBodyStr = stringBuffer.toString();
        return n += this.mBody.length;
    }

    public String toString() {
        return "[" + this.mHeader + ", " + this.mBodyStr + "]";
    }
}

