/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import phex.GUID;
import phex.ServiceManager;
import phex.host.HostAddress;
import phex.query.QueryConstants;
import phex.utils.Localizer;

public class QueryHitHost
implements QueryConstants {
    private GUID hostGUID;
    private Integer hostSpeedObj;
    private String vendorCode;
    private short pushNeededFlag;
    private short serverBusyFlag;
    private short hasUploadedFlag;
    private short uploadSpeedFlag;
    private String vendor;
    private Short hostRating;
    private HostAddress hostAddress;

    public QueryHitHost(GUID gUID, HostAddress hostAddress, int n) {
        this.hostGUID = gUID;
        this.hostAddress = hostAddress;
        this.hostSpeedObj = new Integer(n);
        this.setQHDFlags((short)-1, (short)-1, (short)-1, (short)-1);
        this.hostRating = new Short(-1);
    }

    public void setVendorCode(String string) {
        if (string != null) {
            this.vendor = Localizer.getString(string);
        }
    }

    public String getVendor() {
        return this.vendor;
    }

    public GUID getHostGUID() {
        return this.hostGUID;
    }

    public int getHostSpeed() {
        return this.hostSpeedObj;
    }

    public Integer getHostSpeedObject() {
        return this.hostSpeedObj;
    }

    public HostAddress getHostAddress() {
        return this.hostAddress;
    }

    public void setQHDFlags(short s, short s2, short s3, short s4) {
        this.pushNeededFlag = s;
        this.serverBusyFlag = s2;
        this.hasUploadedFlag = s3;
        this.uploadSpeedFlag = s4;
    }

    public boolean isPushNeeded() {
        return this.pushNeededFlag == 1;
    }

    public short getHostRating() {
        if (this.hostRating == -1) {
            this.calculateHostRating();
        }
        return this.hostRating;
    }

    public Short getHostRatingObject() {
        if (this.hostRating == -1) {
            this.calculateHostRating();
        }
        return this.hostRating;
    }

    private void calculateHostRating() {
        if (this.pushNeededFlag == 1 && (!ServiceManager.getListener().hasConnectedIncoming() || ServiceManager.sCfg.isBehindFirewall)) {
            this.hostRating = new Short(0);
            return;
        }
        if (this.serverBusyFlag == 1) {
            this.hostRating = new Short(1);
            return;
        }
        short s = this.pushNeededFlag == 1 ? (this.serverBusyFlag == 0 ? (short)3 : 2) : (this.pushNeededFlag == 0 ? (this.serverBusyFlag == 0 ? (short)6 : 5) : (!ServiceManager.getListener().hasConnectedIncoming() || ServiceManager.sCfg.isBehindFirewall ? (short)3 : 4));
        if (this.hasUploadedFlag == 1) {
            s = (short)(s + 2);
        } else if (this.hasUploadedFlag == -1) {
            s = (short)(s + 1);
        }
        this.hostRating = new Short(s);
    }
}

