/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import phex.ServiceManager;
import phex.event.AsynchronousDispatcher;
import phex.event.SearchChangeEvent;
import phex.event.SearchChangeListener;
import phex.event.SearchListChangeListener;
import phex.msg.MsgQueryResponse;
import phex.query.Search;

public class SearchContainer {
    private ArrayList listenerList = new ArrayList(2);
    protected ArrayList searchList;
    private SearchChangeListener searchChangeListener = new SingleSearchChangeListener();

    public SearchContainer() {
        this.searchList = new ArrayList();
    }

    public synchronized Search createSearch(String string) {
        Search search = new Search(string);
        this.insertToSearchList(search, 0);
        if (this.searchList.size() > ServiceManager.sCfg.mSearchMaxConcurrent) {
            int n = this.searchList.size() - 1;
            this.removeFromSearchList(n);
        }
        search.startSearching();
        return search;
    }

    protected synchronized void insertToSearchList(Search search, int n) {
        search.addSearchChangeListener(this.searchChangeListener);
        this.searchList.add(n, search);
        this.fireSearchAdded(n);
    }

    protected synchronized void removeFromSearchList(int n) {
        Search search = this.getSearchAt(n);
        search.stopSearching();
        search.removeSearchChangeListener(this.searchChangeListener);
        this.searchList.remove(n);
        this.fireSearchRemoved(n);
    }

    public synchronized Search getRunningSearch(String string) {
        Iterator iterator = ((AbstractList)this.searchList).iterator();
        while (iterator.hasNext()) {
            Search search = (Search)iterator.next();
            if (!search.isSearching() || !search.getSearchString().equals(string)) continue;
            return search;
        }
        return null;
    }

    public synchronized int getSearchCount() {
        return this.searchList.size();
    }

    public synchronized Search getSearchAt(int n) {
        if (n > this.getSearchCount() - 1) {
            return null;
        }
        return (Search)this.searchList.get(n);
    }

    public synchronized void removeSearch(Search search) {
        int n = this.searchList.indexOf(search);
        if (n >= 0) {
            this.removeFromSearchList(n);
        }
    }

    public synchronized void removeSearch(int n) {
        this.removeFromSearchList(n);
    }

    public synchronized void stopExpiredSearches(long l) {
        int n = 0;
        while (n < this.searchList.size()) {
            ((Search)this.searchList.get(n)).checkForSearchTimeout(l);
            ++n;
        }
    }

    public synchronized void stopAllSearches() {
        int n = 0;
        while (n < this.searchList.size()) {
            ((Search)this.searchList.get(n)).stopSearching();
            ++n;
        }
    }

    public synchronized void removeAllSearches() {
        int n = this.searchList.size() - 1;
        while (n >= 0) {
            this.removeFromSearchList(n);
            --n;
        }
    }

    public synchronized void processQueryResponse(MsgQueryResponse msgQueryResponse) {
        int n = 0;
        while (n < this.searchList.size()) {
            ((Search)this.searchList.get(n)).processResponse(msgQueryResponse);
            ++n;
        }
    }

    public void addSearchListChangeListener(SearchListChangeListener searchListChangeListener) {
        this.listenerList.add(searchListChangeListener);
    }

    public void removeSearchListChangeListener(SearchListChangeListener searchListChangeListener) {
        ((AbstractCollection)this.listenerList).remove(searchListChangeListener);
    }

    protected void fireSearchChanged(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = SearchContainer.this.listenerList.toArray();
                int n2 = objectArray.length - 1;
                while (n2 >= 0) {
                    SearchListChangeListener searchListChangeListener = (SearchListChangeListener)objectArray[n2];
                    searchListChangeListener.searchChanged(n);
                    --n2;
                }
            }
        });
    }

    protected void fireSearchAdded(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = SearchContainer.this.listenerList.toArray();
                int n2 = objectArray.length - 1;
                while (n2 >= 0) {
                    SearchListChangeListener searchListChangeListener = (SearchListChangeListener)objectArray[n2];
                    searchListChangeListener.searchAdded(n);
                    --n2;
                }
            }
        });
    }

    protected void fireSearchRemoved(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = SearchContainer.this.listenerList.toArray();
                int n2 = objectArray.length - 1;
                while (n2 >= 0) {
                    SearchListChangeListener searchListChangeListener = (SearchListChangeListener)objectArray[n2];
                    searchListChangeListener.searchRemoved(n);
                    --n2;
                }
            }
        });
    }

    protected void setSearchChangeListener(SearchChangeListener searchChangeListener) {
        this.searchChangeListener = searchChangeListener;
    }

    protected void fireSearchChanged(Search search) {
        int n = this.searchList.indexOf(search);
        if (n >= 0) {
            this.fireSearchChanged(n);
        }
    }

    private class SingleSearchChangeListener
    implements SearchChangeListener {
        private SingleSearchChangeListener() {
        }

        public void searchChanged(SearchChangeEvent searchChangeEvent) {
            Search search = (Search)searchChangeEvent.getSource();
            SearchContainer.this.fireSearchChanged(search);
        }
    }
}

