/*
 * Decompiled with CFR 0.152.
 */
package phex.share;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.SocketException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import phex.HttpRange;
import phex.Res;
import phex.ServiceManager;
import phex.common.URN;
import phex.connection.ConnectionRequest;
import phex.host.Host;
import phex.host.HostManager;
import phex.msg.GETRequest;
import phex.msg.MsgQuery;
import phex.share.FileAdministration;
import phex.share.MimeTypeMapping;
import phex.share.ShareFile;
import phex.share.UploadFile;
import phex.share.UploadFileContainer;
import phex.utils.IOUtil;
import phex.utils.Logger;
import phex.utils.SearchEngine;
import phex.utils.StatisticTracker;
import phex.utils.StrUtil;
import phex.utils.ThrottleController;

public class ShareManager {
    private static final ShareFile[] VERSION_FILE_ARRAY = new ShareFile[]{new ShareFile(null)};
    private static final ShareFile[] EMPTY_SEARCH_RESULT = new ShareFile[0];
    private static final String PHEX_PING = "!`phex~~ping";
    private static final String INDEX_QUERY_STRING = "    ";
    private FileAdministration fileAdministration = new FileAdministration(this);
    private UploadFileContainer uploadFileContainer = new UploadFileContainer();

    public boolean isHostBusy() {
        return this.uploadFileContainer.getUploadFileCount() >= ServiceManager.sCfg.mMaxUpload;
    }

    public FileAdministration getFileAdministration() {
        return this.fileAdministration;
    }

    public UploadFileContainer getUploadFileContainer() {
        return this.uploadFileContainer;
    }

    public void addUploadFile(UploadFile uploadFile) {
        this.uploadFileContainer.addUploadFile(uploadFile);
    }

    public ShareFile[] handleQuery(MsgQuery msgQuery) {
        List list;
        if ((long)msgQuery.getMinSpeed() * 1024L > (long)ServiceManager.sCfg.mUploadMaxBandwidth) {
            return EMPTY_SEARCH_RESULT;
        }
        String string = msgQuery.getSearchString();
        if (ServiceManager.sCfg.mPhexPingResponse && string.equals(PHEX_PING)) {
            return VERSION_FILE_ARRAY;
        }
        if (string.equals(INDEX_QUERY_STRING)) {
            Logger.logMessage(Logger.FINER, (short)16, "Index query detected.");
            return this.fileAdministration.getSharedFiles();
        }
        URN[] uRNArray = msgQuery.getQueryURNs();
        if (uRNArray.length > 0) {
            list = this.fileAdministration.getFilesByURNs(uRNArray);
            if (list.size() == uRNArray.length) {
                return this.provideResultData(list);
            }
        } else {
            list = Collections.EMPTY_LIST;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        ArrayList<String> arrayList = new ArrayList<String>(Math.min(10, stringTokenizer.countTokens()));
        while (arrayList.size() < 10 && stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() < 2) continue;
            arrayList.add(string2.toLowerCase());
        }
        ShareFile[] shareFileArray = this.fileAdministration.getSharedFiles();
        HashMap hashMap = new HashMap();
        SearchEngine searchEngine = new SearchEngine();
        ArrayList<ShareFile> arrayList2 = new ArrayList<ShareFile>(Arrays.asList(shareFileArray));
        int n = 0;
        while (n < arrayList.size() && arrayList2.size() > 0) {
            searchEngine.setPattern((String)arrayList.get(n), true);
            int n2 = arrayList2.size() - 1;
            while (n2 >= 0) {
                ShareFile shareFile = arrayList2.get(n2);
                searchEngine.setText(shareFile.getSearchCompareTerm(), true);
                if (!searchEngine.match()) {
                    arrayList2.remove(n2);
                }
                --n2;
            }
            ++n;
        }
        if (list.size() > 0) {
            arrayList2.addAll(list);
        }
        return this.provideResultData(arrayList2);
    }

    private ShareFile[] provideResultData(List list) {
        int n = list.size();
        if (n == 0) {
            return EMPTY_SEARCH_RESULT;
        }
        if (n > ServiceManager.sCfg.mUploadMaxSearch) {
            int n2 = n - ServiceManager.sCfg.mUploadMaxSearch;
            list.subList(0, n2).clear();
            n = list.size();
        }
        ShareFile[] shareFileArray = new ShareFile[n];
        shareFileArray = list.toArray(shareFileArray);
        int n3 = 0;
        while (n3 < n) {
            ShareFile shareFile = shareFileArray[n3];
            shareFile.incSearchCount();
            ++n3;
        }
        return shareFileArray;
    }

    public void httpRequestHandler(ConnectionRequest connectionRequest, Host host) throws IOException {
        List<String> list;
        if (!connectionRequest.readHeaders(host.getIs())) {
            Logger.logMessage(Logger.FINE, (short)4, "Error reading HTTP header");
            return;
        }
        if (connectionRequest.getUri().startsWith("/ HTTP/")) {
            this.sendFile(connectionRequest, host);
            return;
        }
        GETRequest gETRequest = new GETRequest(connectionRequest.getUri());
        if (!gETRequest.isFileRequest()) {
            this.sendFile(connectionRequest, host);
            return;
        }
        ShareFile shareFile = null;
        URN uRN = gETRequest.getURN();
        if (uRN != null) {
            shareFile = this.fileAdministration.getFileByURN(uRN);
        } else if (gETRequest.getFileIndex() != -1 && (shareFile = this.fileAdministration.getFileByIndex(gETRequest.getFileIndex())) != null) {
            list = shareFile.getFile();
            if (!gETRequest.getFileName().equalsIgnoreCase(shareFile.getEffectiveName())) {
                shareFile = null;
            }
        }
        if (shareFile == null) {
            if (gETRequest.getFileName() != null) {
                shareFile = this.fileAdministration.getFileByName(gETRequest.getFileName());
            }
            if (shareFile == null) {
                this.sendString(host, this.buildErrorHTTP("404 Not Found", "File not found"));
                return;
            }
        }
        if (shareFile.getURN() != null) {
            String[] stringArray = new String[]{"X-Gnutella-Content-URN: " + shareFile.getURN().getAsString()};
            list = Arrays.asList(stringArray);
        } else {
            list = Collections.EMPTY_LIST;
        }
        this.upload(connectionRequest, host, shareFile.getFile(), true, list);
        shareFile.incUploadCount();
    }

    private boolean upload(ConnectionRequest connectionRequest, Host host, File file, boolean bl) {
        return this.upload(connectionRequest, host, file, bl, Collections.EMPTY_LIST);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean upload(ConnectionRequest var1_1, Host var2_2, File var3_3, boolean var4_4, List var5_5) {
        block59: {
            block52: {
                block58: {
                    block50: {
                        block57: {
                            block49: {
                                block56: {
                                    block48: {
                                        Logger.logMessage(Logger.FINE, (short)4, "Start upload of " + var3_3 + " to " + var2_2);
                                        if (!var4_4) {
                                            Logger.logMessage(Logger.INFO, (short)4, "NON Gnutella net upload: " + var2_2 + "  " + var3_3.getName());
                                        }
                                        var6_6 = null;
                                        var7_7 = null;
                                        var8_8 = ServiceManager.getHostManager();
                                        var9_9 = false;
                                        var10_10 = null;
                                        var11_11 = ThrottleController.acquireThrottle();
                                        var11_11.linkThrottleIntoChain(ServiceManager.getManager().getPhexBandwidthThrottle());
                                        try {
                                            try {
                                                block51: {
                                                    var15_12 = this;
                                                    synchronized (var15_12) {
                                                        if (this.uploadFileContainer.getUploadFileCount() >= ServiceManager.sCfg.mMaxUpload) {
                                                            var2_2.log(Logger.FINE, "Upload request: upload limit reached.");
                                                            this.sendString(var2_2, this.buildErrorHTTP("503 Service Unavailable", "Server busy.  Too many downloads from this host."));
                                                            var16_13 = var9_9;
                                                            // MONITOREXIT @DISABLED, blocks:[0, 1, 5, 47] lbl20 : MonitorExitStatement: MONITOREXIT : var15_12
                                                            var25_16 = null;
                                                            break block48;
                                                        }
                                                        var16_14 = this.uploadFileContainer.getUploadCountPerIP(var2_2.getHostAddress().getHostName());
                                                        if (var16_14 >= ServiceManager.sCfg.mMaxUploadPerIP) {
                                                            var2_2.log(Logger.FINE, "Upload request: upload limit per host reached.");
                                                            this.sendString(var2_2, this.buildErrorHTTP("503 Service Unavailable", "You have too many downloads from this host."));
                                                            var17_30 = var9_9;
                                                            // MONITOREXIT @DISABLED, blocks:[0, 1, 5, 46] lbl29 : MonitorExitStatement: MONITOREXIT : var15_12
                                                            break block49;
                                                        }
                                                        var12_33 = new HttpRange((int)var3_3.length());
                                                        var13_35 = var1_1.getHeader("RANGE");
                                                        if (var13_35 != null) {
                                                            if (!var12_33.deserialize(var13_35)) {
                                                                var2_2.log(Logger.FINE, "Upload request: Invalid range value in partial get.  " + var13_35);
                                                                this.sendString(var2_2, this.buildErrorHTTP("416 Requested Range Not Satisfiable", "Upload request: Invalid range value in partial get.  " + var13_35));
                                                                var17_31 = var9_9;
                                                                // MONITOREXIT @DISABLED, blocks:[0, 1, 5, 43, 45] lbl39 : MonitorExitStatement: MONITOREXIT : var15_12
                                                                break block50;
                                                            }
                                                            if (var12_33.getSpecCount() == 0) {
                                                                var12_33.addSpec(0, (int)var3_3.length() - 1);
                                                            }
                                                        } else {
                                                            var12_33.addSpec(0, (int)var3_3.length() - 1);
                                                        }
                                                        var14_37 = var12_33.getLastPos() - var12_33.getFirstPos() + 1;
                                                        var7_7 = new UploadFile(var3_3, var2_2, var14_37, var1_1.getHeader("USER-AGENT"));
                                                        var7_7.setStatus(3);
                                                        var7_7.setStartingTime(System.currentTimeMillis());
                                                        this.addUploadFile(var7_7);
                                                    }
                                                    var16_15 = new byte[1024];
                                                    var17_32 = new StringBuffer(100);
                                                    var18_38 = "application/binary";
                                                    if (!var4_4) {
                                                        var19_39 = StrUtil.getFileExt(var7_7.getFilename());
                                                        var18_38 = MimeTypeMapping.getMimeTypeForExtension((String)var19_39);
                                                    }
                                                    if (var14_37 == var12_33.getEntitySize()) {
                                                        var17_32.append("HTTP/1.1 200 OK\r\n");
                                                    } else if (var4_4) {
                                                        var17_32.append("HTTP/1.1 200 OK\r\n");
                                                    } else {
                                                        var17_32.append("HTTP/1.1 206 OK\r\n");
                                                    }
                                                    var17_32.append("Server: ");
                                                    var17_32.append(StrUtil.getAppNameVersion());
                                                    var17_32.append("\r\n");
                                                    var17_32.append("Accept-Ranges: bytes\r\n");
                                                    var17_32.append("Connection: close\r\n");
                                                    var17_32.append("Content-Type: ");
                                                    var17_32.append(var18_38);
                                                    var17_32.append("\r\n");
                                                    var19_39 = var5_5.iterator();
                                                    while (true) {
                                                        if (!var19_39.hasNext()) {
                                                            if (var14_37 != var12_33.getEntitySize()) break;
                                                            var17_32.append("Content-length: ");
                                                            var17_32.append(var12_33.getEntitySize());
                                                            var17_32.append("\r\n");
                                                            break block51;
                                                        }
                                                        var20_40 = (String)var19_39.next();
                                                        var17_32.append(var20_40);
                                                        var17_32.append("\r\n");
                                                    }
                                                    var17_32.append("Content-range:bytes ");
                                                    var17_32.append(var12_33.getFirstPos());
                                                    var17_32.append("-");
                                                    var17_32.append(var12_33.getLastPos());
                                                    var17_32.append("/");
                                                    var17_32.append(var12_33.getEntitySize());
                                                    var17_32.append("\r\n");
                                                    var17_32.append("Content-length: ");
                                                    var17_32.append(var14_37);
                                                    var17_32.append("\r\n");
                                                }
                                                var17_32.append("\r\n");
                                                var20_41 = IOUtil.serializeString(var17_32.toString(), var16_15, 0);
                                                var10_10 = var2_2.getSock().getOutputStream();
                                                var10_10.write(var16_15, 0, var20_41);
                                                Logger.logMessage(Logger.FINER, (short)4, "Sending: " + var17_32.toString());
                                                var6_6 = new RandomAccessFile(var3_3, "r");
                                                var6_6.seek(var12_33.getFirstPos());
                                                var21_42 = 0L;
                                                while (var14_37 > 0 && (var20_41 = var6_6.read(var16_15)) != -1) {
                                                    var10_10.write(var16_15, 0, var20_41);
                                                    var14_37 -= var20_41;
                                                    var7_7.setTransferredDataSize(var21_42 += (long)var20_41);
                                                    var11_11.setRate(ServiceManager.sCfg.mUploadMaxBandwidth / this.uploadFileContainer.getUploadFileCount());
                                                    var11_11.controlThrottle(var20_41);
                                                }
                                                var7_7.setTransferredDataSize(var21_42);
                                                var7_7.setStatus(4);
                                                var7_7.setStoppingTime(System.currentTimeMillis());
                                                var23_43 = ServiceManager.getStatisticTracker();
                                                var23_43.incStatUploadCount(1);
                                                var9_9 = true;
                                                Thread.sleep(2000L);
                                                break block52;
                                            }
                                            catch (SocketException var12_34) {
                                                var9_9 = false;
                                                Logger.logMessage(Logger.FINEST, (short)4, var12_34);
                                                if (var7_7 != null && var7_7.getStatus() != 6) {
                                                    var7_7.setStatus(5, var12_34.getMessage());
                                                    var7_7.setStoppingTime(System.currentTimeMillis());
                                                }
                                                var25_20 = null;
                                                ThrottleController.releaseThrottle(var11_11);
                                                var11_11 = null;
                                                if (var6_6 != null) {
                                                    try {
                                                        var6_6.close();
                                                    }
                                                    catch (IOException var26_27) {
                                                        // empty catch block
                                                    }
                                                }
                                                if (var10_10 == null) return var9_9;
                                                try {
                                                    var10_10.close();
                                                    return var9_9;
                                                }
                                                catch (IOException var26_27) {
                                                    return var9_9;
                                                }
                                            }
                                            catch (Exception var13_36) {
                                                block54: {
                                                    var9_9 = false;
                                                    Logger.logMessage(Logger.FINE, (short)4, var13_36);
                                                    if (var7_7 != null && var7_7.getStatus() != 6) {
                                                        var7_7.setStatus(5, var13_36.getMessage());
                                                        var7_7.setStoppingTime(System.currentTimeMillis());
                                                    }
                                                    var25_21 = null;
                                                    ThrottleController.releaseThrottle(var11_11);
                                                    var11_11 = null;
                                                    if (var6_6 != null) {
                                                        ** try [egrp 3[TRYBLOCK] [4 : 1141->1149)] { 
lbl183:
                                                        // 1 sources

                                                        var6_6.close();
                                                        break block54;
lbl185:
                                                        // 1 sources

                                                        catch (IOException var26_28) {
                                                            // empty catch block
                                                        }
                                                    }
                                                }
                                                if (var10_10 == null) return var9_9;
                                                try {}
                                                catch (IOException var26_28) {
                                                    return var9_9;
                                                }
                                                var10_10.close();
                                                return var9_9;
                                            }
                                        }
                                        catch (Throwable var24_44) {
                                            block55: {
                                                var25_22 = null;
                                                ThrottleController.releaseThrottle(var11_11);
                                                var11_11 = null;
                                                if (var6_6 != null) {
                                                    ** try [egrp 3[TRYBLOCK] [4 : 1141->1149)] { 
lbl201:
                                                    // 1 sources

                                                    var6_6.close();
                                                    break block55;
lbl203:
                                                    // 1 sources

                                                    catch (IOException var26_29) {
                                                        // empty catch block
                                                    }
                                                }
                                            }
                                            if (var10_10 == null) throw var24_44;
                                            ** try [egrp 4[TRYBLOCK] [5 : 1156->1164)] { 
lbl208:
                                            // 1 sources

                                            var10_10.close();
                                            throw var24_44;
lbl210:
                                            // 1 sources

                                            catch (IOException var26_29) {
                                                // empty catch block
                                            }
                                            throw var24_44;
                                        }
                                    }
                                    ThrottleController.releaseThrottle(var11_11);
                                    var11_11 = null;
                                    if (var6_6 != null) {
                                        ** try [egrp 3[TRYBLOCK] [4 : 1141->1149)] { 
lbl218:
                                        // 1 sources

                                        var6_6.close();
                                        break block56;
lbl220:
                                        // 1 sources

                                        catch (IOException var26_23) {
                                            // empty catch block
                                        }
                                    }
                                }
                                if (var10_10 == null) return var16_13;
                                ** try [egrp 4[TRYBLOCK] [5 : 1156->1164)] { 
lbl225:
                                // 1 sources

                                var10_10.close();
                                return var16_13;
lbl227:
                                // 1 sources

                                catch (IOException var26_23) {
                                    // empty catch block
                                }
                                return var16_13;
                            }
                            var25_17 = null;
                            ThrottleController.releaseThrottle(var11_11);
                            var11_11 = null;
                            if (var6_6 != null) {
                                ** try [egrp 3[TRYBLOCK] [4 : 1141->1149)] { 
lbl236:
                                // 1 sources

                                var6_6.close();
                                break block57;
lbl238:
                                // 1 sources

                                catch (IOException var26_24) {
                                    // empty catch block
                                }
                            }
                        }
                        if (var10_10 == null) return var17_30;
                        ** try [egrp 4[TRYBLOCK] [5 : 1156->1164)] { 
lbl243:
                        // 1 sources

                        var10_10.close();
                        return var17_30;
lbl245:
                        // 1 sources

                        catch (IOException var26_24) {
                            // empty catch block
                        }
                        return var17_30;
                    }
                    var25_18 = null;
                    ThrottleController.releaseThrottle(var11_11);
                    var11_11 = null;
                    if (var6_6 != null) {
                        ** try [egrp 3[TRYBLOCK] [4 : 1141->1149)] { 
lbl254:
                        // 1 sources

                        var6_6.close();
                        break block58;
lbl256:
                        // 1 sources

                        catch (IOException var26_25) {
                            // empty catch block
                        }
                    }
                }
                if (var10_10 == null) return var17_31;
                ** try [egrp 4[TRYBLOCK] [5 : 1156->1164)] { 
lbl261:
                // 1 sources

                var10_10.close();
                return var17_31;
lbl263:
                // 1 sources

                catch (IOException var26_25) {
                    // empty catch block
                }
                return var17_31;
            }
            var25_19 = null;
            ThrottleController.releaseThrottle(var11_11);
            var11_11 = null;
            if (var6_6 != null) {
                ** try [egrp 3[TRYBLOCK] [4 : 1141->1149)] { 
lbl272:
                // 1 sources

                var6_6.close();
                break block59;
lbl274:
                // 1 sources

                catch (IOException var26_26) {
                    // empty catch block
                }
            }
        }
        if (var10_10 == null) return var9_9;
        try {}
        catch (IOException var26_26) {}
        var10_10.close();
        return var9_9;
        return var9_9;
    }

    private void sendFile(ConnectionRequest connectionRequest, Host host) {
        String string;
        try {
            string = URLDecoder.decode(connectionRequest.getUri());
        }
        catch (Exception exception) {
            host.log(Logger.INFO, "Invalid URI from client.  " + connectionRequest.getUri());
            this.sendString(host, this.buildErrorHTTP("400 Bad Request", "Invalid URI from client.  " + connectionRequest.getUri()));
            return;
        }
        if (string.indexOf("..") != -1) {
            host.log(Logger.INFO, "Invalid URI from client, containing '..'  " + connectionRequest.getUri());
            this.sendString(host, this.buildErrorHTTP("400 Bad Request", "Invalid URI from client.  " + connectionRequest.getUri()));
            return;
        }
        File[] fileArray = this.fileAdministration.getSharedDirectories();
        int n = 0;
        while (n < fileArray.length) {
            File file = fileArray[n];
            String string2 = StrUtil.replaceAllChar(string, '/', File.separator);
            String string3 = file.getAbsolutePath() + string2;
            File file2 = new File(string3);
            if (file2.exists()) {
                if (!file2.isFile()) {
                    File file3 = new File(file2, "index.html");
                    if (file3.exists()) {
                        this.upload(connectionRequest, host, file3, false);
                        return;
                    }
                    file3 = new File(file2, "Index.html");
                    if (file3.exists()) {
                        this.upload(connectionRequest, host, file3, false);
                        return;
                    }
                    file3 = new File(file2, "default.html");
                    if (file3.exists()) {
                        this.upload(connectionRequest, host, file3, false);
                        return;
                    }
                    file3 = new File(file2, "Default.html");
                    if (file3.exists()) {
                        this.upload(connectionRequest, host, file3, false);
                        return;
                    }
                    if (!ServiceManager.sCfg.mShareBrowseDir) {
                        this.sendString(host, this.buildErrorHTTP("403 Forbidden", "Directory browsing is not allowed."));
                    } else {
                        this.sendString(host, this.buildDirListHTTP(file2, string));
                    }
                    return;
                }
                ShareFile shareFile = this.fileAdministration.getFileByName(file2.getAbsolutePath());
                if (shareFile != null) {
                    File file4 = shareFile.getFile();
                    if (this.upload(connectionRequest, host, file4, false)) {
                        shareFile.incUploadCount();
                    }
                } else {
                    this.sendString(host, this.buildErrorHTTP("404 Not Found", "File not found."));
                }
                return;
            }
            ++n;
        }
        this.sendString(host, this.buildErrorHTTP("404 Not Found", "File not found."));
    }

    private void sendString(Host host, String string) {
        try {
            byte[] byArray = new byte[string.length()];
            int n = IOUtil.serializeString(string, byArray, 0);
            int n2 = 0;
            OutputStream outputStream = host.getOs();
            HostManager hostManager = ServiceManager.getHostManager();
            StatisticTracker statisticTracker = ServiceManager.getStatisticTracker();
            while (n2 < n) {
                int n3 = n - n2;
                if (n3 > 1024) {
                    n3 = 1024;
                }
                outputStream.write(byArray, n2, n3);
                n2 += n3;
                statisticTracker.incBytesCount(n3);
                hostManager.throttleControl(n3);
            }
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            Logger.logError(exception, "Exception whily trying to send sting: '" + string + "'");
        }
    }

    private String buildDirListHTTP(File file, String string) {
        File[] fileArray;
        Object object;
        int n;
        StringBuffer stringBuffer = new StringBuffer(1024);
        StringBuffer stringBuffer2 = new StringBuffer(1024);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd KK:mma");
        stringBuffer.append("HTTP/1.1 200 OK\r\n");
        stringBuffer.append("Server: " + StrUtil.getAppNameVersion() + "\r\n");
        stringBuffer.append("Content-Type: text/html\r\n");
        stringBuffer.append("Connection: close\r\n");
        stringBuffer2.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">");
        stringBuffer2.append("<HTML>");
        stringBuffer2.append("<HEAD><TITLE>Index of " + string + "</TITLE></HEAD>");
        stringBuffer2.append("<BODY>");
        stringBuffer2.append("<H3>Index of " + string + "</H3>\n");
        stringBuffer2.append("<PRE>");
        stringBuffer2.append("Name                                   Last Modified           Size       Bytes\n");
        stringBuffer2.append("<HR>");
        if (string.startsWith("/") && string.length() > 1) {
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            n = string.lastIndexOf("/");
            string = string.substring(0, n + 1);
            object = URLEncoder.encode(string);
            stringBuffer2.append("[<A HREF=\"" + (String)object + "\">Parent Directory</A>]\n");
            fileArray = file.listFiles();
        } else {
            ArrayList<File> arrayList = new ArrayList<File>();
            object = this.fileAdministration.getSharedDirectories();
            int n2 = 0;
            while (n2 < ((File[])object).length) {
                File file2 = object[n2];
                fileArray = file2.listFiles();
                int n3 = 0;
                while (n3 < fileArray.length) {
                    arrayList.add(fileArray[n3]);
                    ++n3;
                }
                ++n2;
            }
            fileArray = new File[arrayList.size()];
            int n4 = 0;
            while (n4 < arrayList.size()) {
                fileArray[n4] = (File)arrayList.get(n4);
                ++n4;
            }
        }
        n = 0;
        while (n < fileArray.length) {
            if (!this.fileAdministration.isFileInvalid(fileArray[n])) {
                object = fileArray[n].getName();
                if (!fileArray[n].isFile()) {
                    object = (String)object + "/";
                }
                String string2 = URLEncoder.encode((String)object);
                String string3 = StrUtil.getPadStr((String)object, 39);
                StringBuffer stringBuffer3 = new StringBuffer(string3);
                StrUtil.replaceAllChar(stringBuffer3, '&', "&amp;");
                StrUtil.replaceAllChar(stringBuffer3, '\"', "&quot;");
                StrUtil.replaceAllChar(stringBuffer3, '<', "&lt;");
                StrUtil.replaceAllChar(stringBuffer3, '>', "&gt;");
                String string4 = "<A HREF=\"" + string2 + "\">" + (String)object + "</A>" + stringBuffer3;
                stringBuffer2.append(string4);
                String string5 = simpleDateFormat.format(new Date(fileArray[n].lastModified()));
                stringBuffer2.append(StrUtil.padStringRight(string5, 19));
                String string6 = fileArray[n].isFile() ? StrUtil.formatSizeBytes(fileArray[n].length()) : "-";
                stringBuffer2.append(StrUtil.padStringLeft(string6, 9));
                string6 = fileArray[n].isFile() ? String.valueOf(fileArray[n].length()) : "-";
                stringBuffer2.append(StrUtil.padStringLeft(string6, 12));
                stringBuffer2.append("\n");
            }
            ++n;
        }
        stringBuffer2.append("<HR>");
        stringBuffer2.append("Powered by ");
        stringBuffer2.append(StrUtil.getAppNameVersion());
        stringBuffer2.append("\r\n<A HREF=\"");
        stringBuffer2.append(Res.getStr("Program.Url"));
        stringBuffer2.append("\">");
        stringBuffer2.append(Res.getStr("Program.Url"));
        stringBuffer2.append("</A>\r\n");
        stringBuffer2.append("</PRE>");
        stringBuffer2.append("</BODY>");
        stringBuffer2.append("</HTML>");
        stringBuffer.append("Content-Length: " + stringBuffer2.length() + "\r\n");
        stringBuffer.append("\r\n");
        stringBuffer.append((Object)stringBuffer2);
        return stringBuffer.toString();
    }

    private String buildErrorHTTP(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("HTTP/1.1 " + string + "\r\n");
        stringBuffer.append("Server: " + StrUtil.getAppNameVersion() + "\r\n");
        stringBuffer.append("Connection: close\r\n");
        stringBuffer.append("Content-Type: text/plain\r\n");
        stringBuffer.append("Content-Length: " + string2.length() + "\r\n");
        stringBuffer.append("\r\n");
        stringBuffer.append("<html><head><title>PHEX</title></head><body>");
        stringBuffer.append(string2);
        stringBuffer.append("<hr>Visit the Phex website at ");
        stringBuffer.append("<a href=\"http://phex.sourceforge.net\">http://phex.sourceforge.net</a>.");
        stringBuffer.append("</body>");
        stringBuffer.append("</html>");
        return stringBuffer.toString();
    }
}

