/*
 * Decompiled with CFR 0.152.
 */
package phex.share;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import phex.ServiceManager;
import phex.common.TransferRateService;
import phex.event.AsynchronousDispatcher;
import phex.event.UploadFilesChangeListener;
import phex.share.UploadFile;

public class UploadFileContainer {
    private ArrayList listenerList = new ArrayList(2);
    private ArrayList uploadFileList = new ArrayList();
    private TransferRateService transferRateService = ServiceManager.getTransferRateService();

    public synchronized int getUploadListSize() {
        return this.uploadFileList.size();
    }

    public synchronized int getUploadFileCount() {
        int n = 0;
        int n2 = this.uploadFileList.size() - 1;
        while (n2 >= 0) {
            UploadFile uploadFile = (UploadFile)this.uploadFileList.get(n2);
            if (uploadFile.getStatus() == 3) {
                ++n;
            }
            --n2;
        }
        return n;
    }

    public synchronized UploadFile getUploadFileAt(int n) {
        return (UploadFile)this.uploadFileList.get(n);
    }

    public synchronized void addUploadFile(UploadFile uploadFile) {
        int n = this.uploadFileList.size();
        this.uploadFileList.add(n, uploadFile);
        this.transferRateService.registerTransferDataProvider(uploadFile);
        this.fireUploadFileAdded(n);
    }

    public synchronized int getUploadCountPerIP(String string) {
        int n = 0;
        Iterator iterator = ((AbstractList)this.uploadFileList).iterator();
        while (iterator.hasNext()) {
            UploadFile uploadFile = (UploadFile)iterator.next();
            if (uploadFile.getStatus() != 3 || !uploadFile.getRemoteHost().getHostAddress().getHostName().equals(string)) continue;
            ++n;
        }
        return n;
    }

    public synchronized void cleanUploadFileList() {
        int n = this.uploadFileList.size() - 1;
        while (n >= 0) {
            UploadFile uploadFile = (UploadFile)this.uploadFileList.get(n);
            if (uploadFile.getStatus() != 1 && uploadFile.getStatus() != 3) {
                this.transferRateService.unregisterTransferDataProvider(uploadFile);
                this.uploadFileList.remove(n);
                this.fireUploadFileRemoved(n);
            }
            --n;
        }
    }

    public void addUploadFilesChangeListener(UploadFilesChangeListener uploadFilesChangeListener) {
        this.listenerList.add(uploadFilesChangeListener);
    }

    public void removeUploadFilesChangeListener(UploadFilesChangeListener uploadFilesChangeListener) {
        ((AbstractCollection)this.listenerList).remove(uploadFilesChangeListener);
    }

    private void fireUploadFileChanged(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = UploadFileContainer.this.listenerList.toArray();
                int n2 = objectArray.length - 1;
                while (n2 >= 0) {
                    UploadFilesChangeListener uploadFilesChangeListener = (UploadFilesChangeListener)objectArray[n2];
                    uploadFilesChangeListener.uploadFileChanged(n);
                    --n2;
                }
            }
        });
    }

    private void fireUploadFileAdded(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = UploadFileContainer.this.listenerList.toArray();
                int n2 = objectArray.length - 1;
                while (n2 >= 0) {
                    UploadFilesChangeListener uploadFilesChangeListener = (UploadFilesChangeListener)objectArray[n2];
                    uploadFilesChangeListener.uploadFileAdded(n);
                    --n2;
                }
            }
        });
    }

    private void fireUploadFileRemoved(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = UploadFileContainer.this.listenerList.toArray();
                int n2 = objectArray.length - 1;
                while (n2 >= 0) {
                    UploadFilesChangeListener uploadFilesChangeListener = (UploadFilesChangeListener)objectArray[n2];
                    uploadFilesChangeListener.uploadFileRemoved(n);
                    --n2;
                }
            }
        });
    }

    public void fireUploadFileChanged(UploadFile uploadFile) {
        int n = this.uploadFileList.indexOf(uploadFile);
        if (n >= 0) {
            this.fireUploadFileChanged(n);
        }
    }
}

