/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import phex.ServiceManager;
import phex.utils.StatisticTracker;
import phex.utils.ThrottleController;

public class GnutellaInputStream {
    private int BUFFER_LENGTH = 40;
    private InputStream inStream;
    private ThrottleController throttleController;
    private StatisticTracker statTracker;

    public GnutellaInputStream(InputStream inputStream) {
        this(inputStream, null, true);
    }

    public GnutellaInputStream(InputStream inputStream, ThrottleController throttleController) {
        this(inputStream, throttleController, true);
    }

    public GnutellaInputStream(InputStream inputStream, ThrottleController throttleController, boolean bl) {
        this.inStream = new BufferedInputStream(inputStream);
        this.throttleController = throttleController;
        this.statTracker = ServiceManager.getStatisticTracker();
    }

    public void close() throws IOException {
        this.inStream.close();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.inStream == null) {
            return -1;
        }
        int n3 = this.inStream.read(byArray, n, n2);
        this.statTracker.incBytesCount(n3);
        if (this.throttleController != null) {
            this.throttleController.controlThrottle(n3);
        }
        return n3;
    }

    public String readLine() throws IOException {
        if (this.inStream == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(this.BUFFER_LENGTH);
        int n = 0;
        while (true) {
            int n2 = this.inStream.read();
            ++n;
            if (n2 == -1) {
                return null;
            }
            if (n2 == 10) break;
            if (n2 == 13) continue;
            stringBuffer.append((char)n2);
        }
        this.statTracker.incBytesCount(n);
        if (this.throttleController != null) {
            this.throttleController.controlThrottle(n);
        }
        return stringBuffer.toString();
    }
}

