/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import phex.ServiceManager;
import phex.utils.Localizer;

public final class Logger {
    public static final LogLevel FINEST = new LogLevel(0);
    public static final LogLevel FINER = new LogLevel(1);
    public static final LogLevel FINE = new LogLevel(2);
    public static final LogLevel CONFIG = new LogLevel(3);
    public static final LogLevel INFO = new LogLevel(4);
    public static final LogLevel WARNING = new LogLevel(5);
    public static final LogLevel SEVERE = new LogLevel(6);
    private static String[] verboseLevelName = new String[]{"Finest", "Finer", "Fine", "Config", "Info", "Warning", "Severe"};
    public static final short GLOBAL = 255;
    public static final short DOWNLOAD = 2;
    public static final short UPLOAD = 4;
    public static final short SEARCH = 8;
    public static final short NETWORK = 16;
    public static final short GUI = 32;
    private static short logLevelValue = Logger.SEVERE.value;
    private static short logType = 1;
    private static boolean logToConsole = false;
    private static File logFile;
    private static PrintWriter logWriter;
    private static DateFormat dateFormat;
    private static Date date;
    private static long maxLogFileLength;

    private Logger() {
    }

    public static void logError(Throwable throwable) {
        if (logLevelValue > Logger.SEVERE.value || (0xFF & logType) == 0) {
            return;
        }
        String string = Logger.getStackTrace(throwable);
        Object[] objectArray = new Object[]{string};
        Logger.logMessage(SEVERE, (short)255, "log.core.exp", objectArray);
    }

    public static void logError(Throwable throwable, String string) {
        if (logLevelValue > Logger.SEVERE.value || (0xFF & logType) == 0) {
            return;
        }
        String string2 = Logger.getStackTrace(throwable);
        Object[] objectArray = new Object[]{string2, string};
        Logger.logMessage(SEVERE, (short)255, "log.core.expmsg", objectArray);
    }

    public static void logError(short s, String string) {
        if (logLevelValue > Logger.SEVERE.value || (s & logType) == 0) {
            return;
        }
        Object[] objectArray = new Object[]{string};
        Logger.logMessage(SEVERE, s, "log.core.msg", objectArray);
    }

    public static void logWarning(Throwable throwable) {
        if (logLevelValue > Logger.WARNING.value || (0xFF & logType) == 0) {
            return;
        }
        String string = Logger.getStackTrace(throwable);
        Object[] objectArray = new Object[]{string};
        Logger.logMessage(WARNING, (short)255, "log.core.exp", objectArray);
    }

    public static void logWarning(short s, Throwable throwable) {
        if (logLevelValue > Logger.WARNING.value || (s & logType) == 0) {
            return;
        }
        String string = Logger.getStackTrace(throwable);
        Object[] objectArray = new Object[]{string};
        Logger.logMessage(WARNING, s, "log.core.exp", objectArray);
    }

    public static void logWarning(short s, String string) {
        if (logLevelValue > Logger.WARNING.value || (s & logType) == 0) {
            return;
        }
        Object[] objectArray = new Object[]{string};
        Logger.logMessage(WARNING, s, "log.core.msg", objectArray);
    }

    public static void logWarning(short s, Throwable throwable, String string) {
        if (logLevelValue > Logger.WARNING.value || (s & logType) == 0) {
            return;
        }
        String string2 = Logger.getStackTrace(throwable);
        Object[] objectArray = new Object[]{string2, string};
        Logger.logMessage(WARNING, s, "log.core.expmsg", objectArray);
    }

    public static void logWarning(Throwable throwable, String string) {
        if (logLevelValue > Logger.WARNING.value || (0xFF & logType) == 0) {
            return;
        }
        String string2 = Logger.getStackTrace(throwable);
        Object[] objectArray = new Object[]{string2, string};
        Logger.logMessage(WARNING, (short)255, "log.core.expmsg", objectArray);
    }

    public static void logMessage(LogLevel logLevel, short s, Object object) {
        if (logLevelValue > logLevel.value || (s & logType) == 0) {
            return;
        }
        Object[] objectArray = new Object[]{object};
        Logger.logMessage(logLevel, s, "log.core.msg", objectArray);
    }

    public static void logMessage(LogLevel logLevel, short s, Throwable throwable) {
        if (logLevelValue > logLevel.value || (s & logType) == 0) {
            return;
        }
        String string = Logger.getStackTrace(throwable);
        Object[] objectArray = new Object[]{string};
        Logger.logMessage(logLevel, s, "log.core.exp", objectArray);
    }

    public static void logMessage(LogLevel logLevel, short s, Throwable throwable, Object object) {
        if (logLevelValue > logLevel.value || (s & logType) == 0) {
            return;
        }
        String string = Logger.getStackTrace(throwable);
        Object[] objectArray = new Object[]{string, object};
        Logger.logMessage(logLevel, s, "log.core.expmsg", objectArray);
    }

    public static void logMessage(LogLevel logLevel, short s, String string, Object[] objectArray) {
        if (logLevelValue > logLevel.value || (s & logType) == 0) {
            return;
        }
        String string2 = Localizer.getFormatedString(string, objectArray);
        Logger.writeLogMessage(logLevel, s, string2);
    }

    public static void setLogFileName(String string) {
        logFile = new File(string);
        logWriter = null;
    }

    public static void setLogToConsole(boolean bl) {
        logToConsole = bl;
    }

    public static void setMaxLogFileLength(long l) {
        maxLogFileLength = l;
    }

    public static void setVerboseLevel(short s) {
        if (s >= Logger.FINEST.value && s <= Logger.SEVERE.value) {
            logLevelValue = s;
        }
    }

    public static int getVerboseLevel() {
        return logLevelValue;
    }

    public static void setLogType(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        logType = (short)(1 | (bl ? 2 : 0) | (bl2 ? 4 : 0) | (bl3 ? 8 : 0) | (bl4 ? 16 : 0) | (bl5 ? 32 : 0));
    }

    public static void setLogType(short s) {
        if (s >= 1 && s <= 255) {
            logType = s;
        }
    }

    public static boolean isTypeLogged(short s) {
        return (s & logType) > 0;
    }

    public static boolean isLevelLogged(LogLevel logLevel) {
        return logLevelValue <= logLevel.value;
    }

    private static void writeLogMessage(LogLevel logLevel, short s, String string) {
        StringBuffer stringBuffer = new StringBuffer(40 + string.length());
        stringBuffer.append(Logger.getTimeString());
        stringBuffer.append(": ");
        stringBuffer.append(Logger.getLogTypeName(s));
        stringBuffer.append('(');
        stringBuffer.append(Logger.getLogLevelName(logLevel));
        stringBuffer.append(")! ");
        stringBuffer.append(string);
        if (logToConsole) {
            System.err.println(stringBuffer.toString());
        }
        Logger.initLogFileWriter();
        logWriter.println(stringBuffer.toString());
        if (logFile != null && logFile.length() > maxLogFileLength) {
            if (logWriter != null) {
                logWriter.close();
            }
            logWriter = null;
            File file = new File(logFile.getAbsolutePath() + ".1");
            file.delete();
            logFile.renameTo(file);
        }
    }

    private static String getLogTypeName(short s) {
        switch (s) {
            case 2: {
                return "Download";
            }
            case 4: {
                return "Upload";
            }
            case 8: {
                return "Search";
            }
            case 16: {
                return "Network";
            }
            case 32: {
                return "GUI";
            }
            case 255: {
                return "Global";
            }
        }
        return "Unknwon (" + s + ')';
    }

    private static String getLogLevelName(LogLevel logLevel) {
        if (logLevel.value >= 0 && logLevel.value < verboseLevelName.length) {
            return verboseLevelName[logLevel.value];
        }
        return "Unknwon (" + logLevel.value + ')';
    }

    private static String getTimeString() {
        if (dateFormat == null) {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getTimeInstance(2);
            simpleDateFormat.applyPattern(simpleDateFormat.toPattern() + ".SSSS");
            dateFormat = simpleDateFormat;
        }
        if (date == null) {
            date = new Date(System.currentTimeMillis());
        } else {
            date.setTime(System.currentTimeMillis());
        }
        return dateFormat.format(date);
    }

    private static String getStackTrace(Throwable throwable) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        while (throwable != null) {
            throwable.printStackTrace(printWriter);
            throwable = throwable instanceof InvocationTargetException ? ((InvocationTargetException)throwable).getTargetException() : null;
        }
        return charArrayWriter.toString();
    }

    private static void initLogFileWriter() {
        if (logWriter != null) {
            return;
        }
        if (logFile != null) {
            logFile.getParentFile().mkdirs();
            try {
                logWriter = new PrintWriter((Writer)new BufferedWriter(new FileWriter(logFile.getPath(), true)), true);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            logToConsole = false;
            logWriter = new PrintWriter(System.err, true);
        }
    }

    static {
        Logger.setLogFileName(ServiceManager.getLogFileName());
        Logger.setVerboseLevel(ServiceManager.sCfg.loggerVerboseLevel);
        Logger.setLogType(ServiceManager.sCfg.logType);
        Logger.setLogToConsole(ServiceManager.sCfg.logToConsole);
        Logger.setMaxLogFileLength(ServiceManager.sCfg.maxLogFileLength);
    }

    public static final class LogLevel {
        public final short value;

        public LogLevel(short s) {
            this.value = s;
        }
    }
}

