/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.util.LinkedList;
import phex.utils.WindowPane;

final class SlidingWindow {
    private final LinkedList windowPanes = new LinkedList();
    private WindowPane currentPane;

    public SlidingWindow(int n) {
        int n2 = 0;
        while (n2 < n) {
            this.windowPanes.add(new WindowPane());
            ++n2;
        }
        this.currentPane = (WindowPane)this.windowPanes.getFirst();
    }

    public void slideWindow(long l) {
        long l2 = this.currentPane.maxBytesTransfered - this.currentPane.bytesTransfered;
        if (l2 > 0L) {
            l2 = (long)((float)l2 * 0.1f);
        }
        this.currentPane = (WindowPane)this.windowPanes.removeLast();
        this.windowPanes.addFirst(this.currentPane);
        this.currentPane.setNewContents(0L, l + l2);
    }

    public boolean addBytesTransfered(long l) {
        this.currentPane.bytesTransfered += l;
        return this.currentPane.bytesTransfered >= this.currentPane.maxBytesTransfered;
    }

    public long getBytesTransfered() {
        return this.currentPane.bytesTransfered;
    }

    public long getMaxTransferAllowed() {
        return this.currentPane.maxBytesTransfered;
    }
}

