/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import phex.Res;
import phex.config.Cfg;
import phex.utils.HexConverter;
import phex.utils.Localizer;

public final class StrUtil {
    private static String sBlanks = "                                                                                                           ";
    public static final long s1kB = 1024L;
    public static final long s1MB = 0x100000L;
    public static final long s1GB = 0x40000000L;
    public static final long s1TB = 0x10000000000L;
    public static final long s1PB = 0x4000000000000L;
    public static DecimalFormat byteFormat = new DecimalFormat("0.00");
    public static NumberFormat FILE_LENGTH_FORMAT = NumberFormat.getInstance();

    public static String getAppNameVersion() {
        return "PHEX " + Res.getStr("Program.Version") + " " + Res.getStr("Program.VersionComment");
    }

    public static String padStringLeft(String string, int n) {
        return StrUtil.getPadStr(string, n) + string;
    }

    public static String padStringRight(String string, int n) {
        return string + StrUtil.getPadStr(string, n);
    }

    public static String getPadStr(String string, int n) {
        int n2 = string.length();
        if (n2 >= n) {
            return " ";
        }
        return sBlanks.substring(0, n - n2);
    }

    public static String makeShortName(String string, int n) {
        int n2 = string.length();
        if (n2 <= n) {
            return string;
        }
        int n3 = -1;
        if (n2 > 255) {
            n2 = 255;
        }
        int n4 = 0;
        while (n4 < n2) {
            n3 = (byte)(n3 ^ (byte)string.charAt(n4));
            ++n4;
        }
        byte[] byArray = new byte[]{(byte)n2};
        String string2 = HexConverter.toHexString(byArray);
        byArray[0] = n3;
        String string3 = HexConverter.toHexString(byArray);
        int n5 = string.lastIndexOf(".");
        if (n5 >= string.length() - 4) {
            String string4 = string.substring(n5);
            int n6 = string.length() - n5;
            string = string.substring(0, n - 4 - n6);
            return string + string2 + string3 + string4;
        }
        string = string.substring(0, n - 4);
        return string + string2 + string3;
    }

    public static String getFileExt(String string) {
        int n = string.lastIndexOf(".");
        if (n > -1) {
            return string.substring(n + 1, string.length());
        }
        return "";
    }

    public static StringBuffer replaceAllChar(StringBuffer stringBuffer, char c, String string) {
        int n = stringBuffer.length() - 1;
        while (n >= 0) {
            if (stringBuffer.charAt(n) == c) {
                stringBuffer.setCharAt(n, string.charAt(0));
                if (string.length() > 1) {
                    stringBuffer.insert(n + 1, string.substring(1));
                }
            }
            --n;
        }
        return stringBuffer;
    }

    public static String replaceAllChar(String string, char c, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        StrUtil.replaceAllChar(stringBuffer, c, string2);
        return stringBuffer.toString();
    }

    public static String[] hashtableKeys2Strings(Hashtable hashtable) {
        String[] stringArray = new String[hashtable.size()];
        int n = 0;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public static String parseHost(String string) {
        int n = string.indexOf(":");
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String parsePort(String string) {
        int n = string.indexOf(":");
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static String parseURLHostPort(String string) {
        try {
            int n = string.indexOf("//");
            if (n == -1) {
                return null;
            }
            n = string.indexOf("/", n + 2);
            return string.substring(0, n);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String formatTime(int n) {
        int n2 = n / 3600;
        int n3 = (n - n2 * 3600) / 60;
        int n4 = n - n2 * 3600 - n3 * 60;
        StringBuffer stringBuffer = new StringBuffer(16);
        if (n2 > 9) {
            stringBuffer.append(n2);
        } else {
            stringBuffer.append("0");
            stringBuffer.append(n2);
        }
        stringBuffer.append(":");
        if (n3 > 9) {
            stringBuffer.append(n3);
        } else {
            stringBuffer.append("0");
            stringBuffer.append(n3);
        }
        stringBuffer.append(":");
        if (n4 > 9) {
            stringBuffer.append(n4);
        } else {
            stringBuffer.append("0");
            stringBuffer.append(n4);
        }
        return stringBuffer.toString();
    }

    public static String formatSignificantElapsedTime(long l) {
        long l2 = l / 86400L;
        if (l2 > 0L) {
            Object[] objectArray = new Object[]{new Long(l2), new Integer((int)(l / 3600L % 24L))};
            return Localizer.getFormatedString("TimeFormatDH", objectArray);
        }
        int n = (int)(l / 3600L % 24L);
        if (n > 0) {
            Object[] objectArray = new Object[]{new Integer(n), new Integer((int)(l / 60L % 60L))};
            return Localizer.getFormatedString("TimeFormatHM", objectArray);
        }
        int n2 = (int)(l / 60L % 60L);
        if (n2 > 0) {
            Object[] objectArray = new Object[]{new Integer(n2), new Integer((int)(l % 60L))};
            return Localizer.getFormatedString("TimeFormatMS", objectArray);
        }
        int n3 = (int)(l % 60L);
        Object[] objectArray = new Object[]{new Integer(n3)};
        return Localizer.getFormatedString("TimeFormatS", objectArray);
    }

    public static String formatSizeBytes(double d) {
        StringBuffer stringBuffer = new StringBuffer(16);
        if (d < 1024.0) {
            byteFormat.format(d, stringBuffer, new FieldPosition(0)).append(" bytes");
        } else if (d < 1048576.0) {
            double d2 = d / 1024.0;
            byteFormat.format(d2, stringBuffer, new FieldPosition(0)).append(" KB");
        } else if (d < 1.073741824E9) {
            double d3 = d / 1048576.0;
            byteFormat.format(d3, stringBuffer, new FieldPosition(0)).append(" MB");
        } else if (d < 1.099511627776E12) {
            double d4 = d / 1.073741824E9;
            byteFormat.format(d4, stringBuffer, new FieldPosition(0)).append(" GB");
        } else if (d < 1.125899906842624E15) {
            double d5 = d / 1.099511627776E12;
            byteFormat.format(d5, stringBuffer, new FieldPosition(0)).append(" TB");
        } else {
            double d6 = d / 1.125899906842624E15;
            byteFormat.format(d6, stringBuffer, new FieldPosition(0)).append(" PB");
        }
        return stringBuffer.toString();
    }

    public static String createNaturalSearchTerm(String string) {
        StringTokenizer stringTokenizer;
        int n;
        int n2 = string.lastIndexOf(".");
        if (n2 >= 0) {
            string = string.substring(0, n2);
        }
        if ((n = (stringTokenizer = new StringTokenizer(string, "-._()[]")).countTokens()) == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() < Cfg.MIN_SEARCH_TERM_LENGTH) continue;
            stringBuffer.append(string2);
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }
}

