/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

class vncCanvas
extends Canvas {
    static final int maxZlibHexBufSize = 278;
    vncviewer v;
    rfbProto rfb;
    ColorModel cm;
    Color[] colors;
    Image rawPixelsImage;
    animatedMemoryImageSource amis;
    byte[] pixels;
    byte[] zlibBuf;
    int zlibBufLen;
    Inflater zlibInflater;
    Inflater zlibInflaterRaw;
    Inflater zlibInflaterHex;
    int fgVal;
    int bgVal;
    Graphics sg;
    Graphics sg2;
    Image paintImage;
    Graphics pig;
    Graphics pig2;
    boolean needToResetClip;

    vncCanvas(vncviewer v1) throws IOException {
        this.v = v1;
        this.rfb = this.v.rfb;
        this.cm = new DirectColorModel(8, 7, 56, 192);
        this.rfb.writeSetPixelFormat(8, 8, false, true, 7, 7, 3, 0, 3, 6);
        this.colors = new Color[256];
        int i = 0;
        while (i < 256) {
            this.colors[i] = new Color(this.cm.getRGB(i));
            ++i;
        }
        this.pixels = new byte[this.rfb.framebufferWidth * this.rfb.framebufferHeight];
        this.amis = new animatedMemoryImageSource(this.rfb.framebufferWidth, this.rfb.framebufferHeight, this.cm, this.pixels);
        this.rawPixelsImage = this.createImage(this.amis);
        this.paintImage = this.v.createImage(this.rfb.framebufferWidth, this.rfb.framebufferHeight);
        this.pig = this.paintImage.getGraphics();
    }

    public Dimension preferredSize() {
        return new Dimension(this.rfb.framebufferWidth, this.rfb.framebufferHeight);
    }

    public Dimension minimumSize() {
        return new Dimension(this.rfb.framebufferWidth, this.rfb.framebufferHeight);
    }

    public void update(Graphics g) {
    }

    public void paint(Graphics g) {
        g.drawImage(this.paintImage, 0, 0, this);
    }

    public void processNormalProtocol() throws IOException {
        int msgType;
        this.rfb.writeFramebufferUpdateRequest(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight, false);
        this.sg = this.getGraphics();
        this.needToResetClip = false;
        block21: while (true) {
            msgType = this.rfb.readServerMessageType();
            switch (msgType) {
                case 0: {
                    this.rfb.readFramebufferUpdate();
                    int i = 0;
                    while (i < this.rfb.updateNRects) {
                        this.rfb.readFramebufferUpdateRectHdr();
                        if (this.needToResetClip && this.rfb.updateRectEncoding != 0) {
                            try {
                                this.sg.setClip(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight);
                                this.pig.setClip(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight);
                            }
                            catch (NoSuchMethodError noSuchMethodError) {}
                            this.needToResetClip = false;
                        }
                        switch (this.rfb.updateRectEncoding) {
                            case 0: {
                                this.drawRawRect(this.rfb.updateRectX, this.rfb.updateRectY, this.rfb.updateRectW, this.rfb.updateRectH);
                                break;
                            }
                            case 1: {
                                this.rfb.readCopyRect();
                                this.pig.copyArea(this.rfb.copyRectSrcX, this.rfb.copyRectSrcY, this.rfb.updateRectW, this.rfb.updateRectH, this.rfb.updateRectX - this.rfb.copyRectSrcX, this.rfb.updateRectY - this.rfb.copyRectSrcY);
                                if (this.v.options.copyRectFast) {
                                    this.sg.copyArea(this.rfb.copyRectSrcX, this.rfb.copyRectSrcY, this.rfb.updateRectW, this.rfb.updateRectH, this.rfb.updateRectX - this.rfb.copyRectSrcX, this.rfb.updateRectY - this.rfb.copyRectSrcY);
                                    break;
                                }
                                this.sg.drawImage(this.paintImage, 0, 0, this);
                                break;
                            }
                            case 2: {
                                int h;
                                int w;
                                int y;
                                int x;
                                int pixel;
                                int nSubrects = this.rfb.is.readInt();
                                int bg = this.rfb.is.read();
                                this.sg.translate(this.rfb.updateRectX, this.rfb.updateRectY);
                                this.sg.setColor(this.colors[bg]);
                                this.sg.fillRect(0, 0, this.rfb.updateRectW, this.rfb.updateRectH);
                                this.pig.translate(this.rfb.updateRectX, this.rfb.updateRectY);
                                this.pig.setColor(this.colors[bg]);
                                this.pig.fillRect(0, 0, this.rfb.updateRectW, this.rfb.updateRectH);
                                int j = 0;
                                while (j < nSubrects) {
                                    pixel = this.rfb.is.read();
                                    x = this.rfb.is.readUnsignedShort();
                                    y = this.rfb.is.readUnsignedShort();
                                    w = this.rfb.is.readUnsignedShort();
                                    h = this.rfb.is.readUnsignedShort();
                                    this.sg.setColor(this.colors[pixel]);
                                    this.sg.fillRect(x, y, w, h);
                                    this.pig.setColor(this.colors[pixel]);
                                    this.pig.fillRect(x, y, w, h);
                                    ++j;
                                }
                                this.sg.translate(-this.rfb.updateRectX, -this.rfb.updateRectY);
                                this.pig.translate(-this.rfb.updateRectX, -this.rfb.updateRectY);
                                break;
                            }
                            case 4: {
                                int h;
                                int w;
                                int y;
                                int x;
                                int pixel;
                                int nSubrects = this.rfb.is.readInt();
                                int bg = this.rfb.is.read();
                                this.sg.translate(this.rfb.updateRectX, this.rfb.updateRectY);
                                this.sg.setColor(this.colors[bg]);
                                this.sg.fillRect(0, 0, this.rfb.updateRectW, this.rfb.updateRectH);
                                this.pig.translate(this.rfb.updateRectX, this.rfb.updateRectY);
                                this.pig.setColor(this.colors[bg]);
                                this.pig.fillRect(0, 0, this.rfb.updateRectW, this.rfb.updateRectH);
                                int j = 0;
                                while (j < nSubrects) {
                                    pixel = this.rfb.is.read();
                                    x = this.rfb.is.read();
                                    y = this.rfb.is.read();
                                    w = this.rfb.is.read();
                                    h = this.rfb.is.read();
                                    this.sg.setColor(this.colors[pixel]);
                                    this.sg.fillRect(x, y, w, h);
                                    this.pig.setColor(this.colors[pixel]);
                                    this.pig.fillRect(x, y, w, h);
                                    ++j;
                                }
                                this.sg.translate(-this.rfb.updateRectX, -this.rfb.updateRectY);
                                this.pig.translate(-this.rfb.updateRectX, -this.rfb.updateRectY);
                                break;
                            }
                            case 5: {
                                int subencoding;
                                int th;
                                int tw;
                                int tx;
                                this.fgVal = 0;
                                this.bgVal = 0;
                                int ty = this.rfb.updateRectY;
                                while (ty < this.rfb.updateRectY + this.rfb.updateRectH) {
                                    tx = this.rfb.updateRectX;
                                    while (tx < this.rfb.updateRectX + this.rfb.updateRectW) {
                                        tw = 16;
                                        th = 16;
                                        if (this.rfb.updateRectX + this.rfb.updateRectW - tx < 16) {
                                            tw = this.rfb.updateRectX + this.rfb.updateRectW - tx;
                                        }
                                        if (this.rfb.updateRectY + this.rfb.updateRectH - ty < 16) {
                                            th = this.rfb.updateRectY + this.rfb.updateRectH - ty;
                                        }
                                        if (((subencoding = this.rfb.is.read()) & 1) != 0) {
                                            this.drawRawRect(tx, ty, tw, th);
                                        } else {
                                            if (this.needToResetClip) {
                                                try {
                                                    this.sg.setClip(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight);
                                                    this.pig.setClip(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight);
                                                }
                                                catch (NoSuchMethodError noSuchMethodError) {}
                                                this.needToResetClip = false;
                                            }
                                            this.drawHextileTileStream(tx, ty, tw, th, subencoding);
                                        }
                                        tx += 16;
                                    }
                                    ty += 16;
                                }
                                break;
                            }
                            case 6: {
                                int nBytes = this.rfb.is.readInt();
                                if (this.zlibBuf == null || this.zlibBufLen < nBytes) {
                                    this.zlibBuf = new byte[nBytes * 2];
                                    this.zlibBufLen = nBytes * 2;
                                }
                                this.rfb.is.readFully(this.zlibBuf, 0, nBytes);
                                if (this.zlibInflater == null) {
                                    this.zlibInflater = new Inflater();
                                }
                                this.zlibInflater.setInput(this.zlibBuf, 0, nBytes);
                                this.drawZlibRect(this.rfb.updateRectX, this.rfb.updateRectY, this.rfb.updateRectW, this.rfb.updateRectH, this.zlibInflater);
                                break;
                            }
                            case 8: {
                                int subencoding;
                                int th;
                                int tw;
                                int tx;
                                this.fgVal = 0;
                                this.bgVal = 0;
                                if (this.zlibBuf == null || this.zlibBufLen < 278) {
                                    this.zlibBuf = new byte[556];
                                    this.zlibBufLen = 556;
                                }
                                int ty = this.rfb.updateRectY;
                                while (ty < this.rfb.updateRectY + this.rfb.updateRectH) {
                                    tx = this.rfb.updateRectX;
                                    while (tx < this.rfb.updateRectX + this.rfb.updateRectW) {
                                        int nBytes;
                                        tw = 16;
                                        th = 16;
                                        if (this.rfb.updateRectX + this.rfb.updateRectW - tx < 16) {
                                            tw = this.rfb.updateRectX + this.rfb.updateRectW - tx;
                                        }
                                        if (this.rfb.updateRectY + this.rfb.updateRectH - ty < 16) {
                                            th = this.rfb.updateRectY + this.rfb.updateRectH - ty;
                                        }
                                        if (((subencoding = this.rfb.is.read()) & 1) != 0) {
                                            this.drawRawRect(tx, ty, tw, th);
                                        } else if ((subencoding & 0x20) != 0) {
                                            nBytes = this.rfb.is.readUnsignedShort();
                                            this.rfb.is.readFully(this.zlibBuf, 0, nBytes);
                                            if (this.zlibInflaterRaw == null) {
                                                this.zlibInflaterRaw = new Inflater();
                                            }
                                            this.zlibInflaterRaw.setInput(this.zlibBuf, 0, nBytes);
                                            this.drawZlibRect(tx, ty, tw, th, this.zlibInflaterRaw);
                                        } else {
                                            if (this.needToResetClip) {
                                                try {
                                                    this.sg.setClip(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight);
                                                    this.pig.setClip(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight);
                                                }
                                                catch (NoSuchMethodError noSuchMethodError) {}
                                                this.needToResetClip = false;
                                            }
                                            if ((subencoding & 0x40) != 0) {
                                                nBytes = this.rfb.is.readUnsignedShort();
                                                this.rfb.is.readFully(this.zlibBuf, 0, nBytes);
                                                if (this.zlibInflaterHex == null) {
                                                    this.zlibInflaterHex = new Inflater();
                                                }
                                                this.zlibInflaterHex.setInput(this.zlibBuf, 0, nBytes);
                                                this.drawHextileTileZlib(tx, ty, tw, th, subencoding, this.zlibInflaterHex);
                                            } else {
                                                this.drawHextileTileStream(tx, ty, tw, th, subencoding);
                                            }
                                        }
                                        tx += 16;
                                    }
                                    ty += 16;
                                }
                                break;
                            }
                            default: {
                                throw new IOException("Unknown RFB rectangle encoding " + this.rfb.updateRectEncoding);
                            }
                        }
                        ++i;
                    }
                    this.rfb.writeFramebufferUpdateRequest(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight, true);
                    continue block21;
                }
                case 1: {
                    throw new IOException("Can't handle SetColourMapEntries message");
                }
                case 2: {
                    System.out.print('\u0007');
                    continue block21;
                }
                case 3: {
                    String s = this.rfb.readServerCutText();
                    this.v.clipboard.setCutText(s);
                    continue block21;
                }
            }
            break;
        }
        throw new IOException("Unknown RFB message type " + msgType);
    }

    void drawRawRect(int x, int y, int w, int h) throws IOException {
        if (this.v.options.drawEachPixelForRawRects) {
            int j = y;
            while (j < y + h) {
                int k = x;
                while (k < x + w) {
                    int pixel = this.rfb.is.read();
                    this.sg.setColor(this.colors[pixel]);
                    this.sg.fillRect(k, j, 1, 1);
                    this.pig.setColor(this.colors[pixel]);
                    this.pig.fillRect(k, j, 1, 1);
                    ++k;
                }
                ++j;
            }
            return;
        }
        int j = y;
        while (j < y + h) {
            this.rfb.is.readFully(this.pixels, j * this.rfb.framebufferWidth + x, w);
            ++j;
        }
        this.handleUpdatedPixels(x, y, w, h);
    }

    void drawHextileTileZlib(int tx, int ty, int tw, int th, int subencoding, Inflater sourceInflater) throws IOException {
        int bufIndex = 0;
        byte[] hexData = new byte[tw * th + 2];
        try {
            sourceInflater.inflate(hexData, 0, tw * th + 2);
        }
        catch (DataFormatException dfe) {
            throw new IOException(dfe.toString());
        }
        if ((subencoding & 2) != 0) {
            this.bgVal = 0xFF & hexData[bufIndex++];
        }
        this.sg.setColor(this.colors[this.bgVal]);
        this.sg.fillRect(tx, ty, tw, th);
        this.pig.setColor(this.colors[this.bgVal]);
        this.pig.fillRect(tx, ty, tw, th);
        if ((subencoding & 4) != 0) {
            this.fgVal = 0xFF & hexData[bufIndex++];
        }
        if ((subencoding & 8) == 0) {
            return;
        }
        int nSubrects = 0xFF & hexData[bufIndex++];
        this.sg.translate(tx, ty);
        this.pig.translate(tx, ty);
        if ((subencoding & 0x10) != 0) {
            int j = 0;
            while (j < nSubrects) {
                this.fgVal = 0xFF & hexData[bufIndex++];
                int b1 = 0xFF & hexData[bufIndex++];
                int b2 = 0xFF & hexData[bufIndex++];
                int sx = b1 >> 4;
                int sy = b1 & 0xF;
                int sw = (b2 >> 4) + 1;
                int sh = (b2 & 0xF) + 1;
                this.sg.setColor(this.colors[this.fgVal]);
                this.sg.fillRect(sx, sy, sw, sh);
                this.pig.setColor(this.colors[this.fgVal]);
                this.pig.fillRect(sx, sy, sw, sh);
                ++j;
            }
        } else {
            this.sg.setColor(this.colors[this.fgVal]);
            this.pig.setColor(this.colors[this.fgVal]);
            int j = 0;
            while (j < nSubrects) {
                int b1 = 0xFF & hexData[bufIndex++];
                int b2 = 0xFF & hexData[bufIndex++];
                int sx = b1 >> 4;
                int sy = b1 & 0xF;
                int sw = (b2 >> 4) + 1;
                int sh = (b2 & 0xF) + 1;
                this.sg.fillRect(sx, sy, sw, sh);
                this.pig.fillRect(sx, sy, sw, sh);
                ++j;
            }
        }
        this.sg.translate(-tx, -ty);
        this.pig.translate(-tx, -ty);
    }

    void drawHextileTileStream(int tx, int ty, int tw, int th, int subencoding) throws IOException {
        if ((subencoding & 2) != 0) {
            this.bgVal = this.rfb.is.read();
        }
        this.sg.setColor(this.colors[this.bgVal]);
        this.sg.fillRect(tx, ty, tw, th);
        this.pig.setColor(this.colors[this.bgVal]);
        this.pig.fillRect(tx, ty, tw, th);
        if ((subencoding & 4) != 0) {
            this.fgVal = this.rfb.is.read();
        }
        if ((subencoding & 8) == 0) {
            return;
        }
        int nSubrects = this.rfb.is.read();
        this.sg.translate(tx, ty);
        this.pig.translate(tx, ty);
        if ((subencoding & 0x10) != 0) {
            int j = 0;
            while (j < nSubrects) {
                this.fgVal = this.rfb.is.read();
                int b1 = this.rfb.is.read();
                int b2 = this.rfb.is.read();
                int sx = b1 >> 4;
                int sy = b1 & 0xF;
                int sw = (b2 >> 4) + 1;
                int sh = (b2 & 0xF) + 1;
                this.sg.setColor(this.colors[this.fgVal]);
                this.sg.fillRect(sx, sy, sw, sh);
                this.pig.setColor(this.colors[this.fgVal]);
                this.pig.fillRect(sx, sy, sw, sh);
                ++j;
            }
        } else {
            this.sg.setColor(this.colors[this.fgVal]);
            this.pig.setColor(this.colors[this.fgVal]);
            int j = 0;
            while (j < nSubrects) {
                int b1 = this.rfb.is.read();
                int b2 = this.rfb.is.read();
                int sx = b1 >> 4;
                int sy = b1 & 0xF;
                int sw = (b2 >> 4) + 1;
                int sh = (b2 & 0xF) + 1;
                this.sg.fillRect(sx, sy, sw, sh);
                this.pig.fillRect(sx, sy, sw, sh);
                ++j;
            }
        }
        this.sg.translate(-tx, -ty);
        this.pig.translate(-tx, -ty);
    }

    void drawZlibRect(int x, int y, int w, int h, Inflater sourceInflater) throws IOException {
        if (this.v.options.drawEachPixelForRawRects) {
            byte[] nextLine = new byte[w];
            int j = y;
            while (j < y + h) {
                try {
                    sourceInflater.inflate(nextLine, 0, w);
                }
                catch (DataFormatException dfe) {
                    throw new IOException(dfe.toString());
                }
                int k = x;
                while (k < x + w) {
                    Color myColor = this.colors[0xFF & nextLine[k - x]];
                    this.sg.setColor(myColor);
                    this.sg.fillRect(k, j, 1, 1);
                    this.pig.setColor(myColor);
                    this.pig.fillRect(k, j, 1, 1);
                    ++k;
                }
                ++j;
            }
            return;
        }
        try {
            int j = y;
            while (j < y + h) {
                sourceInflater.inflate(this.pixels, j * this.rfb.framebufferWidth + x, w);
                ++j;
            }
        }
        catch (DataFormatException dfe) {
            throw new IOException(dfe.toString());
        }
        this.handleUpdatedPixels(x, y, w, h);
    }

    void handleUpdatedPixels(int x, int y, int w, int h) throws IOException {
        this.amis.newPixels(x, y, w, h);
        try {
            this.sg.setClip(x, y, w, h);
            this.pig.setClip(x, y, w, h);
            this.needToResetClip = true;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            this.sg2 = this.sg.create();
            this.sg.clipRect(x, y, w, h);
            this.pig2 = this.pig.create();
            this.pig.clipRect(x, y, w, h);
        }
        this.sg.drawImage(this.rawPixelsImage, 0, 0, this);
        this.pig.drawImage(this.rawPixelsImage, 0, 0, this);
        if (this.sg2 != null) {
            this.sg.dispose();
            this.sg = this.sg2;
            this.sg2 = null;
            this.pig.dispose();
            this.pig = this.pig2;
            this.pig2 = null;
        }
    }

    public boolean handleEvent(Event evt) {
        block7: {
            if (this.rfb == null || !this.rfb.inNormalProtocol) break block7;
            try {
                switch (evt.id) {
                    case 501: 
                    case 502: 
                    case 503: 
                    case 506: {
                        if (this.v.gotFocus) {
                            this.requestFocus();
                        }
                        this.rfb.writePointerEvent(evt);
                        break;
                    }
                    case 401: 
                    case 402: 
                    case 403: 
                    case 404: {
                        this.rfb.writeKeyEvent(evt);
                        break;
                    }
                    default: {
                        return true;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }
}

