/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Button;
import java.awt.Component;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.io.IOException;

public class vncviewer
extends Applet
implements Runnable {
    boolean inAnApplet = true;
    Frame f;
    String[] mainArgs;
    String host;
    int port;
    rfbProto rfb;
    Thread rfbThread;
    GridBagLayout gridbag;
    Panel buttonPanel;
    Button disconnectButton;
    Button optionsButton;
    Button clipboardButton;
    Button ctrlAltDelButton;
    optionsFrame options;
    clipboardFrame clipboard;
    authenticationPanel authenticator;
    boolean gotFocus = false;

    public static void main(String[] argv) {
        vncviewer v = new vncviewer();
        v.mainArgs = argv;
        v.inAnApplet = false;
        v.f = new Frame("VNC");
        v.f.add("Center", v);
        v.init();
        v.start();
    }

    public void init() {
        this.readParameters();
        this.options = new optionsFrame(this);
        this.clipboard = new clipboardFrame(this);
        this.authenticator = new authenticationPanel();
        this.rfbThread = new Thread(this);
        this.rfbThread.start();
    }

    public void update(Graphics g) {
    }

    public void run() {
        this.gridbag = new GridBagLayout();
        this.setLayout(this.gridbag);
        this.buttonPanel = new Panel();
        this.buttonPanel.setLayout(new FlowLayout(0, 0, 0));
        this.disconnectButton = new Button("Disconnect");
        this.disconnectButton.disable();
        this.buttonPanel.add(this.disconnectButton);
        this.optionsButton = new Button("Options");
        this.buttonPanel.add(this.optionsButton);
        this.clipboardButton = new Button("Clipboard");
        this.clipboardButton.disable();
        this.buttonPanel.add(this.clipboardButton);
        this.ctrlAltDelButton = new Button("Send Ctrl-Alt-Del");
        this.ctrlAltDelButton.disable();
        this.buttonPanel.add(this.ctrlAltDelButton);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        this.gridbag.setConstraints(this.buttonPanel, gbc);
        this.add(this.buttonPanel);
        try {
            this.connectAndAuthenticate();
            this.doProtocolInitialisation();
            vncCanvas vc = new vncCanvas(this);
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            this.gridbag.setConstraints(vc, gbc);
            this.add(vc);
            if (!this.inAnApplet) {
                this.f.setTitle(this.rfb.desktopName);
                this.f.pack();
            } else {
                this.validate();
            }
            this.disconnectButton.enable();
            this.clipboardButton.enable();
            this.ctrlAltDelButton.enable();
            vc.processNormalProtocol();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.fatalError(e.toString());
        }
    }

    void connectAndAuthenticate() throws IOException {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.ipadx = 100;
        gbc.ipady = 50;
        this.gridbag.setConstraints(this.authenticator, gbc);
        this.add(this.authenticator);
        this.validate();
        if (!this.inAnApplet) {
            this.f.pack();
            this.f.show();
        }
        boolean authenticationDone = false;
        while (!authenticationDone) {
            authenticationPanel authenticationPanel2 = this.authenticator;
            synchronized (authenticationPanel2) {
                try {
                    this.authenticator.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.rfb = new rfbProto(this.host, this.port, this);
            this.rfb.readVersionMsg();
            System.out.println("RFB server supports protocol version " + this.rfb.serverMajor + "." + this.rfb.serverMinor);
            this.rfb.writeVersionMsg();
            block3 : switch (this.rfb.readAuthScheme()) {
                case 1: {
                    System.out.println("No authentication needed");
                    authenticationDone = true;
                    break;
                }
                case 2: {
                    byte[] challenge = new byte[16];
                    this.rfb.is.readFully(challenge);
                    String pw = this.authenticator.password.getText();
                    if (pw.length() > 8) {
                        pw = pw.substring(0, 8);
                    }
                    if (pw.length() == 0) {
                        this.authenticator.retry();
                        break;
                    }
                    byte[] key = new byte[8];
                    pw.getBytes(0, pw.length(), key, 0);
                    int i = pw.length();
                    while (i < 8) {
                        key[i] = 0;
                        ++i;
                    }
                    DesCipher des = new DesCipher(key);
                    des.encrypt(challenge, 0, challenge, 0);
                    des.encrypt(challenge, 8, challenge, 8);
                    this.rfb.os.write(challenge);
                    int authResult = this.rfb.is.readInt();
                    switch (authResult) {
                        case 0: {
                            System.out.println("VNC authentication succeeded");
                            authenticationDone = true;
                            break block3;
                        }
                        case 1: {
                            System.out.println("VNC authentication failed");
                            this.authenticator.retry();
                            break block3;
                        }
                        case 2: {
                            throw new IOException("VNC authentication failed - too many tries");
                        }
                    }
                    throw new IOException("Unknown VNC authentication result " + authResult);
                }
            }
        }
        this.remove(this.authenticator);
    }

    void doProtocolInitialisation() throws IOException {
        System.out.println("sending client init");
        this.rfb.writeClientInit();
        this.rfb.readServerInit();
        System.out.println("Desktop name is " + this.rfb.desktopName);
        System.out.println("Desktop size is " + this.rfb.framebufferWidth + " x " + this.rfb.framebufferHeight);
        this.setEncodings();
    }

    void setEncodings() {
        try {
            if (this.rfb != null && this.rfb.inNormalProtocol) {
                this.rfb.writeSetEncodings(this.options.encodings, this.options.nEncodings);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void setCutText(String text) {
        try {
            if (this.rfb != null && this.rfb.inNormalProtocol) {
                this.rfb.writeClientCutText(text);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized boolean action(Event evt, Object what) {
        block9: {
            block11: {
                block10: {
                    block8: {
                        if (evt.target != this.optionsButton) break block8;
                        if (this.options.isVisible()) {
                            ((Component)this.options).hide();
                        } else {
                            this.options.show();
                        }
                        break block9;
                    }
                    if (evt.target != this.disconnectButton) break block10;
                    System.out.println("disconnect");
                    this.options.dispose();
                    this.clipboard.dispose();
                    if (this.inAnApplet) {
                        this.removeAll();
                        this.rfb.close();
                        this.rfb = null;
                        Label l = new Label("Disconnected");
                        this.setLayout(new FlowLayout(0, 30, 30));
                        this.add(l);
                        this.validate();
                        this.rfbThread.stop();
                    } else {
                        System.exit(1);
                    }
                    break block9;
                }
                if (evt.target != this.clipboardButton) break block11;
                if (this.clipboard.isVisible()) {
                    ((Component)this.clipboard).hide();
                } else {
                    this.clipboard.show();
                }
                break block9;
            }
            if (evt.target != this.ctrlAltDelButton) break block9;
            try {
                Event ctrlAltDelEvent = new Event(null, 0, null);
                ctrlAltDelEvent.key = 127;
                ctrlAltDelEvent.modifiers = 10;
                ctrlAltDelEvent.id = 401;
                this.rfb.writeKeyEvent(ctrlAltDelEvent);
                ctrlAltDelEvent.id = 402;
                this.rfb.writeKeyEvent(ctrlAltDelEvent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean gotFocus(Event evt, Object what) {
        this.gotFocus = true;
        return true;
    }

    public boolean lostFocus(Event evt, Object what) {
        this.gotFocus = false;
        return true;
    }

    void encryptBytes(byte[] bytes, String passwd) {
        byte[] key = new byte[8];
        passwd.getBytes(0, passwd.length(), key, 0);
        int i = passwd.length();
        while (i < 8) {
            key[i] = 0;
            ++i;
        }
        DesCipher des = new DesCipher(key);
        des.encrypt(bytes, 0, bytes, 0);
        des.encrypt(bytes, 8, bytes, 8);
    }

    public void readParameters() {
        this.host = this.readParameter("HOST", !this.inAnApplet);
        if (this.host == null) {
            this.host = this.getCodeBase().getHost();
            if (this.host.equals("")) {
                this.fatalError("HOST parameter not specified");
            }
        }
        String s = this.readParameter("PORT", true);
        this.port = Integer.parseInt(s);
    }

    public String readParameter(String name, boolean required) {
        if (this.inAnApplet) {
            String s = this.getParameter(name);
            if (s == null && required) {
                this.fatalError(String.valueOf(name) + " parameter not specified");
            }
            return s;
        }
        int i = 0;
        while (i < this.mainArgs.length) {
            if (this.mainArgs[i].equalsIgnoreCase(name)) {
                try {
                    return this.mainArgs[i + 1];
                }
                catch (Exception exception) {
                    if (required) {
                        this.fatalError(String.valueOf(name) + " parameter not specified");
                    }
                    return null;
                }
            }
            i += 2;
        }
        if (required) {
            this.fatalError(String.valueOf(name) + " parameter not specified");
        }
        return null;
    }

    public void fatalError(String s) {
        System.out.println(s);
        if (this.inAnApplet) {
            this.removeAll();
            Label l = new Label(s);
            this.setLayout(new FlowLayout(0, 30, 30));
            this.add(l);
            this.validate();
            Thread.currentThread().stop();
        } else {
            System.exit(1);
        }
    }
}

