/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;

class animatedMemoryImageSource
implements ImageProducer {
    int width;
    int height;
    ColorModel cm;
    byte[] pixels;
    ImageConsumer ic;

    animatedMemoryImageSource(int w, int h, ColorModel c, byte[] p) {
        this.width = w;
        this.height = h;
        this.cm = c;
        this.pixels = p;
    }

    public void addConsumer(ImageConsumer c) {
        if (this.ic == c) {
            return;
        }
        if (this.ic != null) {
            this.ic.imageComplete(1);
        }
        this.ic = c;
        this.ic.setDimensions(this.width, this.height);
        this.ic.setColorModel(this.cm);
        this.ic.setHints(1);
        this.ic.setPixels(0, 0, this.width, this.height, this.cm, this.pixels, 0, this.width);
        this.ic.imageComplete(2);
    }

    public boolean isConsumer(ImageConsumer c) {
        return this.ic == c;
    }

    public void removeConsumer(ImageConsumer c) {
        if (this.ic == c) {
            this.ic = null;
        }
    }

    public void requestTopDownLeftRightResend(ImageConsumer c) {
    }

    public void startProduction(ImageConsumer c) {
        this.addConsumer(c);
    }

    void newPixels(int x, int y, int w, int h) {
        if (this.ic != null) {
            this.ic.setPixels(x, y, w, h, this.cm, this.pixels, this.width * y + x, this.width);
            this.ic.imageComplete(2);
        }
    }
}

