/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Event;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;

class rfbProto {
    final String versionMsg = "RFB 003.003\n";
    final int ConnFailed = 0;
    final int NoAuth = 1;
    final int VncAuth = 2;
    final int VncAuthOK = 0;
    final int VncAuthFailed = 1;
    final int VncAuthTooMany = 2;
    final int FramebufferUpdate = 0;
    final int SetColourMapEntries = 1;
    final int Bell = 2;
    final int ServerCutText = 3;
    final int SetPixelFormat = 0;
    final int FixColourMapEntries = 1;
    final int SetEncodings = 2;
    final int FramebufferUpdateRequest = 3;
    final int KeyEvent = 4;
    final int PointerEvent = 5;
    final int ClientCutText = 6;
    static final int EncodingRaw = 0;
    static final int EncodingCopyRect = 1;
    static final int EncodingRRE = 2;
    static final int EncodingCoRRE = 4;
    static final int EncodingHextile = 5;
    static final int EncodingZlib = 6;
    static final int EncodingTight = 7;
    static final int EncodingZlibHex = 8;
    final int HextileRaw = 1;
    final int HextileBackgroundSpecified = 2;
    final int HextileForegroundSpecified = 4;
    final int HextileAnySubrects = 8;
    final int HextileSubrectsColoured = 16;
    final int HextileZlibRaw = 32;
    final int HextileZlibHex = 64;
    String host;
    int port;
    Socket sock;
    DataInputStream is;
    OutputStream os;
    boolean inNormalProtocol = false;
    vncviewer v;
    int serverMajor;
    int serverMinor;
    String desktopName;
    int framebufferWidth;
    int framebufferHeight;
    int bitsPerPixel;
    int depth;
    boolean bigEndian;
    boolean trueColour;
    int redMax;
    int greenMax;
    int blueMax;
    int redShift;
    int greenShift;
    int blueShift;
    int updateNRects;
    int updateRectX;
    int updateRectY;
    int updateRectW;
    int updateRectH;
    int updateRectEncoding;
    int copyRectSrcX;
    int copyRectSrcY;
    byte[] eventBuf = new byte[72];
    int eventBufLen;
    int pointerMask;
    int oldModifiers;

    rfbProto(String h, int p, vncviewer v1) throws IOException {
        this.v = v1;
        this.host = h;
        this.port = p;
        this.sock = new Socket(this.host, this.port);
        this.is = new DataInputStream(new BufferedInputStream(this.sock.getInputStream(), 16384));
        this.os = this.sock.getOutputStream();
    }

    void close() {
        try {
            this.sock.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void readVersionMsg() throws IOException {
        byte[] b = new byte[12];
        this.is.readFully(b);
        if (b[0] != 82 || b[1] != 70 || b[2] != 66 || b[3] != 32 || b[4] < 48 || b[4] > 57 || b[5] < 48 || b[5] > 57 || b[6] < 48 || b[6] > 57 || b[7] != 46 || b[8] < 48 || b[8] > 57 || b[9] < 48 || b[9] > 57 || b[10] < 48 || b[10] > 57 || b[11] != 10) {
            throw new IOException("Host " + this.host + " port " + this.port + " is not an RFB server");
        }
        this.serverMajor = (b[4] - 48) * 100 + (b[5] - 48) * 10 + (b[6] - 48);
        this.serverMinor = (b[8] - 48) * 100 + (b[9] - 48) * 10 + (b[10] - 48);
    }

    void writeVersionMsg() throws IOException {
        byte[] b = new byte[12];
        "RFB 003.003\n".getBytes(0, 12, b, 0);
        this.os.write(b);
    }

    int readAuthScheme() throws IOException {
        int authScheme = this.is.readInt();
        switch (authScheme) {
            case 0: {
                int reasonLen = this.is.readInt();
                byte[] reason = new byte[reasonLen];
                this.is.readFully(reason);
                throw new IOException(new String(reason, 0));
            }
            case 1: 
            case 2: {
                return authScheme;
            }
        }
        throw new IOException("Unknown authentication scheme from RFB server " + authScheme);
    }

    void writeClientInit() throws IOException {
        if (this.v.options.shareDesktop) {
            this.os.write(1);
        } else {
            this.os.write(0);
        }
        this.v.options.disableShareDesktop();
    }

    void readServerInit() throws IOException {
        this.framebufferWidth = this.is.readUnsignedShort();
        this.framebufferHeight = this.is.readUnsignedShort();
        this.bitsPerPixel = this.is.readUnsignedByte();
        this.depth = this.is.readUnsignedByte();
        this.bigEndian = this.is.readUnsignedByte() != 0;
        this.trueColour = this.is.readUnsignedByte() != 0;
        this.redMax = this.is.readUnsignedShort();
        this.greenMax = this.is.readUnsignedShort();
        this.blueMax = this.is.readUnsignedShort();
        this.redShift = this.is.readUnsignedByte();
        this.greenShift = this.is.readUnsignedByte();
        this.blueShift = this.is.readUnsignedByte();
        byte[] pad = new byte[3];
        this.is.read(pad);
        int nameLength = this.is.readInt();
        byte[] name = new byte[nameLength];
        this.is.readFully(name);
        this.desktopName = new String(name, 0);
        this.inNormalProtocol = true;
    }

    int readServerMessageType() throws IOException {
        return this.is.read();
    }

    void readFramebufferUpdate() throws IOException {
        this.is.readByte();
        this.updateNRects = this.is.readUnsignedShort();
    }

    void readFramebufferUpdateRectHdr() throws IOException {
        this.updateRectX = this.is.readUnsignedShort();
        this.updateRectY = this.is.readUnsignedShort();
        this.updateRectW = this.is.readUnsignedShort();
        this.updateRectH = this.is.readUnsignedShort();
        this.updateRectEncoding = this.is.readInt();
        if (this.updateRectX + this.updateRectW > this.framebufferWidth || this.updateRectY + this.updateRectH > this.framebufferHeight) {
            throw new IOException("Framebuffer update rectangle too large: " + this.updateRectW + "x" + this.updateRectH + " at (" + this.updateRectX + "," + this.updateRectY + ")");
        }
    }

    void readCopyRect() throws IOException {
        this.copyRectSrcX = this.is.readUnsignedShort();
        this.copyRectSrcY = this.is.readUnsignedShort();
    }

    String readServerCutText() throws IOException {
        byte[] pad = new byte[3];
        this.is.read(pad);
        int len = this.is.readInt();
        byte[] text = new byte[len];
        this.is.readFully(text);
        return new String(text, 0);
    }

    void writeFramebufferUpdateRequest(int x, int y, int w, int h, boolean incremental) throws IOException {
        byte[] b = new byte[]{3, (byte)(incremental ? 1 : 0), (byte)(x >> 8 & 0xFF), (byte)(x & 0xFF), (byte)(y >> 8 & 0xFF), (byte)(y & 0xFF), (byte)(w >> 8 & 0xFF), (byte)(w & 0xFF), (byte)(h >> 8 & 0xFF), (byte)(h & 0xFF)};
        this.os.write(b);
    }

    void writeSetPixelFormat(int bitsPerPixel, int depth, boolean bigEndian, boolean trueColour, int redMax, int greenMax, int blueMax, int redShift, int greenShift, int blueShift) throws IOException {
        byte[] b = new byte[20];
        b[0] = 0;
        b[4] = (byte)bitsPerPixel;
        b[5] = (byte)depth;
        b[6] = (byte)(bigEndian ? 1 : 0);
        b[7] = (byte)(trueColour ? 1 : 0);
        b[8] = (byte)(redMax >> 8 & 0xFF);
        b[9] = (byte)(redMax & 0xFF);
        b[10] = (byte)(greenMax >> 8 & 0xFF);
        b[11] = (byte)(greenMax & 0xFF);
        b[12] = (byte)(blueMax >> 8 & 0xFF);
        b[13] = (byte)(blueMax & 0xFF);
        b[14] = (byte)redShift;
        b[15] = (byte)greenShift;
        b[16] = (byte)blueShift;
        this.os.write(b);
    }

    void writeFixColourMapEntries(int firstColour, int nColours, int[] red, int[] green, int[] blue) throws IOException {
        byte[] b = new byte[6 + nColours * 6];
        b[0] = 1;
        b[2] = (byte)(firstColour >> 8 & 0xFF);
        b[3] = (byte)(firstColour & 0xFF);
        b[4] = (byte)(nColours >> 8 & 0xFF);
        b[5] = (byte)(nColours & 0xFF);
        int i = 0;
        while (i < nColours) {
            b[6 + i * 6] = (byte)(red[i] >> 8 & 0xFF);
            b[6 + i * 6 + 1] = (byte)(red[i] & 0xFF);
            b[6 + i * 6 + 2] = (byte)(green[i] >> 8 & 0xFF);
            b[6 + i * 6 + 3] = (byte)(green[i] & 0xFF);
            b[6 + i * 6 + 4] = (byte)(blue[i] >> 8 & 0xFF);
            b[6 + i * 6 + 5] = (byte)(blue[i] & 0xFF);
            ++i;
        }
        this.os.write(b);
    }

    void writeSetEncodings(int[] encs, int len) throws IOException {
        byte[] b = new byte[4 + 4 * len];
        b[0] = 2;
        b[2] = (byte)(len >> 8 & 0xFF);
        b[3] = (byte)(len & 0xFF);
        int i = 0;
        while (i < len) {
            b[4 + 4 * i] = (byte)(encs[i] >> 24 & 0xFF);
            b[5 + 4 * i] = (byte)(encs[i] >> 16 & 0xFF);
            b[6 + 4 * i] = (byte)(encs[i] >> 8 & 0xFF);
            b[7 + 4 * i] = (byte)(encs[i] & 0xFF);
            ++i;
        }
        this.os.write(b);
    }

    void writeClientCutText(String text) throws IOException {
        byte[] b = new byte[8 + text.length()];
        b[0] = 6;
        b[4] = (byte)(text.length() >> 24 & 0xFF);
        b[5] = (byte)(text.length() >> 16 & 0xFF);
        b[6] = (byte)(text.length() >> 8 & 0xFF);
        b[7] = (byte)(text.length() & 0xFF);
        text.getBytes(0, text.length(), b, 8);
        this.os.write(b);
    }

    void writePointerEvent(Event evt) throws IOException {
        byte[] b = new byte[6];
        if (evt.id == 501) {
            this.pointerMask = 1;
            if ((evt.modifiers & 8) != 0) {
                this.pointerMask = this.v.options.reverseMouseButtons2And3 ? 4 : 2;
            }
            if ((evt.modifiers & 4) != 0) {
                this.pointerMask = this.v.options.reverseMouseButtons2And3 ? 2 : 4;
            }
        } else if (evt.id == 502) {
            this.pointerMask = 0;
        }
        evt.modifiers &= 0xFFFFFFF3;
        this.eventBufLen = 0;
        this.writeModifierKeyEvents(evt.modifiers);
        if (evt.x < 0) {
            evt.x = 0;
        }
        if (evt.y < 0) {
            evt.y = 0;
        }
        this.eventBuf[this.eventBufLen++] = 5;
        this.eventBuf[this.eventBufLen++] = (byte)this.pointerMask;
        this.eventBuf[this.eventBufLen++] = (byte)(evt.x >> 8 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(evt.x & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(evt.y >> 8 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(evt.y & 0xFF);
        if (this.pointerMask == 0) {
            this.writeModifierKeyEvents(0);
        }
        this.os.write(this.eventBuf, 0, this.eventBufLen);
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    void writeKeyEvent(Event evt) throws IOException {
        block32: {
            block33: {
                block31: {
                    key = evt.key;
                    down = false;
                    if (evt.id == 401 || evt.id == 403) {
                        down = true;
                    }
                    if (evt.id != 403 && evt.id != 404) break block31;
                    switch (key) {
                        case 1000: {
                            key = 65360;
                            break block32;
                        }
                        case 1006: {
                            key = 65361;
                            break block32;
                        }
                        case 1004: {
                            key = 65362;
                            break block32;
                        }
                        case 1007: {
                            key = 65363;
                            break block32;
                        }
                        case 1005: {
                            key = 65364;
                            break block32;
                        }
                        case 1002: {
                            key = 65365;
                            break block32;
                        }
                        case 1003: {
                            key = 65366;
                            break block32;
                        }
                        case 1001: {
                            key = 65367;
                            break block32;
                        }
                        case 1008: {
                            key = 65470;
                            break block32;
                        }
                        case 1009: {
                            key = 65471;
                            break block32;
                        }
                        case 1010: {
                            key = 65472;
                            break block32;
                        }
                        case 1011: {
                            key = 65473;
                            break block32;
                        }
                        case 1012: {
                            key = 65474;
                            break block32;
                        }
                        case 1013: {
                            key = 65475;
                            break block32;
                        }
                        case 1014: {
                            key = 65476;
                            break block32;
                        }
                        case 1015: {
                            key = 65477;
                            break block32;
                        }
                        case 1016: {
                            key = 65478;
                            break block32;
                        }
                        case 1017: {
                            key = 65479;
                            break block32;
                        }
                        case 1018: {
                            key = 65480;
                            break block32;
                        }
                        case 1019: {
                            key = 65481;
                            break block32;
                        }
                        default: {
                            return;
                        }
                    }
                }
                if (key >= 32) ** GOTO lbl88
                if ((evt.modifiers & 2) == 0) break block33;
                key += 96;
                break block32;
            }
            switch (key) {
                case 8: {
                    key = 65288;
                    break;
                }
                case 9: {
                    key = 65289;
                    break;
                }
                case 10: {
                    key = 65293;
                    break;
                }
                case 27: {
                    key = 65307;
                    break;
                }
lbl88:
                // 1 sources

                if (key < 127) break;
                if (key == 127) {
                    key = 65535;
                    break;
                }
                if (key >= 65280 && key <= 65535) break;
                return;
            }
        }
        this.eventBufLen = 0;
        this.writeModifierKeyEvents(evt.modifiers);
        this.writeKeyEvent(key, down);
        if (!down) {
            this.writeModifierKeyEvents(0);
        }
        this.os.write(this.eventBuf, 0, this.eventBufLen);
    }

    void writeKeyEvent(int keysym, boolean down) throws IOException {
        this.eventBuf[this.eventBufLen++] = 4;
        this.eventBuf[this.eventBufLen++] = (byte)(down ? 1 : 0);
        this.eventBuf[this.eventBufLen++] = 0;
        this.eventBuf[this.eventBufLen++] = 0;
        this.eventBuf[this.eventBufLen++] = (byte)(keysym >> 24 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(keysym >> 16 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(keysym >> 8 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(keysym & 0xFF);
    }

    void writeModifierKeyEvents(int newModifiers) throws IOException {
        if ((newModifiers & 2) != (this.oldModifiers & 2)) {
            this.writeKeyEvent(65507, (newModifiers & 2) != 0);
        }
        if ((newModifiers & 1) != (this.oldModifiers & 1)) {
            this.writeKeyEvent(65505, (newModifiers & 1) != 0);
        }
        if ((newModifiers & 4) != (this.oldModifiers & 4)) {
            this.writeKeyEvent(65511, (newModifiers & 4) != 0);
        }
        if ((newModifiers & 8) != (this.oldModifiers & 8)) {
            this.writeKeyEvent(65513, (newModifiers & 8) != 0);
        }
        this.oldModifiers = newModifiers;
    }
}

