/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.bytearray;

import com.adobe.acrobat.bytearray.ByteArray;
import com.adobe.acrobat.bytearray.ByteCache;
import com.adobe.acrobat.bytearray.ByteRange;
import com.adobe.acrobat.bytearray.CachingByteArrayInputStream;
import com.adobe.acrobat.bytearray.ContiguousByteRange;
import com.adobe.acrobat.file.ByteArraySource;
import com.adobe.util.Assert;
import com.adobe.util.ImageUtil;
import com.adobe.util.MemUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class CachingByteArray
extends ByteArray {
    private Hashtable hintTable = new Hashtable();
    private Vector registeredStreams = new Vector();
    private int lengthUpperBound = -1;
    private ByteCache byteCache;

    public CachingByteArray(ByteArraySource byteArraySource, byte[] byArray) {
        super(byteArraySource);
        this.byteCache = new ByteCache(byArray);
        if (byArray != null) {
            this.lengthUpperBound = byArray.length;
        }
    }

    protected abstract boolean canDoByteRanges();

    public void cancelHint(Object object) {
        this.hintTable.remove(object);
    }

    protected int computeLength() throws IOException {
        if (this.lengthUpperBound < 0) {
            InputStream inputStream = this.createStream(new ContiguousByteRange(0, 0x7FFFFFFE));
            int n = 0;
            try {
                int n2;
                byte[] byArray = MemUtil.allocByte(1000);
                do {
                    if ((n2 = inputStream.read(byArray, 0, 1000)) != -1) {
                        n += n2;
                    }
                    if (this.lengthUpperBound >= 0) break;
                } while (n2 != -1);
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.setLengthUpperBound(n);
                inputStream.close();
                throw throwable;
            }
            Object var4_5 = null;
            this.setLengthUpperBound(n);
            inputStream.close();
        }
        return this.lengthUpperBound;
    }

    protected final InputStream createStream(ContiguousByteRange contiguousByteRange) throws IOException {
        CachingByteArrayInputStream cachingByteArrayInputStream = new CachingByteArrayInputStream(this, contiguousByteRange);
        this.registerStream(cachingByteArrayInputStream);
        return cachingByteArrayInputStream;
    }

    public ByteCache getByteCache() {
        return this.byteCache;
    }

    private ByteRange getHintRange() {
        ByteRange byteRange = ByteRange.getEmptyByteRange();
        Hashtable hashtable = this.hintTable;
        synchronized (hashtable) {
            Enumeration enumeration = this.hintTable.elements();
            while (enumeration.hasMoreElements()) {
                ContiguousByteRange contiguousByteRange = (ContiguousByteRange)enumeration.nextElement();
                byteRange = byteRange.union(contiguousByteRange);
            }
        }
        return byteRange;
    }

    public int getLengthUpperBound() {
        return this.lengthUpperBound;
    }

    ByteRange getUnconsumedByteRange() {
        Vector vector = this.registeredStreams;
        synchronized (vector) {
            ByteRange byteRange = ByteRange.getEmptyByteRange();
            int n = 0;
            while (n < this.registeredStreams.size()) {
                CachingByteArrayInputStream cachingByteArrayInputStream = (CachingByteArrayInputStream)this.registeredStreams.elementAt(n);
                byteRange = byteRange.union(cachingByteArrayInputStream.getUnconsumedByteRange());
                ++n;
            }
            ByteRange byteRange2 = byteRange;
            Object var3_6 = null;
            return byteRange2;
        }
    }

    public Object hintBytes(ContiguousByteRange contiguousByteRange) {
        Object object = new Object();
        this.hintTable.put(object, contiguousByteRange);
        this.byteCache.lockRange(contiguousByteRange);
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int read(ContiguousByteRange contiguousByteRange, byte[] byArray, int n) throws IOException {
        if (contiguousByteRange == null) {
            return -1;
        }
        Component component = ImageUtil.getRegisteredComponent();
        try {
            try {}
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException();
            }
        }
        catch (Throwable throwable) {
            Object var7_13 = null;
            if (component == null) throw throwable;
            component.setCursor(Cursor.getDefaultCursor());
            throw throwable;
        }
        while (true) {
            this.throwIfInvalid();
            if (this.byteCache.getCachedByteRange().contains(contiguousByteRange.getStart())) break;
            int n2 = this.getLengthUpperBound();
            if (n2 >= 0 && n2 <= contiguousByteRange.getStart()) {
                int n3 = -1;
                Object var7_11 = null;
                if (component == null) return n3;
                component.setCursor(Cursor.getDefaultCursor());
                return n3;
            }
            IOException iOException = this.byteCache.getError();
            if (iOException != null) {
                this.byteCache.setError(null);
                throw iOException;
            }
            ByteCache byteCache = this.byteCache;
            synchronized (byteCache) {
                if (component != null) {
                    component.setCursor(Cursor.getPredefinedCursor(3));
                }
                this.byteCache.wait(500L);
            }
        }
        ContiguousByteRange contiguousByteRange2 = this.byteCache.getCachedByteRange().getFirstIntersection(contiguousByteRange);
        Assert.notFalse(contiguousByteRange2.getLength() > 0);
        int n4 = this.byteCache.read(contiguousByteRange2, byArray, n);
        Object var7_12 = null;
        if (component == null) return n4;
        component.setCursor(Cursor.getDefaultCursor());
        return n4;
    }

    private void registerStream(CachingByteArrayInputStream cachingByteArrayInputStream) throws IOException {
        this.registeredStreams.addElement(cachingByteArrayInputStream);
        if (!this.isValid()) {
            return;
        }
        ContiguousByteRange contiguousByteRange = cachingByteArrayInputStream.getUnconsumedByteRange();
        if (contiguousByteRange != null) {
            this.byteCache.lockRange(contiguousByteRange);
            ByteRange byteRange = this.getHintRange().union(this.getUnconsumedByteRange());
            this.requestBytes(this.byteCache, byteRange);
        }
    }

    protected abstract void requestBytes(ByteCache var1, ByteRange var2) throws IOException;

    public void setLengthUpperBound(int n) {
        if (this.lengthUpperBound < n) {
            this.lengthUpperBound = n;
        }
    }

    void unregisterStream(CachingByteArrayInputStream cachingByteArrayInputStream) throws IOException {
        Assert.notFalse(this.registeredStreams.contains(cachingByteArrayInputStream));
        this.registeredStreams.removeElement(cachingByteArrayInputStream);
        if (this.canDoByteRanges()) {
            ByteRange byteRange = this.getHintRange().union(this.getUnconsumedByteRange());
            this.requestBytes(this.byteCache, byteRange);
            this.byteCache.unlockRange(byteRange);
        }
    }
}

