/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.debug;

import com.adobe.acrobat.page.Content;
import com.adobe.acrobat.page.ContentArray;
import com.adobe.acrobat.page.DrawContext;
import com.adobe.acrobat.page.GState;
import com.adobe.acrobat.page.VContentArray;
import com.adobe.acrobat.pdf.ColorValue;
import com.adobe.acrobat.sidecar.AWTGraphics;
import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.BezierPath;
import com.adobe.acrobat.sidecar.FloatRect;
import com.adobe.acrobat.sidecar.Stroke;
import com.adobe.acrobat.vtypes.VAffineTransform;
import com.adobe.acrobat.vtypes.VFloatRect;
import com.adobe.pe.awt.VDimension;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.painting.Painting;
import com.adobe.pe.painting.VPainting;
import com.adobe.pe.vtypes.VBoolean;
import com.adobe.pe.vtypes.VInt;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;

class VContentPainting
extends VPainting {
    private static final int kInset = 10;
    private VDimension vApertureSize;
    private VFloatRect vContainerBounds;
    private VAffineTransform vContainerTransform;
    private VContentArray vContent;
    private VInt vIndex;
    private VBoolean vAllContent;
    private VBoolean vZoomToContent;
    private VBoolean vShowBB;
    private VBoolean vShowClip;

    VContentPainting(VDimension vDimension, VFloatRect vFloatRect, VAffineTransform vAffineTransform, VContentArray vContentArray, VInt vInt, VBoolean vBoolean, VBoolean vBoolean2, VBoolean vBoolean3, VBoolean vBoolean4) throws Exception {
        this.vApertureSize = vDimension;
        this.vContainerBounds = vFloatRect;
        this.vContainerTransform = vAffineTransform;
        this.vContent = vContentArray;
        this.vIndex = vInt;
        this.vAllContent = vBoolean;
        this.vZoomToContent = vBoolean2;
        this.vShowBB = vBoolean3;
        this.vShowClip = vBoolean4;
    }

    protected final Painting computePainting(Requester requester) throws Exception {
        Dimension dimension = this.vApertureSize.dimensionValue(requester);
        int n = this.vIndex.intValue(requester);
        boolean bl = n != -1 && this.vZoomToContent.booleanValue(requester);
        ContentArray contentArray = this.vContent.contentArrayValue(requester);
        FloatRect floatRect = this.vContainerBounds.floatRectValue(requester);
        AffineTransform affineTransform = this.vContainerTransform.affineTransformValue(requester);
        boolean bl2 = this.vShowClip.booleanValue(requester);
        boolean bl3 = this.vAllContent.booleanValue(requester);
        boolean bl4 = this.vShowBB.booleanValue(requester);
        return new ContentPainting(dimension, n, bl, contentArray, floatRect, affineTransform, bl2, bl3, bl4);
    }

    class ContentPainting
    extends Painting {
        private int index;
        private boolean zoomToContent;
        private boolean showClip;
        private boolean allContent;
        private boolean showBB;
        private ContentArray contentArray;
        private FloatRect containerBounds;
        private AffineTransform containerTransform;

        ContentPainting(Dimension dimension, int n, boolean bl, ContentArray contentArray, FloatRect floatRect, AffineTransform affineTransform, boolean bl2, boolean bl3, boolean bl4) {
            super(new Rectangle(0, 0, dimension.width, dimension.height), true, false);
            this.index = n;
            this.zoomToContent = bl;
            this.contentArray = contentArray;
            this.containerBounds = floatRect;
            this.containerTransform = affineTransform;
            this.showClip = bl2;
            this.allContent = bl3;
            this.showBB = bl4;
        }

        public void draw(Graphics graphics) throws Exception {
            AWTGraphics aWTGraphics;
            block10: {
                Rectangle rectangle = this.getBounds();
                graphics.setColor(Color.gray);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                graphics.setColor(Color.black);
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
                graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width, rectangle.y + rectangle.height - 1);
                Rectangle rectangle2 = new Rectangle(rectangle);
                ++rectangle2.x;
                --rectangle2.width;
                --rectangle2.height;
                rectangle2.grow(-10, -10);
                Content content = this.index == -1 ? null : this.contentArray.nthContent(this.index);
                FloatRect floatRect = this.zoomToContent ? content.getBoundingBox() : this.containerBounds;
                FloatRect floatRect2 = floatRect.transformRect(this.containerTransform);
                double d = (double)rectangle2.width / floatRect2.width();
                double d2 = (double)rectangle2.height / floatRect2.height();
                AffineTransform affineTransform = this.containerTransform.preScale(Math.min(d, d2));
                floatRect2 = floatRect.transformRect(affineTransform);
                affineTransform = affineTransform.translate(-floatRect2.getxMin() + 10.0 - (floatRect2.width() - (double)rectangle2.width) / 2.0, -floatRect2.getyMin() + 10.0 - (floatRect2.height() - (double)rectangle2.height) / 2.0);
                aWTGraphics = new AWTGraphics(graphics);
                try {
                    FloatRect floatRect3 = this.containerBounds.transformRect(affineTransform);
                    DrawContext drawContext = new DrawContext(aWTGraphics, affineTransform, floatRect3.toEnclosingRect());
                    drawContext.reset();
                    BezierPath bezierPath = new BezierPath(this.containerBounds);
                    aWTGraphics.setStroke(new Stroke(0, 0, 1.0));
                    aWTGraphics.setFillColor(ColorValue.white);
                    aWTGraphics.fillPath(bezierPath);
                    aWTGraphics.setStrokeColor(ColorValue.black);
                    aWTGraphics.drawPath(bezierPath);
                    if (this.allContent) {
                        if (this.index == -1) {
                            this.contentArray.draw(drawContext);
                        } else {
                            int n = 0;
                            while (n <= this.index) {
                                Content content2 = this.contentArray.nthContent(n);
                                content2.drawContent(drawContext);
                                ++n;
                            }
                        }
                    } else if (this.index != -1) {
                        if (this.showClip) {
                            GState gState = content.getGState();
                            gState.apply(drawContext);
                            BezierPath bezierPath2 = new BezierPath(this.containerBounds);
                            AffineTransform affineTransform2 = gState.getCTM().getInverse();
                            bezierPath2 = bezierPath2.transform(affineTransform2);
                            aWTGraphics.setFillColor(ColorValue.red);
                            aWTGraphics.setPath(bezierPath2);
                            aWTGraphics.fillPath(false);
                        } else {
                            content.drawContent(drawContext);
                        }
                    }
                    aWTGraphics.flush();
                    if (this.index == -1 || !this.showBB) break block10;
                    drawContext.reset();
                    Stroke stroke = new Stroke(0, 0, 0.0);
                    aWTGraphics.setStroke(stroke);
                    aWTGraphics.setStrokeColor(ColorValue.green);
                    bezierPath = new BezierPath(content.getBoundingBox());
                    aWTGraphics.drawPath(bezierPath);
                }
                catch (Throwable throwable) {
                    Object var14_21 = null;
                    aWTGraphics.flush();
                    aWTGraphics.dispose();
                    throw throwable;
                }
            }
            Object var14_20 = null;
            aWTGraphics.flush();
            aWTGraphics.dispose();
        }
    }
}

