/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.bytearray.ByteArray;
import com.adobe.acrobat.bytearray.ByteCache;
import com.adobe.acrobat.bytearray.ByteCacheMonitor;
import com.adobe.acrobat.bytearray.ByteRange;
import com.adobe.acrobat.bytearray.CachingByteArray;
import com.adobe.acrobat.bytearray.ContiguousByteRange;
import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.pdfobjstore.LinearizerInfo;
import com.adobe.acrobat.pdfobjstore.PDFObjStore;
import com.adobe.acrobat.util.Log;
import com.adobe.pe.awt.StrobeContainer;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.VObserver;
import com.adobe.pe.notify.VStrobe;
import com.adobe.pe.notify.WriteLockException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.Toolkit;

public class CacheDisplayButton
extends Component
implements VObserver,
ByteCacheMonitor,
StrobeContainer {
    private static final Dimension MINSIZE = new Dimension(100, 15);
    private Dimension minSize;
    private boolean widthNotSet = true;
    private FontMetrics fm;
    private Font font;
    private int HEIGHT;
    private String LABEL = " bytes";
    private VStrobe strobe;
    private AcroViewContext context;
    private ByteCache byteCache;
    private LinearizerInfo linInfo;
    private int length;

    CacheDisplayButton(AcroViewContext acroViewContext) {
        this.context = acroViewContext;
        this.font = new Font("sanserif", 0, 10);
        this.setFont(this.font);
        this.fm = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
        this.HEIGHT = this.fm.getHeight() + 7;
        this.strobe = new VStrobe(this);
        this.setBackground(SystemColor.menu);
    }

    public void byteCacheChanged() {
        Graphics graphics;
        if (this.linInfo == null || !this.linInfo.isLinearized()) {
            this.length = this.byteCache.getUpperBound();
        }
        if ((graphics = this.getGraphics()) != null) {
            try {
                this.update(graphics);
            }
            finally {
                Object var3_2 = null;
                graphics.dispose();
            }
        }
    }

    public void change(Requester requester) throws WriteLockException {
        try {
            PDFObjStore pDFObjStore;
            if (this.byteCache != null) {
                this.byteCache.unregisterByteCacheMonitor(this);
                this.byteCache = null;
            }
            if ((pDFObjStore = this.context.getPDFObjStore(requester)) == null) {
                return;
            }
            ByteArray byteArray = pDFObjStore.getVByteArray().byteArrayValue(requester);
            if (!(byteArray instanceof CachingByteArray)) {
                return;
            }
            this.linInfo = pDFObjStore.getVLinearizerInfo().linearizerInfoValue(requester);
            if (this.linInfo.isLinearized()) {
                this.length = this.linInfo.getFileLength();
            }
            this.byteCache = ((CachingByteArray)byteArray).getByteCache();
            this.byteCache.registerByteCacheMonitor(this);
            this.byteCacheChanged();
            if (this.byteCache != null) {
                int n = this.byteCache.getLength();
                int n2 = this.fm.stringWidth(String.valueOf(this.byteCache.getLength())) * 3 + this.fm.stringWidth(this.LABEL);
                if (n2 != this.getSize().width) {
                    this.minSize = new Dimension(n2, this.HEIGHT);
                    this.invalidate();
                    this.validate();
                }
            }
            if (this.getParent() != null) {
                this.getParent().validate();
            }
        }
        catch (WriteLockException writeLockException) {
            throw writeLockException;
        }
        catch (Exception exception) {
            Log.clog("CacheDisplayButton.change: " + exception.toString());
        }
    }

    public Dimension getMinimumSize() {
        return this.minSize == null ? MINSIZE : this.minSize;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void paint(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        if (this.byteCache == null) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, n, n2);
            return;
        }
        try {
            int n3;
            int n4;
            Object object;
            graphics.setFont(this.font);
            graphics.setColor(SystemColor.menu);
            graphics.fillRect(0, 0, n, n2);
            graphics.setColor(this.getBackground().darker().darker());
            ByteRange byteRange = this.byteCache.getCachedByteRange();
            float f = (float)n / (float)this.length;
            int n5 = 0;
            int n6 = 0;
            while (n6 < byteRange.numRanges()) {
                object = byteRange.getNthContiguousByteRange(n6);
                n5 += ((ContiguousByteRange)object).getLength();
                n4 = Math.round(f * (float)((ContiguousByteRange)object).getStart());
                n3 = Math.round(f * (float)((ContiguousByteRange)object).getEnd());
                graphics.fillRect(n4, n2 - 4, n3, 2);
                ++n6;
            }
            graphics.drawRect(0, n2 - 6, n - 1, 5);
            object = String.valueOf(String.valueOf(n5)) + " / " + String.valueOf(this.length) + this.LABEL;
            n4 = this.fm.stringWidth((String)object);
            n3 = this.fm.getHeight();
            int n7 = this.fm.getDescent();
            int n8 = (n - n4) / 2;
            int n9 = (n2 + n3) / 2 - n7 - 3;
            graphics.setColor(Color.black);
            graphics.drawString((String)object, 2, n9);
        }
        catch (Exception exception) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, n, n2);
        }
    }

    public void setStrobeActive(Transaction transaction, boolean bl) {
        this.strobe.setActive(transaction, bl);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

