/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.util.Log;
import com.adobe.acrobat.util.Util;
import com.adobe.util.Assert;
import com.adobe.util.EmbossFilter;
import com.adobe.util.ImageUtil;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.SystemColor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.FilteredImageSource;

public abstract class ComboButton
extends Component
implements MouseListener {
    private boolean actionOnMouseUp;
    protected boolean pressed;
    protected boolean released;
    protected boolean inButton;
    protected boolean running;
    protected int bevel;
    private Image defaultIcon;
    private Image grayscaleIcon;
    private Image disabledIcon;
    private String fString;
    int hGap;
    int vGap;

    public ComboButton() {
        this(true);
    }

    public ComboButton(String string, String string2, boolean bl) {
        this(bl);
        if (string2 != null) {
            this.defaultIcon = Util.getResourceImage("icons/default/" + string2);
            this.grayscaleIcon = Util.getResourceImage("icons/grayscale/" + string2);
            this.disabledIcon = ImageUtil.getRegisteredComponent().getToolkit().createImage(new FilteredImageSource(this.grayscaleIcon.getSource(), EmbossFilter.theFilter));
            MediaTracker mediaTracker = new MediaTracker(this);
            try {
                mediaTracker.addImage(this.defaultIcon, 0);
                mediaTracker.addImage(this.grayscaleIcon, 1);
                mediaTracker.addImage(this.disabledIcon, 2);
                mediaTracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                Assert.notNull(null);
            }
        }
        this.fString = string;
    }

    public ComboButton(boolean bl) {
        this.actionOnMouseUp = bl;
        this.pressed = false;
        this.released = true;
        this.running = false;
        this.bevel = 1;
        this.defaultIcon = null;
        this.grayscaleIcon = null;
        this.disabledIcon = null;
        this.setSize(10, 10);
        this.hGap = 4;
        this.vGap = 2;
        this.addMouseListener(this);
    }

    private void checkBevelSize(int n) throws AWTException {
        Dimension dimension = this.getSize();
        if (n < 0 || n >= dimension.width / 2 || n >= dimension.height / 2) {
            throw new AWTException("invalid bevel size");
        }
    }

    public int getBevelHeight() {
        return this.bevel;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(this.hGap, 0);
        if (this.defaultIcon != null) {
            dimension.width = this.defaultIcon.getWidth(this) + this.hGap;
            if (this.fString != null) {
                dimension.width += 2 * this.hGap;
            }
            dimension.height = this.defaultIcon.getHeight(this) + 2 * this.vGap;
        }
        if (this.fString != null) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            dimension.width += fontMetrics.stringWidth(this.fString) + 5 * this.hGap;
            dimension.height = Math.max(fontMetrics.getHeight() + 2 * this.vGap, dimension.height);
        }
        return dimension;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.inButton = true;
        this.repaint();
        mouseEvent.consume();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.inButton = false;
        this.repaint();
        mouseEvent.consume();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.contains(mouseEvent.getPoint())) {
            this.pressed = true;
            this.released = false;
            this.repaint();
            if (!this.actionOnMouseUp && this.isEnabled()) {
                this.performComboButtonAction();
            }
        }
        mouseEvent.consume();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.pressed && this.actionOnMouseUp && this.isEnabled()) {
            this.performComboButtonAction();
        }
        this.pressed = false;
        this.released = true;
        this.repaint();
        mouseEvent.consume();
    }

    public void paint(Graphics graphics) {
        int n = 0;
        Dimension dimension = this.getSize();
        int n2 = dimension.width;
        int n3 = dimension.height;
        int n4 = this.bevel + 1;
        int n5 = this.bevel + 1;
        int n6 = n2 - 1;
        int n7 = n3 - 1;
        graphics.setColor(SystemColor.menu);
        graphics.fillRect(0, 0, n2, n3);
        graphics.setColor(SystemColor.controlLtHighlight);
        if (this.pressed && this.isEnabled()) {
            n = this.bevel;
            n5 = n4 += this.bevel > 0 ? 2 : 1;
            int n8 = 1;
            while (n8 < this.bevel + 1) {
                graphics.drawLine(n8, n7 - n8, n6 - n8, n7 - n8);
                graphics.drawLine(n6 - n8, n7 - n8, n6 - n8, n8);
                ++n8;
            }
            graphics.setColor(SystemColor.control);
            n8 = 1;
            while (n8 < this.bevel + 1) {
                graphics.drawLine(n8, n7, n8, n8);
                graphics.drawLine(n8, n8, n6, n8);
                ++n8;
            }
        } else {
            int n9 = 1;
            while (n9 < this.bevel + 1) {
                graphics.drawLine(n9, n7 - n9, n9, n9);
                graphics.drawLine(n9, n9, n6 - n9, n9);
                ++n9;
            }
            graphics.setColor(SystemColor.control);
            n9 = 1;
            while (n9 < this.bevel + 2) {
                graphics.drawLine(n9, n7 - n9, n6 - n9, n7 - n9);
                graphics.drawLine(n6 - n9, n7 - n9, n6 - n9, n9);
                ++n9;
            }
        }
        graphics.setColor(SystemColor.controlDkShadow);
        graphics.drawLine(1, 0, n2 - 2, 0);
        graphics.drawLine(0, 1, 0, n3 - 2);
        graphics.drawLine(1, n3 - 1, n2 - 2, n3 - 1);
        graphics.drawLine(n2 - 1, n3 - 2, n2 - 1, 1);
        n4 = this.bevel + 1 + n;
        n5 = this.bevel + 1 + n;
        n6 = dimension.width - 1;
        n7 = dimension.height - 1;
        if (this.defaultIcon != null) {
            graphics.setColor(SystemColor.control);
            n4 += this.hGap;
            n5 = (n3 - this.defaultIcon.getHeight(this)) / 2 + n;
            if (this.inButton && this.isEnabled()) {
                graphics.drawImage(this.defaultIcon, n4, n5, this);
            } else if (!this.isEnabled()) {
                graphics.drawImage(this.disabledIcon, n4, n5, this);
            } else {
                graphics.drawImage(this.grayscaleIcon, n4, n5, this);
            }
            n4 += this.defaultIcon.getWidth(this);
        }
        if (this.fString != null) {
            graphics.setColor(SystemColor.textText);
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            n5 = (n3 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent();
            graphics.drawString(this.fString, n4 += 3 * this.hGap, n5);
        }
    }

    public abstract void performComboButtonAction();

    public void setBevelHeight(int n) {
        try {
            this.checkBevelSize(n);
        }
        catch (AWTException aWTException) {
            Log.clog("Invalid Bevel Size " + n);
        }
        this.bevel = n;
        this.invalidate();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.repaint();
    }

    public void setString(String string) {
        this.fString = string;
        if (this.getParent() != null) {
            this.getParent().invalidate();
            this.getParent().validate();
        }
    }

    public void update(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.clipRect(0, 0, dimension.width, dimension.height);
        this.paint(graphics);
    }
}

