/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.ErrorDialog;
import com.adobe.acrobat.gui.FontPolicyDialog;
import com.adobe.acrobat.gui.GroupBox;
import com.adobe.acrobat.gui.ProxyPanel;
import com.adobe.acrobat.gui.ReaderPrefs;
import com.adobe.acrobat.gui.RowLayout;
import com.adobe.acrobat.gui.TabbedPane;
import com.adobe.acrobat.gui.TransactionDialog;
import com.adobe.acrobat.gui.ZoomValueSpec;
import com.adobe.acrobat.util.FontCache;
import com.adobe.acrobat.util.Log;
import com.adobe.acrobat.util.QuickSort;
import com.adobe.acrobat.util.Util;
import com.adobe.pe.awt.LightWeightPanel;
import com.adobe.pe.awt.MessageDialog;
import com.adobe.pe.awt.MultilineLabel;
import com.adobe.pe.util.PEUtil;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class PrefsDialog
extends TransactionDialog
implements ItemListener {
    private TabbedPane tabs;
    private Frame parent;
    private Choice pageLayout;
    private Properties cmd;
    private Choice defaultZoom;
    private Choice maxZoom;
    private Choice font;
    private Choice pageUnits;
    private Checkbox fDisplayLarge;
    private Checkbox fGreekText;
    private TextFieldWithLimit fGreekTextLimit;
    private Checkbox fDisplayOpenDlg;
    private Button refresh;
    private Button setFonts;
    private Button reset;
    private GroupBox localFonts;
    private FontSourcePanel fontSourcePanel;
    private HelpSystemPanel helpSystemPanel;
    private ProxyPanel proxyTab;
    private Container display;
    private Container magnification;
    private Container options;
    private Container main;
    private InsetPanel fonts;
    private GridBagLayout gDisplay;
    private GridBagLayout gMagnification;
    private GridBagLayout gOptions;
    private GridBagLayout gMain;
    private GridBagConstraints cDisplay;
    private GridBagConstraints cMagnification;
    private GridBagConstraints cOptions;
    private GridBagConstraints cMain;

    PrefsDialog(AcroViewContext acroViewContext) {
        super(PEUtil.getFrame(acroViewContext.getRootComponent()), Util.getDialogString("Prefs:GeneralPrefs"));
        this.parent = this.frame;
        this.initCommands();
        this.setLayout(new BorderLayout(5, 5));
        this.createGridPanels();
        this.createDisplayElements();
        this.createMagnificationElements();
        this.createOptionsElements();
        this.createHelpElements();
        this.createAcrobatFontElements();
        this.createLocalFontElements();
        this.addRowFill(this.main, this.gMain, this.cMain, this.display, 1);
        this.addRowFill(this.main, this.gMain, this.cMain, this.magnification, 15);
        this.addRowFill(this.main, this.gMain, this.cMain, this.options, 15);
        this.tabs = new TabbedPane();
        this.tabs.addTab("Document", this.main);
        this.tabs.addTab("Help System", this.helpSystemPanel);
        this.tabs.addTab("Acrobat Fonts", this.fontSourcePanel);
        this.tabs.addTab("Local Fonts", this.fonts);
        if (ReaderPrefs.getEnableProxySettings()) {
            this.proxyTab = new ProxyPanel();
            this.tabs.addTab("Proxy", this.proxyTab);
        }
        this.tabs.selectTab("Document");
        this.add((Component)this.tabs, "Center");
        this.add((Component)this.okCancelPanel, "South");
        this.setResizable(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.setFonts) {
            FontPolicyDialog fontPolicyDialog = new FontPolicyDialog(this.parent);
            fontPolicyDialog.setModal(true);
        } else if (actionEvent.getSource() == this.reset) {
            try {
                ReaderPrefs.restoreDefaults();
                this.populate();
            }
            catch (Exception exception) {
                new ErrorDialog(this.parent, exception);
            }
        } else if (actionEvent.getSource() == this.helpSystemPanel.browse) {
            try {
                FileDialog fileDialog = new FileDialog(this.frame);
                ((Component)fileDialog).setLocation(this.getBounds().x, this.getBounds().y);
                fileDialog.show();
                String string = fileDialog.getDirectory();
                String string2 = fileDialog.getFile();
                if (string != null && string2 != null) {
                    this.helpSystemPanel.browser.setText(String.valueOf(string) + string2);
                }
            }
            catch (Exception exception) {
                new ErrorDialog(this.parent, exception);
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    private String addPercent(String string) {
        if (Character.isDigit(string.charAt(0))) {
            string = String.valueOf(string) + "%";
        }
        return string;
    }

    private void addRow(Container container, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, Component component) {
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    private void addRow(Container container, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, Component component, Component component2) {
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(component2, gridBagConstraints);
        container.add(component2);
    }

    private void addRow(Container container, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, String string, Component component) {
        this.addRow(container, gridBagLayout, gridBagConstraints, string, component, 2);
    }

    private void addRow(Container container, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, String string, Component component, int n) {
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 1.0;
        Label label = new Label(string, n);
        gridBagLayout.setConstraints(label, gridBagConstraints);
        container.add(label);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    private void addRowFill(Container container, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, Component component, int n) {
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(n, 4, 1, 4);
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    public boolean applyPrefs() throws Exception {
        if (!this.validatePrefs()) {
            return false;
        }
        ReaderPrefs.fDefPageLayout.setStringValue(this.transaction, this.getCommand(this.pageLayout.getSelectedItem()));
        ZoomValueSpec zoomValueSpec = ZoomValueSpec.validateSpec(this.removePercent(this.defaultZoom.getSelectedItem()), false);
        ReaderPrefs.fDefaultZoom.setZoomValueSpecValue(this.transaction, zoomValueSpec);
        zoomValueSpec = ZoomValueSpec.validateSpec(this.maxZoom.getSelectedItem(), false);
        ReaderPrefs.fMaxVisibleZoom.setDoubleValue(this.transaction, zoomValueSpec.zoomLevel);
        ReaderPrefs.fSubstitutionFont.setStringValue(this.transaction, this.getCommand(this.font.getSelectedItem()));
        ReaderPrefs.fPageUnitsStr.setStringValue(this.transaction, this.getCommand(this.pageUnits.getSelectedItem()));
        ReaderPrefs.fDisplayLargeImages.setBooleanValue(this.transaction, this.fDisplayLarge.getState());
        ReaderPrefs.fGreekText.setBooleanValue(this.transaction, this.fGreekText.getState());
        ReaderPrefs.fGreekTextLimit.setIntValue(this.transaction, Integer.parseInt(this.fGreekTextLimit.getText().trim()));
        ReaderPrefs.fShowOpenDialogOnStartup.setBooleanValue(this.transaction, this.fDisplayOpenDlg.getState());
        String string = this.helpSystemPanel.sitePrefs.getText().trim();
        if (!ReaderPrefs.fSitePrefsURL.equals(string)) {
            ReaderPrefs.refreshSiteProperties();
            if (ReaderPrefs.getEnableProxySettings() && this.proxyTab != null) {
                this.proxyTab.init();
            }
            this.fontSourcePanel.setSource(ReaderPrefs.getAcrobatFontsSource());
        }
        ReaderPrefs.fSitePrefsURL = this.helpSystemPanel.sitePrefs.getText().trim();
        ReaderPrefs.fHelpFileURL = this.helpSystemPanel.helpURL.getText().trim();
        ReaderPrefs.fLicenseFileURL = this.helpSystemPanel.licenseURL.getText().trim();
        ReaderPrefs.setAcrobatFontsSource(this.fontSourcePanel.getSource());
        if (ReaderPrefs.getEnableProxySettings()) {
            this.proxyTab.save();
        }
        ReaderPrefs.fBrowser = this.helpSystemPanel.browser.getText().trim();
        return true;
    }

    protected void arrangeButtons() {
        this.buttons.setLayout(new GridLayout(1, 3, 5, 5));
        this.reset = new Button(Util.getDialogString("Prefs:Reset"));
        this.reset.addActionListener(this);
        this.buttons.add(this.reset);
        this.buttons.add(this.ok);
        this.buttons.add(this.cancel);
    }

    private void createAcrobatFontElements() {
        this.fontSourcePanel = new FontSourcePanel();
    }

    private void createDisplayElements() {
        this.pageLayout = new Choice();
        this.pageLayout.addItemListener(this);
        this.pageLayout.addItem(Util.getDialogString("PageView:SinglePage"));
        this.pageLayout.addItem(Util.getDialogString("PageView:Continuous"));
        this.pageLayout.addItem(Util.getDialogString("PageView:FacingPages"));
        this.addRow(this.display, this.gDisplay, this.cDisplay, Util.getDialogString("PageView:DefaultLayout"), (Component)this.pageLayout);
        this.pageUnits = new Choice();
        this.pageUnits.addItem(Util.getDialogString("Units:Inches"));
        this.pageUnits.addItem(Util.getDialogString("Units:Millimeters"));
        this.pageUnits.addItem(Util.getDialogString("Units:Points"));
        this.addRow(this.display, this.gDisplay, this.cDisplay, Util.getDialogString("Units:PageUnits"), (Component)this.pageUnits);
        this.font = new Choice();
        this.font.addItem(Util.getDialogString("Text:Sans&Serif"));
        this.font.addItem(Util.getDialogString("Text:Sans"));
        this.font.addItem(Util.getDialogString("Text:Serif"));
        LightWeightPanel lightWeightPanel = new LightWeightPanel();
        lightWeightPanel.setLayout(new FlowLayout(0, 0, 0));
        this.fGreekText = new Checkbox(Util.getDialogString("Text:GreekText"));
        this.fGreekText.addItemListener(this);
        Label label = new Label(Util.getDialogString("Text:Pixels"));
        this.fGreekTextLimit = new TextFieldWithLimit("", 3, 2);
        lightWeightPanel.add(this.fGreekText);
        lightWeightPanel.add(this.fGreekTextLimit);
        lightWeightPanel.add(label);
        this.addRow(this.display, this.gDisplay, this.cDisplay, lightWeightPanel);
        this.fDisplayLarge = new Checkbox(Util.getDialogString("Prefs:DisplayLargeImages"));
    }

    private void createGridPanels() {
        this.display = new GroupBox(Util.getDialogString("Prefs:Display"));
        this.gDisplay = new GridBagLayout();
        this.cDisplay = new GridBagConstraints();
        this.display.setLayout(this.gDisplay);
        this.cDisplay.insets = new Insets(1, 4, 1, 4);
        this.cDisplay.fill = 1;
        this.magnification = new GroupBox(Util.getDialogString("Zoom:Magnification"));
        this.gMagnification = new GridBagLayout();
        this.cMagnification = new GridBagConstraints();
        this.magnification.setLayout(this.gMagnification);
        this.cMagnification.insets = new Insets(1, 4, 1, 4);
        this.cMagnification.fill = 1;
        this.options = new GroupBox(Util.getDialogString("Prefs:Options"));
        this.gOptions = new GridBagLayout();
        this.cOptions = new GridBagConstraints();
        this.options.setLayout(this.gOptions);
        this.cOptions.insets = new Insets(1, 4, 1, 4);
        this.cOptions.fill = 1;
        this.fonts = new InsetPanel(new RowLayout(20));
        this.fonts.setInsets(new Insets(10, 10, 10, 10));
        this.main = new LightWeightPanel();
        this.gMain = new GridBagLayout();
        this.cMain = new GridBagConstraints();
        this.main.setLayout(this.gMain);
        this.cMain.fill = 1;
    }

    private void createHelpElements() {
        this.helpSystemPanel = new HelpSystemPanel();
    }

    private void createLocalFontElements() {
        this.fontSourcePanel = new FontSourcePanel();
        this.localFonts = new GroupBox("Local System Fonts");
        this.localFonts.setInsets(new Insets(20, 10, 10, 10));
        this.localFonts.setLayout(new RowLayout(20));
        MultilineLabel multilineLabel = new MultilineLabel(Util.getDialogString("Prefs:LocalFontsExplained"), -1);
        this.localFonts.add(multilineLabel);
        this.setFonts = new Button(Util.getDialogString("Prefs:FontsButton"));
        this.setFonts.addActionListener(this);
        this.setFonts.addKeyListener(this);
        this.localFonts.add(this.setFonts);
        this.fonts.add(this.localFonts);
    }

    private void createMagnificationElements() {
        this.defaultZoom = new Choice();
        ZoomValueSpec zoomValueSpec = null;
        int n = 0;
        while (n < ZoomValueSpec.zoomValuesTable.length) {
            zoomValueSpec = ZoomValueSpec.zoomValuesTable[n];
            if (zoomValueSpec != null) {
                this.defaultZoom.addItem(this.addPercent(zoomValueSpec.getUIString(false)));
            }
            ++n;
        }
        this.addRow(this.magnification, this.gMagnification, this.cMagnification, Util.getDialogString("Zoom:Default"), (Component)this.defaultZoom);
        this.maxZoom = new Choice();
        int n2 = 0;
        while ((zoomValueSpec = ZoomValueSpec.zoomValuesTable[n2]) != null) {
            this.maxZoom.addItem(this.addPercent(zoomValueSpec.getUIString(false)));
            ++n2;
        }
    }

    private void createOptionsElements() {
        this.fDisplayOpenDlg = new Checkbox(Util.getDialogString("Prefs:DisplayOpenDialog"));
        this.addRow(this.options, this.gOptions, this.cOptions, this.fDisplayOpenDlg);
    }

    public void doErrorDialog(String string) {
        MessageDialog messageDialog = new MessageDialog(PEUtil.getFrame(this), Util.getDialogString("Dialog:InvalidEntry"), Util.getDialogString("Dialog:NotValidNumber", string));
        messageDialog.runDialog();
    }

    private String getCommand(String string) {
        Enumeration<?> enumeration = this.cmd.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = this.cmd.getProperty(string2);
            if (!string3.equals(string)) continue;
            return string2;
        }
        return "";
    }

    private void initCommands() {
        this.cmd = new Properties();
        ((Hashtable)this.cmd).put("SinglePage", Util.getDialogString("PageView:SinglePage"));
        ((Hashtable)this.cmd).put("OneColumn", Util.getDialogString("PageView:Continuous"));
        ((Hashtable)this.cmd).put("TwoColumnRight", Util.getDialogString("PageView:FacingPages"));
        ((Hashtable)this.cmd).put("Sans&Serif", Util.getDialogString("Text:Sans&Serif"));
        ((Hashtable)this.cmd).put("Sans", Util.getDialogString("Text:Sans"));
        ((Hashtable)this.cmd).put("Serif", Util.getDialogString("Text:Serif"));
        ((Hashtable)this.cmd).put("Points", Util.getDialogString("Units:Points"));
        ((Hashtable)this.cmd).put("Inches", Util.getDialogString("Units:Inches"));
        ((Hashtable)this.cmd).put("Millimeters", Util.getDialogString("Units:Millimeters"));
        ((Hashtable)this.cmd).put("Zoom:FitPage", Util.getDialogString("Zoom:FitPage"));
        ((Hashtable)this.cmd).put("Zoom:FitWidth", Util.getDialogString("Zoom:FitWidth"));
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.fGreekText) {
            this.fGreekTextLimit.setEnabled(itemEvent.getStateChange() == 1);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        super.keyReleased(keyEvent);
    }

    public void ok() {
        try {
            if (!this.applyPrefs()) {
                return;
            }
            super.ok();
        }
        catch (Exception exception) {
            Log.clog("PrefsDialog.actionPerformed: " + exception.toString());
        }
    }

    protected void populate() throws Exception {
        this.pageLayout.select(this.cmd.getProperty(ReaderPrefs.fDefPageLayout.stringValue(this.transaction), Util.getDialogString("PageView:SinglePage")));
        this.pageUnits.select(this.cmd.getProperty(ReaderPrefs.fPageUnitsStr.stringValue(this.transaction), Util.getDialogString("Units:Inches")));
        this.font.select(this.cmd.getProperty(ReaderPrefs.fSubstitutionFont.stringValue(this.transaction), Util.getDialogString("Text:Sans&Serif")));
        boolean bl = ReaderPrefs.fGreekText.booleanValue(this.transaction);
        this.fGreekText.setState(bl);
        int n = ReaderPrefs.fGreekTextLimit.intValue(this.transaction);
        this.fGreekTextLimit.setEnabled(bl);
        this.fGreekTextLimit.setText(Integer.toString(n));
        this.fDisplayLarge.setState(ReaderPrefs.fDisplayLargeImages.booleanValue(this.transaction));
        ZoomValueSpec zoomValueSpec = ReaderPrefs.fDefaultZoom.zoomValueSpecValue(this.transaction);
        this.defaultZoom.select(this.addPercent(zoomValueSpec.getUIString(false)));
        double d = ReaderPrefs.fMaxVisibleZoom.doubleValue(this.transaction);
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMinimumIntegerDigits(1);
        numberFormat.setMaximumIntegerDigits(4);
        numberFormat.setMaximumFractionDigits(2);
        this.maxZoom.select(this.addPercent(numberFormat.format(100.0 * d)));
        boolean bl2 = ReaderPrefs.fShowOpenDialogOnStartup.booleanValue(this.transaction);
        this.fDisplayOpenDlg.setState(bl2);
        this.helpSystemPanel.sitePrefs.setText(ReaderPrefs.fSitePrefsURL);
        this.helpSystemPanel.helpURL.setText(ReaderPrefs.fHelpFileURL);
        this.helpSystemPanel.licenseURL.setText(ReaderPrefs.fLicenseFileURL);
        this.helpSystemPanel.browser.setText(ReaderPrefs.fBrowser);
        this.fontSourcePanel.setSource(ReaderPrefs.getAcrobatFontsSource());
        this.fontSourcePanel.setFonts(FontCache.getTheFontCache().getCachedAcrobatFonts());
        this.invalidate();
        this.validate();
        this.proxyTab.init();
    }

    private String removePercent(String string) {
        if (string.charAt(string.length() - 1) == '%') {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private boolean validatePrefs() {
        boolean bl = true;
        String string = "";
        Component component = this.fGreekTextLimit;
        try {
            if (this.fGreekText.getState()) {
                string = this.fGreekTextLimit.getText().trim();
                this.fGreekTextLimit.setText(string);
                int n = Integer.parseInt(string);
                if (n == 0) {
                    this.fGreekText.setState(false);
                } else if (n < 0) {
                    throw new NumberFormatException();
                }
            }
            component = this.defaultZoom;
            string = this.removePercent(this.defaultZoom.getSelectedItem());
            ZoomValueSpec zoomValueSpec = ZoomValueSpec.validateSpec(string, false);
            component = this.maxZoom;
            string = this.maxZoom.getSelectedItem();
            zoomValueSpec = ZoomValueSpec.validateSpec(string, false);
        }
        catch (Exception exception) {
            bl = false;
            this.doErrorDialog(string);
            component.requestFocus();
        }
        return bl;
    }

    public class TextFieldWithLimit
    extends TextField
    implements TextListener {
        int limit;

        public TextFieldWithLimit(String string, int n, int n2) {
            super(string, n);
            this.limit = n2;
            this.addTextListener(this);
        }

        public void textValueChanged(TextEvent textEvent) {
            String string = this.getText();
            if (string.length() > this.limit) {
                this.setText(string.substring(0, this.limit));
                this.setCaretPosition(this.limit);
            }
        }
    }

    public class InsetPanel
    extends Panel {
        protected Insets insets;

        public InsetPanel(LayoutManager layoutManager) {
            this.setLayout(layoutManager);
            this.insets = new Insets(20, 10, 10, 10);
        }

        public Insets getInsets() {
            return this.insets;
        }

        public void setInsets(Insets insets) {
            this.insets = insets;
        }
    }

    public class HelpSystemPanel
    extends GroupBox {
        TextField sitePrefs;
        TextField helpURL;
        TextField licenseURL;
        TextField browser;
        Button browse;

        public HelpSystemPanel() {
            super(Util.getDialogString("Prefs:HelpSetup"));
            this.setInsets(new Insets(20, 10, 10, 10));
            this.setLayout(new RowLayout(1));
            Label label = new Label(Util.getDialogString("Prefs:RefreshButtonLabel"));
            this.add(label);
            this.sitePrefs = new TextField(30);
            this.add(this.sitePrefs);
            Label label2 = new Label(Util.getDialogString("Prefs:HelpFileURL"));
            this.add(label2);
            this.helpURL = new TextField(30);
            this.add(this.helpURL);
            Label label3 = new Label(Util.getDialogString("Prefs:LicenseFileURL"));
            this.add(label3);
            this.licenseURL = new TextField(30);
            this.add(this.licenseURL);
            Label label4 = new Label(Util.getDialogString("Prefs:BrowserLocation"));
            this.browse = new Button(Util.getDialogString("Prefs:BrowserLocaterButton"));
            this.browse.addActionListener(PrefsDialog.this);
            this.browser = new TextField(30);
            Panel panel = new Panel(new BorderLayout());
            panel.add((Component)this.browser, "Center");
            panel.add((Component)this.browse, "East");
            this.add(label4);
            this.add(panel);
        }
    }

    public class FontSourcePanel
    extends GroupBox {
        private List list;
        private TextField source;

        public FontSourcePanel() {
            super(Util.getDialogString("Prefs:AcrobatFontsList"));
            String string;
            this.setInsets(new Insets(20, 10, 10, 10));
            this.setLayout(new RowLayout(1));
            this.list = new List(10);
            this.add(this.list);
            Label label = new Label(Util.getDialogString("Prefs:AcrobatFontsLocation"));
            this.add(label);
            try {
                string = FontCache.getTheFontCache().getAcrobatFontsLocation();
            }
            catch (Exception exception) {
                string = Util.getDialogString("Prefs:AcrobatFontsLocationError");
            }
            TextField textField = new TextField(string);
            this.add(textField);
            textField.setEnabled(false);
            Label label2 = new Label(Util.getDialogString("Prefs:AcrobatFontsServerURL"));
            this.add(label2);
            this.source = new TextField();
            this.add(this.source);
        }

        public String getSource() {
            return this.source.getText().trim();
        }

        public void setFonts(String[] stringArray) {
            block3: {
                if (stringArray == null) break block3;
                try {
                    this.list.removeAll();
                    QuickSort.sort(stringArray, 0, stringArray.length - 1);
                    int n = 0;
                    while (n < stringArray.length) {
                        this.list.addItem(stringArray[n]);
                        ++n;
                    }
                }
                catch (Exception exception) {}
            }
        }

        public void setSource(String string) {
            this.source.setText(string);
        }
    }
}

