/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.ViewerCommand;
import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.CommandRegistry;
import com.adobe.acrobat.gui.PageView;
import com.adobe.acrobat.gui.PrintServerSetupDialog;
import com.adobe.acrobat.gui.PrintUI;
import com.adobe.acrobat.gui.SimpleUIVerb;
import com.adobe.pe.awt.UIVerb;
import com.adobe.pe.extend.Extensible;
import com.adobe.pe.extend.Extension;
import com.adobe.pe.extend.ExtensionDataProvider;
import com.adobe.pe.extend.ProviderNotFoundException;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.Transactor;
import com.adobe.pe.vtypes.VBoolean;
import com.adobe.util.Assert;
import java.awt.Rectangle;
import java.util.Properties;

class PrintUIVerb
extends UIVerb
implements ViewerCommand {
    static final int kPrint = 1;
    static final int kPrintSetup = 2;
    private static final String VDocCanPrintBoolean_K = "VDocCanPrintBoolean";
    private static ExtensionDataProvider provider = null;
    private AcroViewContext context;
    private int selector;

    PrintUIVerb(AcroViewContext acroViewContext, int n) {
        this.context = acroViewContext;
        this.selector = n;
        PrintTransactor printTransactor = new PrintTransactor();
        VBoolean vBoolean = null;
        switch (n) {
            case 1: {
                vBoolean = new VDocCanPrintBoolean(acroViewContext);
                break;
            }
            case 2: {
                vBoolean = new VBoolean(true);
                break;
            }
        }
        this.setAttributes(printTransactor, vBoolean, null);
    }

    private static synchronized void initProvider() {
        if (provider == null) {
            provider = new ExtensionDataProvider(){

                public Object provide(String string, Extensible extensible) {
                    Assert.notFalse(extensible instanceof AcroViewContext);
                    if (string.equals(PrintUIVerb.VDocCanPrintBoolean_K)) {
                        AcroViewContext acroViewContext = (AcroViewContext)extensible;
                        return new VDocCanPrintBoolean(acroViewContext);
                    }
                    throw new ProviderNotFoundException(string);
                }
            };
            Extension.registerProvider(VDocCanPrintBoolean_K, provider);
        }
    }

    public static void registerCommands(AcroViewContext acroViewContext) {
        PrintUIVerb printUIVerb = new PrintUIVerb(acroViewContext, 1);
        CommandRegistry.addCommand(printUIVerb, acroViewContext, "Print");
        CommandRegistry.addCommand(new PrintUIVerb(acroViewContext, 2), acroViewContext, "PrintSetup");
    }

    class PrintTransactor
    extends Transactor {
        PrintTransactor() {
        }

        public void buildChanges(Transaction transaction) throws Exception {
            if (PrintUIVerb.this.selector == 1) {
                this.printFileWithUI(transaction);
            } else if (PrintUIVerb.this.selector == 2) {
                new PrintServerSetupDialog(PrintUIVerb.this.context, transaction);
            }
        }

        public void printFileWithUI(Transaction transaction) throws Exception {
            PageView pageView = PrintUIVerb.this.context.getPageView();
            Rectangle rectangle = pageView.getVisiblePagesRectangle(transaction);
            int n = pageView.getTopLeftPage(transaction);
            int n2 = pageView.getNumColumns(transaction);
            int n3 = pageView.getNumPages(transaction);
            int n4 = rectangle.x;
            int n5 = rectangle.y;
            int n6 = rectangle.x + rectangle.width - 1;
            int n7 = rectangle.y + rectangle.height - 1;
            int n8 = n5 * n2 + n4 + n;
            int n9 = n7 * n2 + n6 + n;
            if (n8 < 0) {
                n8 = 0;
            } else if (n8 >= n3) {
                n8 = n3 - 1;
            }
            if (n9 < 0) {
                n9 = 0;
            } else if (n9 >= n3) {
                n9 = n3 - 1;
            }
            Properties properties = new Properties();
            PrintUI.printPages(transaction, PrintUIVerb.this.context, properties, n8 + 1, n9 + 1);
        }
    }

    static class VDocCanPrintBoolean
    extends VBoolean {
        AcroViewContext context;

        VDocCanPrintBoolean(AcroViewContext acroViewContext) {
            this.context = acroViewContext;
        }

        protected final boolean computeBoolean(Requester requester) throws Exception {
            return SimpleUIVerb.getVDocIsOpenBoolean(this.context).booleanValue(requester) && this.context.couldGetPermission(requester, "Print");
        }
    }
}

