/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.BookmarkView;
import com.adobe.acrobat.gui.GalleyScroller;
import com.adobe.acrobat.gui.NavigationBar;
import com.adobe.acrobat.gui.PageView;
import com.adobe.acrobat.gui.SpinnyButton;
import com.adobe.acrobat.gui.SplitPane;
import com.adobe.acrobat.gui.VSplitPane;
import com.adobe.acrobat.gui.VViewerToolBar;
import com.adobe.pe.awt.LightWeightPanel;
import com.adobe.pe.awt.PEPanel;
import com.adobe.pe.awt.ToolBar;
import com.adobe.pe.awt.VComponentDimension;
import com.adobe.pe.awt.VPaintingCanvas;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.SystemColor;

public class ViewerPanel
extends PEPanel {
    GalleyScroller galleyScroller;
    private NavigationBar navBar;
    private Container topPanel;
    private AcroViewContext context;

    public ViewerPanel(AcroViewContext acroViewContext) throws Exception {
        this.setLayout(new BorderLayout());
        this.context = acroViewContext;
        acroViewContext.setRootComponent(this);
        this.createComponents();
    }

    public void addStatusbar() {
        if (!this.containsComponent(this.navBar)) {
            this.add((Component)this.navBar, "South");
        }
    }

    public void addToolbar() {
        if (!this.containsComponent(this.topPanel)) {
            this.add((Component)this.topPanel, "North");
        }
    }

    private boolean containsComponent(Component component) {
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] == component) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void createComponents() throws Exception {
        PageView pageView = this.context.getPageView();
        this.galleyScroller = new GalleyScroller(pageView);
        VViewerToolBar vViewerToolBar = new VViewerToolBar(this.context);
        ToolBar toolBar = new ToolBar(vViewerToolBar, this.context);
        SpinnyButton spinnyButton = new SpinnyButton();
        this.galleyScroller.getGalleyView().addSpinny(spinnyButton);
        this.galleyScroller.setBackground(ViewerPanel.getDesktopColor());
        this.topPanel = new LightWeightPanel();
        this.topPanel.setLayout(new BorderLayout());
        this.topPanel.add((Component)toolBar, "Center");
        this.topPanel.add((Component)spinnyButton, "East");
        this.navBar = new NavigationBar(this.context);
        SplitPane splitPane = VSplitPane.getVSplitPane(this.context).splitPaneValue(null);
        splitPane.closeLeftPane();
        VComponentDimension.attachVDimensionToComponent(this.context.getTocDimension(), splitPane.getLeftPanel());
        BookmarkView bookmarkView = new BookmarkView(this.context);
        splitPane.setLeftComponent(bookmarkView.getScrollPane(), bookmarkView);
        splitPane.setRightComponent(this.galleyScroller);
        this.add((Component)splitPane, "Center");
        this.add((Component)this.topPanel, "North");
        this.add((Component)this.navBar, "South");
    }

    public AcroViewContext getAcroViewContext() {
        return this.context;
    }

    public static Color getDesktopColor() {
        return SystemColor.controlShadow;
    }

    public VPaintingCanvas getGalleyView() {
        return this.galleyScroller.getGalleyView();
    }

    public boolean hasStatusbar() {
        return this.containsComponent(this.navBar);
    }

    public boolean hasToolbar() {
        return this.containsComponent(this.topPanel);
    }

    public void removeStatusbar() {
        if (this.containsComponent(this.navBar)) {
            this.remove(this.navBar);
        }
    }

    public void removeToolbar() {
        if (this.containsComponent(this.topPanel)) {
            this.remove(this.topPanel);
        }
    }

    public void requestFocus() {
        this.galleyScroller.requestFocus();
    }
}

