/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf;

import com.adobe.acrobat.page.Content;
import com.adobe.acrobat.page.ContentArray;
import com.adobe.acrobat.page.ContentOperator;
import com.adobe.acrobat.page.ContentParser;
import com.adobe.acrobat.page.GState;
import com.adobe.acrobat.page.VFormContentArray;
import com.adobe.acrobat.page.VXObjectFormProps;
import com.adobe.acrobat.pdf.ContentImage;
import com.adobe.acrobat.pdf.ContentXObjectForm;
import com.adobe.acrobat.pdf.VPDFColorModel;
import com.adobe.acrobat.pdf.image.PDFColorModel;
import com.adobe.acrobat.pdfobjstore.PDFDict;
import com.adobe.acrobat.pdfobjstore.PDFObj;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.FloatRect;
import com.adobe.acrobat.sidecar.SidecarImage;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.util.StreamFactory;

class Funct_Do
extends ContentOperator {
    private int width;
    private int height;
    private int bitsPerComponent;
    private float[] decode;
    private static final String Page_K = "Page";
    private static final String H_K = "H";
    private static final String Height_K = "Height";
    private static final String W_K = "W";
    private static final String Width_K = "Width";
    private static final String XObject_K = "XObject";
    private static final String Image_K = "Image";
    private static final String Form_K = "Form";
    private static final String Subtype_K = "Subtype";
    private static final String BBox_K = "BBox";
    private static final String Matrix_K = "Matrix";
    private static final String Mask_K = "Mask";
    private static final String Length_K = "Length";

    Funct_Do() {
    }

    private SidecarImage getImage(Requester requester, ContentParser contentParser, PDFReference pDFReference) throws Exception {
        PDFObj pDFObj;
        PDFDict pDFDict = pDFReference.dictValue(requester);
        SidecarImage sidecarImage = null;
        this.width = pDFDict.get(Width_K).integerValue(requester);
        this.height = pDFDict.get(Height_K).integerValue(requester);
        PDFColorModel pDFColorModel = VPDFColorModel.getVPDFColorModel(pDFReference, false, contentParser.getResources()).colorModel(requester);
        StreamFactory streamFactory = pDFReference.getFilteredVStreamFactory().streamFactoryValue(requester);
        if (pDFDict.hasKey(Mask_K) && (pDFObj = pDFDict.get(Mask_K)).type(requester) == 6) {
            sidecarImage = this.getImage(requester, contentParser, pDFObj.pdfReferenceValue(requester));
        }
        return new SidecarImage(this.width, this.height, pDFColorModel, streamFactory, sidecarImage);
    }

    public void setUp(Requester requester, ContentParser contentParser) throws Exception {
        PDFReference pDFReference = contentParser.getResources();
        String string = contentParser.popName();
        PDFDict pDFDict = pDFReference.dictValue(requester);
        PDFReference pDFReference2 = pDFDict.get(XObject_K).dictValue(requester).get(string).pdfReferenceValue(requester);
        PDFDict pDFDict2 = pDFReference2.dictValue(requester);
        String string2 = pDFDict2.get(Subtype_K).nameValue(requester);
        if (string2.equals(Image_K)) {
            this.setupImage(requester, contentParser, pDFReference2);
        } else if (string2.equals(Form_K)) {
            this.setupForm(requester, contentParser, pDFReference2, pDFReference);
        }
    }

    private void setupForm(Requester requester, ContentParser contentParser, PDFReference pDFReference, PDFReference pDFReference2) throws Exception {
        PDFDict pDFDict = pDFReference.dictValue(requester);
        GState gState = contentParser.getGState();
        AffineTransform affineTransform = VXObjectFormProps.getFormVMatrix(pDFReference).affineTransformValue(requester);
        FloatRect floatRect = VXObjectFormProps.getFormVBBox(pDFReference).floatRectValue(requester);
        ContentArray contentArray = VFormContentArray.getVFormContentArray(pDFReference, pDFReference2).contentArrayValue(requester);
        ContentXObjectForm contentXObjectForm = new ContentXObjectForm(gState, contentArray, affineTransform, floatRect, contentParser.getContentObjStart(), contentParser.getContentObjEnd());
        contentParser.addContent(contentXObjectForm);
    }

    private void setupImage(Requester requester, ContentParser contentParser, PDFReference pDFReference) throws Exception {
        SidecarImage sidecarImage = this.getImage(requester, contentParser, pDFReference);
        ContentImage contentImage = new ContentImage(contentParser.getGState(), sidecarImage, contentParser.getContentObjStart(), contentParser.getContentObjEnd());
        Content content = contentParser.getLastContent();
        if (content != null && content instanceof ContentImage) {
            FloatRect floatRect = content.getBoundingBox();
            FloatRect floatRect2 = contentImage.getBoundingBox();
            if (floatRect.getxMin() == floatRect2.getxMin() && floatRect.getxMax() == floatRect2.getxMax() && Math.abs(floatRect.getyMin() - floatRect2.getyMax()) <= 1.0) {
                sidecarImage.setStitchBand();
            }
        }
        contentParser.addContent(contentImage);
    }
}

