/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf;

import com.adobe.acrobat.pdf.VPDFFloatRectFromVPDFObj;
import com.adobe.acrobat.pdfobjstore.PDFArray;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.pdfobjstore.VPDFObj;
import com.adobe.acrobat.sidecar.FloatRect;
import com.adobe.acrobat.vtypes.VFloatRect;
import com.adobe.pe.extend.Extensible;
import com.adobe.pe.extend.Extension;
import com.adobe.pe.extend.ExtensionDataProvider;
import com.adobe.pe.extend.ProviderNotFoundException;
import com.adobe.pe.notify.Requester;
import com.adobe.util.Assert;

public class VPDFFloatRect
extends VFloatRect {
    static final String VPDFFloatRect_K = "VPDFFloatRect";
    private static ExtensionDataProvider provider = null;
    PDFReference arrayRef;

    public VPDFFloatRect(PDFReference pDFReference) {
        this.arrayRef = pDFReference;
    }

    protected FloatRect computeFloatRect(Requester requester) throws Exception {
        PDFArray pDFArray = this.arrayRef.arrayValue(requester);
        if (pDFArray.size() != 4) {
            throw new Exception("Malformed Rectangle");
        }
        FloatRect floatRect = new FloatRect(this.extractOneFloatValue(pDFArray, 0, requester), this.extractOneFloatValue(pDFArray, 1, requester), this.extractOneFloatValue(pDFArray, 2, requester), this.extractOneFloatValue(pDFArray, 3, requester));
        return floatRect;
    }

    private double extractOneFloatValue(PDFArray pDFArray, int n, Requester requester) throws Exception {
        return pDFArray.get(n).doubleValue(requester);
    }

    public static VFloatRect getVPDFFloatRect(PDFReference pDFReference) {
        VPDFFloatRect.initProvider();
        return (VFloatRect)pDFReference.getExtensionData(VPDFFloatRect_K);
    }

    public static VFloatRect getVPDFFloatRect(VPDFObj vPDFObj) {
        return new VPDFFloatRectFromVPDFObj(vPDFObj);
    }

    private static synchronized void initProvider() {
        if (provider == null) {
            provider = new ExtensionDataProvider(){

                public Object provide(String string, Extensible extensible) {
                    Assert.notFalse(extensible instanceof PDFReference);
                    PDFReference pDFReference = (PDFReference)extensible;
                    if (string.equals(VPDFFloatRect.VPDFFloatRect_K)) {
                        return new VPDFFloatRect((PDFReference)extensible);
                    }
                    throw new ProviderNotFoundException(string);
                }
            };
            Extension.registerProvider(VPDFFloatRect_K, provider);
        }
    }
}

