/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf;

import com.adobe.acrobat.page.ContentArray;
import com.adobe.acrobat.page.GState;
import com.adobe.acrobat.pdf.Pattern;
import com.adobe.acrobat.pdf.VPDFFloatRect;
import com.adobe.acrobat.pdf.VPDFTransform;
import com.adobe.acrobat.pdf.VPattern;
import com.adobe.acrobat.pdf.VShading;
import com.adobe.acrobat.pdf.image.Shading;
import com.adobe.acrobat.pdfobjstore.PDFDict;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.FloatRect;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.util.StreamFactory;

class VPatternByRef
extends VPattern {
    private static final String PatternType_K = "PatternType";
    private static final String PaintType_K = "PaintType";
    private static final String Resources_K = "Resources";
    private static final String TilingType_K = "TilingType";
    private static final String BBox_K = "BBox";
    private static final String XStep_K = "XStep";
    private static final String YStep_K = "YStep";
    private static final String Matrix_K = "Matrix";
    private static final String Shading_K = "Shading";
    private static final String ExtGState_K = "ExtGState";
    private PDFReference pattRef;

    VPatternByRef(PDFReference pDFReference, PDFReference pDFReference2) {
        super(pDFReference2);
        this.pattRef = pDFReference;
    }

    protected final Pattern computePattern(Requester requester) throws Exception {
        PDFDict pDFDict = this.pageResources.dictValue(requester);
        PDFDict pDFDict2 = this.pattRef.dictValue(requester);
        Pattern pattern = null;
        int n = pDFDict2.get(PatternType_K).integerValue(requester);
        AffineTransform affineTransform = null;
        affineTransform = pDFDict2.hasKey(Matrix_K) ? VPDFTransform.getVPDFTransform(pDFDict2.get(Matrix_K).pdfReferenceValue(requester)).affineTransformValue(requester) : AffineTransform.getIdentityMatrix();
        GState gState = null;
        gState = GState.getInitialGState();
        switch (n) {
            case 1: {
                PDFReference pDFReference = pDFDict2.get(Resources_K).pdfReferenceValue(requester);
                int n2 = pDFDict2.get(PaintType_K).integerValue(requester);
                int n3 = pDFDict2.get(TilingType_K).integerValue(requester);
                float f = pDFDict2.get(XStep_K).floatValue(requester);
                float f2 = pDFDict2.get(YStep_K).floatValue(requester);
                FloatRect floatRect = VPDFFloatRect.getVPDFFloatRect(pDFDict2.get(BBox_K).pdfReferenceValue(requester)).floatRectValue(requester);
                StreamFactory streamFactory = this.pattRef.getFilteredVStreamFactory().streamFactoryValue(requester);
                ContentArray contentArray = new ContentArray(pDFReference, streamFactory, requester);
                pattern = new Pattern(n2, n3, f, f2, floatRect, affineTransform, gState, contentArray);
                break;
            }
            case 2: {
                Shading shading = VShading.getVShading(pDFDict2.get(Shading_K).pdfReferenceValue(requester), this.pageResources).shading(requester);
                pattern = new Pattern(shading, affineTransform, gState);
                break;
            }
            default: {
                throw new Exception("Unknown Pattern Type");
            }
        }
        return pattern;
    }
}

