/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf.image;

import com.adobe.acrobat.pdf.image.DeviceGrayColorModel;
import com.adobe.acrobat.pdf.image.PDFColorModel;
import com.adobe.acrobat.pdf.image.PDFColorParams;
import com.adobe.util.MemUtil;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

public class CalGrayColorModel
extends PDFColorModel {
    private int[] rgb;
    private boolean isBlendable;
    private boolean isOrdered;
    private ColorModel javaColorModel;

    public CalGrayColorModel() {
        this(new PDFColorParams(6));
    }

    public CalGrayColorModel(PDFColorParams pDFColorParams) {
        super(pDFColorParams);
        float f;
        float f2;
        int n = pDFColorParams.getBitsPerComponent();
        float[] fArray = pDFColorParams.getDecode();
        float[] fArray2 = pDFColorParams.getBlackPt();
        float[] fArray3 = pDFColorParams.getWhitePt();
        float[] fArray4 = pDFColorParams.getGamma();
        int[] nArray = pDFColorParams.getAlphaMask();
        if (fArray != null && fArray.length >= 2) {
            f2 = fArray[0];
            f = fArray[1] - fArray[0];
        } else {
            f2 = 0.0f;
            f = 1.0f;
        }
        f /= 255.0f;
        this.rgb = MemUtil.allocInt(256);
        float[] fArray5 = new float[3];
        this.isOrdered = true;
        this.isBlendable = true;
        int n2 = 0;
        while (n2 < 256) {
            if (nArray != null && nArray[0] <= n2 && n2 <= nArray[1]) {
                this.rgb[n2] = 0;
                this.isBlendable = false;
            } else {
                float f3 = f2 + (float)n2 * f;
                if (fArray4 != null) {
                    f3 = (float)Math.pow(f3, fArray4[0]);
                }
                fArray5[0] = fArray2[0] + f3 * (fArray3[0] - fArray2[0]);
                fArray5[1] = fArray2[1] + f3 * (fArray3[1] - fArray2[1]);
                fArray5[2] = fArray2[2] + f3 * (fArray3[2] - fArray2[2]);
                this.rgb[n2] = PDFColorModel.XYZtoRGB(fArray5);
                if ((this.rgb[n2] >>> 16 & 0xFF) != (this.rgb[n2] >>> 8 & 0xFF) || (this.rgb[n2] & 0xFF) != (this.rgb[n2] >>> 8 & 0xFF)) {
                    this.isBlendable = false;
                }
                if ((this.rgb[n2] & 0xFF) != n2) {
                    this.isOrdered = false;
                }
            }
            ++n2;
        }
        if (!this.isBlendable) {
            this.isOrdered = false;
        }
    }

    public boolean canBlend() {
        return this.isBlendable;
    }

    public int getAlpha(int n) {
        return this.rgb[n & 0xFF] >>> 24 & 0xFF;
    }

    public float[] getBlack() {
        float[] fArray = new float[]{0.0f};
        return fArray;
    }

    public PDFColorModel getBlendModel() {
        if (this.isBlendable) {
            return DeviceGrayColorModel.DefaultColorModel;
        }
        return this;
    }

    public int getBlue(int n) {
        return this.rgb[n & 0xFF] & 0xFF;
    }

    public int getGreen(int n) {
        return this.rgb[n & 0xFF] >>> 8 & 0xFF;
    }

    public ColorModel getJavaColorModel() {
        byte[] byArray = MemUtil.allocByte(256);
        byte[] byArray2 = MemUtil.allocByte(256);
        byte[] byArray3 = MemUtil.allocByte(256);
        int n = 0;
        while (n < 256) {
            byArray[n] = (byte)(this.rgb[n] >> 16);
            byArray2[n] = (byte)(this.rgb[n] >> 8);
            byArray3[n] = (byte)this.rgb[n];
            ++n;
        }
        if (this.javaColorModel == null) {
            this.javaColorModel = new IndexColorModel(8, 256, byArray, byArray2, byArray3);
        }
        return this.javaColorModel;
    }

    public int getRGB(float f) {
        float[] fArray = this.params.getBlackPt();
        float[] fArray2 = this.params.getWhitePt();
        float[] fArray3 = this.params.getGamma();
        if (fArray3 != null) {
            f = (float)Math.pow(f, fArray3[0]);
        }
        float f2 = fArray[0] + f * (fArray2[0] - fArray[0]);
        float f3 = fArray[1] + f * (fArray2[1] - fArray[1]);
        float f4 = fArray[2] + f * (fArray2[2] - fArray[2]);
        return PDFColorModel.XYZtoRGB(f2, f3, f4);
    }

    public int getRGB(int n) {
        return this.rgb[n & 0xFF];
    }

    public int getRGB(float[] fArray) {
        if (fArray.length >= 1) {
            return this.getRGB(fArray[0]);
        }
        throw new RuntimeException("CalGrayColorModel.getRGB(c[]) -- arrayToShort");
    }

    public int getRed(int n) {
        return this.rgb[n & 0xFF] >>> 16 & 0xFF;
    }

    public void toBlend(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        if (!this.isOrdered) {
            while (n3-- > 0) {
                byArray2[n2++] = (byte)this.rgb[byArray[n++] & 0xFF];
            }
        } else if (byArray != byArray2 || n != n2) {
            System.arraycopy(byArray, n, byArray2, n2, n3);
        }
    }

    public void toRGB(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            nArray[n2 + n4] = this.rgb[byArray[n + n4] & 0xFF];
            ++n4;
        }
    }

    public String toString() {
        return "CalGray";
    }
}

