/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf.image;

import com.adobe.acrobat.filters.BitfieldInputStream;
import com.adobe.acrobat.pdf.ColorValue;
import com.adobe.acrobat.pdf.image.IndexedColorModel;
import com.adobe.acrobat.pdf.image.PDFColorModel;
import com.adobe.acrobat.pdf.image.ShadeEdge;
import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.FloatPoint;
import com.adobe.acrobat.sidecar.FloatRect;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;

public class TriShade {
    FloatPoint[] pt = new FloatPoint[3];
    ColorValue[] cv = new ColorValue[3];
    TriShade next = null;

    private TriShade() {
    }

    public TriShade(FloatPoint floatPoint, FloatPoint floatPoint2, FloatPoint floatPoint3, ColorValue colorValue, ColorValue colorValue2, ColorValue colorValue3) {
        this();
        this.pt[0] = floatPoint;
        this.pt[1] = floatPoint2;
        this.pt[2] = floatPoint3;
        this.cv[0] = colorValue;
        this.cv[1] = colorValue2;
        this.cv[2] = colorValue3;
    }

    public static TriShade ReadTriangleList(InputStream inputStream, int n, int n2, int n3, float[] fArray, PDFColorModel pDFColorModel, int n4) {
        BitfieldInputStream bitfieldInputStream = new BitfieldInputStream(inputStream);
        TriShade triShade = null;
        boolean bl = pDFColorModel instanceof IndexedColorModel;
        IndexedColorModel indexedColorModel = null;
        if (bl) {
            indexedColorModel = (IndexedColorModel)pDFColorModel;
            pDFColorModel = indexedColorModel.getBaseColorModel();
        }
        int n5 = fArray.length / 2 - 2;
        double[] dArray = new double[n5 + 2];
        double[] dArray2 = new double[n5 + 2];
        double d = (1L << n) - 1L;
        double d2 = (1L << n2) - 1L;
        int n6 = 0;
        while (n6 < n5 + 2) {
            dArray[n6] = fArray[2 * n6];
            dArray2[n6] = fArray[2 * n6 + 1] - fArray[2 * n6];
            ++n6;
        }
        long l = 0L;
        if (n4 == 0) {
            int n7 = 0;
            try {
                while (true) {
                    TriShade triShade2 = new TriShade();
                    TriShade triShade3 = triShade;
                    while (triShade3 != null && triShade3.next != null) {
                        triShade3 = triShade3.next;
                    }
                    bitfieldInputStream.read(0);
                    int n8 = (int)bitfieldInputStream.read(n3);
                    if (n8 < 0) break;
                    if (triShade3 == null) {
                        n8 = 0;
                    }
                    n7 = 0;
                    switch (n8 &= 3) {
                        case 1: {
                            triShade2.pt[0] = triShade3.pt[1];
                            triShade2.pt[1] = triShade3.pt[2];
                            triShade2.cv[0] = triShade3.cv[1];
                            triShade2.cv[1] = triShade3.cv[2];
                            n7 = 2;
                            break;
                        }
                        case 2: {
                            triShade2.pt[0] = triShade3.pt[0];
                            triShade2.pt[1] = triShade3.pt[2];
                            triShade2.cv[0] = triShade3.cv[0];
                            triShade2.cv[1] = triShade3.cv[2];
                            n7 = 2;
                            break;
                        }
                    }
                    int n9 = n7;
                    while (n9 < 3) {
                        double d3 = (double)bitfieldInputStream.read(n) / d;
                        double d4 = dArray[0] + dArray2[0] * d3;
                        d3 = (double)bitfieldInputStream.read(n) / d;
                        double d5 = dArray[1] + dArray2[1] * d3;
                        triShade2.pt[n9] = new FloatPoint(d4, d5);
                        float[] fArray2 = new float[n5];
                        int n10 = 0;
                        while (n10 < n5) {
                            l = bitfieldInputStream.read(n2);
                            fArray2[n10] = (float)(dArray[2 + n10] + dArray2[2 + n10] * ((double)l / d2));
                            ++n10;
                        }
                        triShade2.cv[n9] = bl ? new ColorValue(pDFColorModel, indexedColorModel.getBaseColor(fArray2[0])) : new ColorValue(pDFColorModel, fArray2);
                        if (n9 != 2) {
                            n8 = (int)bitfieldInputStream.read(n3);
                        }
                        ++n9;
                    }
                    if (l < 0L) continue;
                    if (triShade == null) {
                        triShade = triShade2;
                        continue;
                    }
                    triShade.append(triShade2);
                }
            }
            catch (IOException iOException) {}
        } else {
            try {
                double d6;
                FloatPoint[][] floatPointArray = new FloatPoint[2][n4];
                ColorValue[][] colorValueArray = new ColorValue[2][n4];
                int n11 = 0;
                while (n11 < n4) {
                    bitfieldInputStream.read(0);
                    d6 = (double)bitfieldInputStream.read(n) / d;
                    double d7 = dArray[0] + dArray2[0] * d6;
                    d6 = (double)bitfieldInputStream.read(n) / d;
                    double d8 = dArray[1] + dArray2[1] * d6;
                    floatPointArray[0][n11] = new FloatPoint(d7, d8);
                    float[] fArray3 = new float[n5];
                    int n12 = 0;
                    while (n12 < n5) {
                        fArray3[n12] = (float)(dArray[2 + n12] + dArray2[2 + n12] * ((double)bitfieldInputStream.read(n2) / d2));
                        ++n12;
                    }
                    colorValueArray[0][n11] = bl ? new ColorValue(pDFColorModel, indexedColorModel.getBaseColor(fArray3[0])) : new ColorValue(pDFColorModel, fArray3);
                    ++n11;
                }
                while (l >= 0L) {
                    int n13 = 0;
                    while (n13 < n4) {
                        bitfieldInputStream.read(0);
                        d6 = (double)bitfieldInputStream.read(n) / d;
                        double d9 = dArray[0] + dArray2[0] * d6;
                        d6 = (double)bitfieldInputStream.read(n) / d;
                        double d10 = dArray[1] + dArray2[1] * d6;
                        floatPointArray[1][n13] = new FloatPoint(d9, d10);
                        float[] fArray4 = new float[n5];
                        int n14 = 0;
                        while (n14 < n5) {
                            l = bitfieldInputStream.read(n2);
                            fArray4[n14] = (float)(dArray[2 + n14] + dArray2[2 + n14] * ((double)l / d2));
                            ++n14;
                        }
                        if (l < 0L) break;
                        colorValueArray[1][n13] = bl ? new ColorValue(pDFColorModel, indexedColorModel.getBaseColor(fArray4[0])) : new ColorValue(pDFColorModel, fArray4);
                        TriShade triShade4 = null;
                        if (n13 > 0) {
                            triShade4 = new TriShade(floatPointArray[1][n13 - 1], floatPointArray[0][n13 - 1], floatPointArray[0][n13], colorValueArray[1][n13 - 1], colorValueArray[0][n13 - 1], colorValueArray[0][n13]);
                            triShade4.append(new TriShade(floatPointArray[0][n13], floatPointArray[1][n13 - 1], floatPointArray[1][n13], colorValueArray[0][n13], colorValueArray[1][n13 - 1], colorValueArray[1][n13]));
                        }
                        if (triShade == null) {
                            triShade = triShade4;
                        } else {
                            triShade.append(triShade4);
                        }
                        ++n13;
                    }
                    System.arraycopy(floatPointArray[1], 0, floatPointArray[0], 0, n4);
                    System.arraycopy(colorValueArray[1], 0, colorValueArray[0], 0, n4);
                }
            }
            catch (IOException iOException) {}
        }
        return triShade;
    }

    private void append(TriShade triShade) {
        TriShade triShade2 = this;
        while (triShade2.next != null) {
            triShade2 = triShade2.next;
        }
        triShade2.next = triShade;
    }

    public Enumeration elements(AffineTransform affineTransform) {
        return new TriShadeEnumeration(this, affineTransform);
    }

    public FloatRect getBoundingBox() {
        double d;
        double d2;
        TriShade triShade = this;
        double d3 = d2 = this.pt[0].x;
        double d4 = d = this.pt[0].y;
        while (triShade != null) {
            int n = 0;
            while (n < 3) {
                double d5 = triShade.pt[n].x;
                if (d3 > d5) {
                    d3 = d5;
                } else if (d2 < d5) {
                    d2 = d5;
                }
                double d6 = triShade.pt[n].y;
                if (d4 > d6) {
                    d4 = d6;
                } else if (d < d6) {
                    d = d6;
                }
                ++n;
            }
            triShade = triShade.next;
        }
        return new FloatRect(d3, d4, d2, d);
    }

    class TriShadeEnumeration
    implements Enumeration {
        private AffineTransform fTransform;
        private TriShade triList;
        private ShadeEdge nextEdge;

        public TriShadeEnumeration(TriShade triShade2, AffineTransform affineTransform) {
            this.triList = triShade2;
            this.nextEdge = null;
            this.fTransform = affineTransform;
        }

        public boolean hasMoreElements() {
            while (this.nextEdge == null && this.triList != null) {
                FloatPoint[] floatPointArray = new FloatPoint[3];
                int n = 0;
                while (n < 3) {
                    floatPointArray[n] = this.triList.pt[n].deltaTransform(this.fTransform);
                    ++n;
                }
                if (!(floatPointArray[0].x == floatPointArray[1].x && floatPointArray[0].y == floatPointArray[1].y || floatPointArray[1].x == floatPointArray[2].x && floatPointArray[1].y == floatPointArray[2].y || floatPointArray[2].x == floatPointArray[0].x && floatPointArray[2].y == floatPointArray[0].y)) {
                    this.nextEdge = new ShadeEdge(floatPointArray[0], floatPointArray[1], floatPointArray[2], this.triList.cv[0], this.triList.cv[1], this.triList.cv[2], 0.0, 0.0, null);
                }
                this.triList = this.triList.next;
            }
            return this.nextEdge != null;
        }

        public Object nextElement() {
            if (this.nextEdge == null) {
                this.hasMoreElements();
            }
            ShadeEdge shadeEdge = this.nextEdge;
            if (this.nextEdge != null) {
                this.nextEdge = this.nextEdge.next;
            }
            return shadeEdge;
        }
    }
}

