/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdfobjstore;

import com.adobe.acrobat.bytearray.ByteArray;
import com.adobe.acrobat.bytearray.MemByteArray;
import com.adobe.util.MemUtil;
import java.io.IOException;
import java.io.InputStream;

class UncertainEndStreamStream
extends InputStream {
    private static final int kMaxBytesToSearchBackwardForEndstream = 512;
    private static final int kPageSizeForwardSearch = 200;
    private static final String endstream_K = "endstream";
    private static final int endstreamLength = "endstream".length();
    private ByteArray ba;
    private int start;
    private int bufferingPoint;
    private boolean buffered;
    private boolean markBuffered;
    private byte[] buffer;
    private byte[] markBuffer;
    private int bufOffset;
    private int markBufOffset;
    private int bufSize;
    private int markBufSize;
    private int length;
    private int bytesConsumed = 0;
    private int markBytesConsumed = 0;
    private InputStream stm;

    UncertainEndStreamStream(ByteArray byteArray, int n, int n2) throws Exception {
        this.ba = byteArray;
        this.start = n;
        this.length = n2;
        this.stm = byteArray.getByteStream(n, n2 + endstreamLength);
        this.bufferingPoint = Math.max(0, n2 + endstreamLength - 512);
    }

    public void close() throws IOException {
        this.stm.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadRestOfBytes() throws IOException {
        int n;
        this.bufSize = Math.min(512, this.length + endstreamLength);
        this.buffer = MemUtil.allocByte(this.bufSize);
        int n2 = 0;
        int n3 = 0;
        int n4 = this.bufSize;
        while (n4 > 0 && (n = this.stm.read(this.buffer, n3, n4)) != -1) {
            n2 += n;
            n3 += n;
            n4 -= n;
        }
        if (n4 != 0) {
            this.bufSize -= n4;
            byte[] byArray = MemUtil.allocByte(this.bufSize);
            System.arraycopy(this.buffer, 0, byArray, 0, this.bufSize);
            this.buffer = byArray;
        }
        try {
            InputStream inputStream;
            block13: {
                block12: {
                    MemByteArray memByteArray = new MemByteArray(this.buffer);
                    int n5 = memByteArray.findString(endstream_K, -1, -1, false, -1);
                    this.bufOffset = 0;
                    if (n5 != -1) {
                        if (n5 > 0 && this.buffer[n5 - 1] == 10) {
                            --n5;
                        }
                        if (n5 > 0 && this.buffer[n5 - 1] == 13) {
                            --n5;
                        }
                        this.bufSize = n5;
                        this.buffered = true;
                        return;
                    }
                    inputStream = this.ba.getByteStream(this.start + this.length + endstreamLength);
                    try {
                        int n6;
                        byte[] byArray = MemUtil.allocByte(200);
                        do {
                            n6 = this.buffer.length;
                            int n7 = inputStream.read(byArray);
                            if (n7 == -1) {
                                this.buffered = true;
                                Object var8_15 = null;
                                break block12;
                            }
                            byte[] byArray2 = MemUtil.allocByte(this.bufSize + n7);
                            System.arraycopy(this.buffer, 0, byArray2, 0, this.bufSize);
                            System.arraycopy(byArray, 0, byArray2, this.bufSize, n7);
                            this.buffer = byArray2;
                            this.bufSize += n7;
                        } while ((n5 = (memByteArray = new MemByteArray(this.buffer)).findString(endstream_K, n6 - endstreamLength + 1, -1, true, -1)) == -1);
                        this.buffered = true;
                        this.bufSize = n5;
                        break block13;
                    }
                    catch (Throwable throwable) {
                        Object var8_17 = null;
                        inputStream.close();
                        throw throwable;
                    }
                }
                inputStream.close();
                return;
            }
            Object var8_16 = null;
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public void mark(int n) {
        this.markBuffered = this.buffered;
        this.markBuffer = this.buffer == null ? null : (byte[])this.buffer.clone();
        this.markBytesConsumed = this.bytesConsumed;
        this.markBufOffset = this.bufOffset;
        this.markBufSize = this.bufSize;
        this.stm.mark(n);
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        if (this.bytesConsumed >= this.bufferingPoint) {
            if (!this.buffered) {
                this.loadRestOfBytes();
            }
            if (this.bufOffset == this.bufSize) {
                return -1;
            }
            ++this.bytesConsumed;
            return this.buffer[this.bufOffset++];
        }
        int n = this.stm.read();
        if (n != -1) {
            ++this.bytesConsumed;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = Math.min(n2, this.bufferingPoint - this.bytesConsumed);
        int n4 = 0;
        if (n3 > 0) {
            n4 = this.stm.read(byArray, n, n3);
            if (n4 == -1) {
                return -1;
            }
            this.bytesConsumed += n4;
            if (n4 < n3) {
                return n4;
            }
            n += n4;
            n2 -= n4;
        }
        if (n2 > 0) {
            int n5;
            if (!this.buffered) {
                this.loadRestOfBytes();
            }
            if ((n5 = Math.min(n2, this.bufSize - this.bufOffset)) == 0) {
                return n4 == 0 ? -1 : n4;
            }
            System.arraycopy(this.buffer, this.bufOffset, byArray, n, n5);
            this.bytesConsumed += n5;
            n4 += n5;
            this.bufOffset += n5;
        }
        return n4;
    }

    public void reset() throws IOException {
        this.buffered = this.markBuffered;
        this.buffer = this.markBuffer;
        this.bytesConsumed = this.markBytesConsumed;
        this.bufOffset = this.markBufOffset;
        this.bufSize = this.markBufSize;
        this.stm.reset();
    }
}

