/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdfobjstore.security;

import com.adobe.acrobat.pdfobjstore.PDFObjStore;
import com.adobe.acrobat.pdfobjstore.VPDFReference;
import com.adobe.acrobat.pdfobjstore.security.PDFObjStorePerms;
import com.adobe.acrobat.pdfobjstore.security.StandardSecurityHandler;
import com.adobe.acrobat.pdfobjstore.security.VEncryptDict;
import com.adobe.acrobat.pdfobjstore.security.VEncryptionMethod;
import com.adobe.acrobat.pdfobjstore.security.VPasswordCorrectBoolean;
import com.adobe.pe.extend.Extensible;
import com.adobe.pe.extend.Extension;
import com.adobe.pe.extend.ExtensionDataProvider;
import com.adobe.pe.extend.ProviderNotFoundException;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.vtypes.VBoolean;
import com.adobe.pe.vtypes.VString;
import com.adobe.util.Assert;
import java.util.Hashtable;

public abstract class SecurityHandler {
    private static Hashtable registry = new Hashtable();
    private static final String VEncryptDict_K = "VEncryptDict";
    private static final String VPasswordCorrectBoolean_K = "VPasswordCorrect";
    private static final String VEncryptionMethod_K = "VEncryptionMethod";
    private static ExtensionDataProvider provider = null;

    public abstract PDFObjStorePerms computePerms(Object var1, PDFObjStore var2, Requester var3) throws Exception;

    public static PDFObjStorePerms computePerms(String string, Object object, PDFObjStore pDFObjStore, Requester requester) throws Exception {
        SecurityHandler securityHandler = (SecurityHandler)registry.get(string);
        if (securityHandler == null) {
            throw new Exception("No registered security handler with the name " + securityHandler);
        }
        return securityHandler.computePerms(object, pDFObjStore, requester);
    }

    public static VPDFReference getEncryptDict(PDFObjStore pDFObjStore) {
        SecurityHandler.initProvider();
        return (VPDFReference)pDFObjStore.getExtensionData(VEncryptDict_K);
    }

    public static VString getEncryptionMethod(PDFObjStore pDFObjStore) {
        SecurityHandler.initProvider();
        return (VString)pDFObjStore.getExtensionData(VEncryptionMethod_K);
    }

    public static VBoolean getPasswordCorrectBoolean(PDFObjStore pDFObjStore) {
        SecurityHandler.initProvider();
        return (VBoolean)pDFObjStore.getExtensionData(VPasswordCorrectBoolean_K);
    }

    public static Object getPasswordHash(String string, byte[] byArray) {
        SecurityHandler securityHandler = (SecurityHandler)registry.get(string);
        if (securityHandler == null) {
            return null;
        }
        return securityHandler.getPasswordHash(byArray);
    }

    public abstract Object getPasswordHash(byte[] var1);

    private static synchronized void initProvider() {
        if (provider == null) {
            provider = new ExtensionDataProvider(){

                public Object provide(String string, Extensible extensible) {
                    Assert.notFalse(extensible instanceof PDFObjStore);
                    PDFObjStore pDFObjStore = (PDFObjStore)extensible;
                    if (string.equals(SecurityHandler.VEncryptDict_K)) {
                        return new VEncryptDict(pDFObjStore);
                    }
                    if (string.equals(SecurityHandler.VPasswordCorrectBoolean_K)) {
                        return new VPasswordCorrectBoolean(pDFObjStore);
                    }
                    if (string.equals(SecurityHandler.VEncryptionMethod_K)) {
                        return new VEncryptionMethod(pDFObjStore);
                    }
                    throw new ProviderNotFoundException(string);
                }
            };
            Extension.registerProvider(VEncryptDict_K, provider);
            Extension.registerProvider(VPasswordCorrectBoolean_K, provider);
            Extension.registerProvider(VEncryptionMethod_K, provider);
            StandardSecurityHandler standardSecurityHandler = new StandardSecurityHandler();
            SecurityHandler.registerSecurityHandler("Standard", standardSecurityHandler);
        }
    }

    public static synchronized void registerSecurityHandler(String string, SecurityHandler securityHandler) {
        registry.put(string, securityHandler);
    }
}

