/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.sidecar;

import com.adobe.acrobat.pdf.ColorValue;
import com.adobe.acrobat.pdf.image.Shading;
import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.BezierPath;
import com.adobe.acrobat.sidecar.ClipShape;
import com.adobe.acrobat.sidecar.ComplexPolygon;
import com.adobe.acrobat.sidecar.FloatPoint;
import com.adobe.acrobat.sidecar.FloatRect;
import com.adobe.acrobat.sidecar.FontADV;
import com.adobe.acrobat.sidecar.FontException;
import com.adobe.acrobat.sidecar.GraphicsUtils;
import com.adobe.acrobat.sidecar.ImageGraphics;
import com.adobe.acrobat.sidecar.MutableAffineTransform;
import com.adobe.acrobat.sidecar.PathStroker;
import com.adobe.acrobat.sidecar.PolygonADV;
import com.adobe.acrobat.sidecar.Region;
import com.adobe.acrobat.sidecar.SidecarImage;
import com.adobe.acrobat.sidecar.State;
import com.adobe.acrobat.sidecar.Stroke;
import com.adobe.acrobat.sidecar.StrokedPolygon;
import com.adobe.acrobat.sidecar.TextCache;
import com.adobe.acrobat.util.Log;
import com.adobe.util.MemUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.image.MemoryImageSource;

public class AWTGraphics {
    Graphics fGraphics;
    boolean allocatedOwnGraphics;
    private Image fImage;
    private Point fOrigin;
    private boolean printing = false;
    private Image fText;
    private int lastWidth;
    private int lastHeight;
    MemoryImageSource fTextProducer;
    private AWTGraphics fTextGraphics;
    private BezierPath fcBezPath;
    private ComplexPolygon fCPath;
    private int fCWinding;
    private int fCclipWinding;
    State cur_state;
    AffineTransform fInitialTransform;
    private TextCache fTextCache = null;
    public static final int doFill = 1;
    public static final int doStroke = 2;
    public static final int doClip = 4;
    static FloatPoint pos = new FloatPoint(0.0, 0.0);
    static char[] ch = new char[1];
    static final String spaceString = " ";
    char[] charBuf = new char[50];
    int passCount = 0;
    static final boolean dumpit = false;
    boolean inFlushText = false;

    public AWTGraphics() {
        this.init();
    }

    public AWTGraphics(int n, int n2) {
        this();
        this.fImage = GraphicsUtils.createImage(n, n2);
        this.fGraphics = this.fImage.getGraphics();
        this.allocatedOwnGraphics = true;
    }

    public AWTGraphics(AWTGraphics aWTGraphics) {
        this();
        this.fGraphics = aWTGraphics.fGraphics.create();
        this.allocatedOwnGraphics = true;
        this.fGraphics.translate(this.fOrigin.x, this.fOrigin.y);
    }

    public AWTGraphics(Graphics graphics) {
        this();
        this.fGraphics = graphics;
        if (graphics instanceof ImageGraphics) {
            this.fImage = ((ImageGraphics)graphics).image;
            this.fOrigin = ((ImageGraphics)graphics).getOrigin();
        }
        this.allocatedOwnGraphics = false;
    }

    public AWTGraphics(Image image) {
        this();
        this.fImage = image;
        this.fGraphics = image.getGraphics();
        this.allocatedOwnGraphics = true;
    }

    public void appendTransform(AffineTransform affineTransform) {
        this.cur_state.appendXform(affineTransform);
    }

    void cacheText(String string, FontADV fontADV, double[] dArray, FloatRect floatRect, int n) {
        FloatRect floatRect2;
        ColorValue colorValue;
        Stroke stroke;
        AffineTransform affineTransform = this.getCurrentTransform();
        if (this.fTextCache != null && (n & 4) != 0 != this.fTextCache.isClip()) {
            this.flushText();
        }
        if (this.fTextCache == null) {
            this.fTextCache = new TextCache(this.getFillColor().getRGBColor());
        }
        if ((n & 2) != 0) {
            stroke = this.getStroke();
            colorValue = this.getStrokeColor();
        } else {
            stroke = null;
            colorValue = this.getFillColor();
        }
        Rectangle rectangle = this.getClipBounds();
        if (rectangle != null && !(floatRect2 = new FloatRect(rectangle)).overlap(floatRect)) {
            return;
        }
        floatRect2 = this.fTextCache.getBBox();
        if (floatRect2 != null && (n & 4) == 0) {
            double d;
            double d2;
            double d3 = floatRect2.width();
            double d4 = floatRect2.height();
            double d5 = Math.min(floatRect2.getxMin(), floatRect.getxMin());
            double d6 = Math.min(floatRect2.getyMin(), floatRect.getyMin());
            double d7 = Math.max(floatRect2.getxMax(), floatRect.getxMax());
            double d8 = d7 - d5;
            if (d3 * d4 * 10.0 < d8 * (d2 = (d = Math.max(floatRect2.getyMax(), floatRect.getyMax())) - d6) || d8 * d2 > 62500.0) {
                this.flushText();
                this.fTextCache = new TextCache(this.getFillColor().getRGBColor());
            }
        }
        this.fTextCache.addText(string, dArray, affineTransform, colorValue.getRGBColor(), floatRect, fontADV, n, stroke);
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.flushText();
        this.cur_state.fClipShape.setClip(n, n2, n3, n4);
        this.fGraphics.clipRect(n, n2, n3, n4);
    }

    public void clipRect(FloatRect floatRect) {
        BezierPath bezierPath = new BezierPath(floatRect);
        bezierPath.setClipEvenOdd();
        this.setClip(bezierPath);
    }

    public void clipString(String string, FontADV fontADV, double[] dArray, FloatRect floatRect) throws Exception {
        this.drawFillOutlineString(string, fontADV, dArray, floatRect, 4);
    }

    public AWTGraphics create() {
        AWTGraphics aWTGraphics = new AWTGraphics(this);
        aWTGraphics.fImage = this.fImage;
        this.setFillColor(this.cur_state.fillColor);
        this.setStrokeColor(this.cur_state.strokeColor);
        return aWTGraphics;
    }

    public void dispose() {
        this.flushText();
        if (this.allocatedOwnGraphics && this.fGraphics != null) {
            this.fGraphics.dispose();
            this.fGraphics = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void drawFillOutlineString(String string, FontADV fontADV, double[] dArray, FloatRect floatRect, int n) throws Exception {
        if (!fontADV.alternateRender()) {
            this.cacheText(string, fontADV, dArray, floatRect, n);
            return;
        }
        AffineTransform affineTransform = fontADV.getFontMatrix();
        int n2 = 0;
        while (true) {
            block27: {
                String string2;
                int n3;
                double[] dArray2;
                block25: {
                    block23: {
                        block28: {
                            int n4;
                            block24: {
                                block26: {
                                    if (n2 >= string.length()) {
                                        return;
                                    }
                                    if (!fontADV.isDirectDrawGlyph(string.charAt(n2) & 0xFFFF)) break block26;
                                    this.flushText();
                                    MutableAffineTransform mutableAffineTransform = new MutableAffineTransform();
                                    try {
                                        this.cur_state.prePendXform(affineTransform);
                                        while (n2 < string.length() && fontADV.isDirectDrawGlyph(string.charAt(n2) & 0xFFFF)) {
                                            Object var12_15;
                                            try {
                                                int n5 = string.charAt(n2) & 0xFFFF;
                                                this.cur_state.prePendXform(mutableAffineTransform);
                                                if (n2 == 0) {
                                                    fontADV.renderAlternate(this, this.cur_state.fClipShape, string.charAt(n2) & 0xFFFF);
                                                } else {
                                                    fontADV.renderAlternate(this, this.cur_state.fClipShape, string.charAt(n2) & 0xFFFF);
                                                }
                                            }
                                            catch (Throwable throwable) {
                                                var12_15 = null;
                                                this.cur_state.removeFirstTransform();
                                                if (fontADV.getwMode() == 0) {
                                                    mutableAffineTransform.setx(dArray[n2]);
                                                } else {
                                                    mutableAffineTransform.sety(dArray[n2]);
                                                }
                                                ++n2;
                                                throw throwable;
                                            }
                                            var12_15 = null;
                                            this.cur_state.removeFirstTransform();
                                            if (fontADV.getwMode() == 0) {
                                                mutableAffineTransform.setx(dArray[n2]);
                                            } else {
                                                mutableAffineTransform.sety(dArray[n2]);
                                            }
                                            ++n2;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        dArray2 = null;
                                        this.cur_state.removeFirstTransform();
                                        throw throwable;
                                    }
                                    dArray2 = null;
                                    this.cur_state.removeFirstTransform();
                                    break block27;
                                }
                                n3 = 1;
                                while (true) {
                                    if (n2 + n3 >= string.length() || fontADV.isDirectDrawGlyph(string.charAt(n2 + n3))) {
                                        if (n3 >= string.length()) break block23;
                                        string2 = string.substring(n2, n2 + n3);
                                        dArray2 = MemUtil.allocDouble(n3);
                                        if (n2 == 0) {
                                            n4 = 0;
                                            break;
                                        }
                                        break block24;
                                    }
                                    ++n3;
                                }
                                while (n4 < n3) {
                                    dArray2[n4] = dArray[n4];
                                    ++n4;
                                }
                                break block28;
                            }
                            n4 = 0;
                            while (n4 < n3) {
                                dArray2[n4] = dArray[n2 + n4] - dArray[n2 - 1];
                                ++n4;
                            }
                        }
                        if (n2 > 0) {
                            if (fontADV.getwMode() == 0) {
                                this.translate(dArray[n2 - 1], 0.0);
                                break block25;
                            } else {
                                this.translate(0.0, dArray[n2 - 1]);
                            }
                        }
                        break block25;
                    }
                    string2 = string;
                    dArray2 = dArray;
                }
                this.cacheText(string2, fontADV, dArray2, floatRect, n);
                n2 += n3;
            }
            ++n2;
        }
    }

    public void drawImage(Image image) {
        this.drawImage(image, this.getCurrentTransform());
    }

    public void drawImage(Image image, AffineTransform affineTransform) {
        this.drawImage(image, affineTransform, this.fImage != null);
    }

    public void drawImage(Image image, AffineTransform affineTransform, ClipShape clipShape, boolean bl) {
        this.flushText();
        GraphicsUtils.drawImage(this, image, affineTransform, clipShape, bl);
    }

    public void drawImage(Image image, AffineTransform affineTransform, boolean bl) {
        if (affineTransform != null) {
            this.drawImage(image, affineTransform, this.cur_state.fClipShape, bl);
        } else {
            this.drawImage(image, null, null, bl);
        }
    }

    public void drawPath() {
        boolean bl = this.fImage != null;
        this.drawPath(bl);
    }

    public void drawPath(BezierPath bezierPath) {
        this.setPath(bezierPath);
        this.drawPath();
        this.setPath(null);
    }

    public void drawPath(BezierPath bezierPath, boolean bl) {
        this.setPath(bezierPath);
        this.drawPath(bl);
        this.setPath(null);
    }

    public void drawPath(boolean bl) {
        this.flushText();
        if (this.fCPath == null) {
            return;
        }
        this.setStrokeColor(this.cur_state.strokeColor);
        boolean bl2 = this.cur_state.strokeColor.paintIsComplex() || !this.cur_state.fClipShape.isRectangular();
        PathStroker pathStroker = new PathStroker(this.getStroke(), this.fCPath, this.fcBezPath, this.getCurrentTransform());
        FloatRect floatRect = this.cur_state.fClipShape.getFloatClipBounds();
        if (floatRect != null && !floatRect.overlap(pathStroker.getBoundingBox())) {
            return;
        }
        StrokedPolygon strokedPolygon = pathStroker.strokePath(bl, bl2);
        ComplexPolygon complexPolygon = strokedPolygon.fPolygons;
        ComplexPolygon complexPolygon2 = new ComplexPolygon();
        if (complexPolygon != null) {
            if (!strokedPolygon.fFill) {
                FloatRect floatRect2 = complexPolygon.getBoundingBox();
                FloatRect floatRect3 = floatRect.intersect(floatRect2);
                if (!floatRect3.isReallyEmpty() && floatRect3.equals(floatRect2)) {
                    GraphicsUtils.drawPolygons(this.fGraphics, complexPolygon);
                    return;
                }
                strokedPolygon = pathStroker.strokePath(bl, true);
                complexPolygon = strokedPolygon.fPolygons;
            }
            int n = 0;
            while (n < complexPolygon.size()) {
                complexPolygon2.addElement((PolygonADV)complexPolygon.elementAt(n));
                this.fillPath(complexPolygon2, 1, this.cur_state.strokeColor, bl);
                complexPolygon2.removeAllElements();
                ++n;
            }
        }
    }

    public void drawRect(FloatRect floatRect) {
        this.drawPath(new BezierPath(floatRect));
    }

    public void drawString(String string, FontADV fontADV, double[] dArray, FloatRect floatRect) throws Exception {
        this.drawFillOutlineString(string, fontADV, dArray, floatRect, 2);
    }

    public void fillPath() {
        boolean bl = this.fImage != null;
        this.fillPath(bl);
    }

    public void fillPath(BezierPath bezierPath) {
        this.setPath(bezierPath);
        this.fillPath();
        this.setPath(null);
    }

    public void fillPath(BezierPath bezierPath, boolean bl) {
        this.setPath(bezierPath);
        this.fillPath(bl);
        this.setPath(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fillPath(ComplexPolygon complexPolygon, int n, ColorValue colorValue, boolean bl) {
        ColorValue colorValue2;
        block12: {
            block11: {
                this.flushText();
                if (complexPolygon == null) {
                    return;
                }
                colorValue2 = this.getFillColor();
                try {
                    Object object;
                    this.setFillColor(colorValue);
                    boolean bl2 = colorValue.paintIsComplex();
                    if (!bl2 && complexPolygon.isRectangular()) {
                        n = 2;
                        if (this.cur_state.fClipShape.isRectangular()) {
                            FloatRect floatRect = complexPolygon.getBoundingBox();
                            if (!(floatRect = floatRect.intersect(this.cur_state.fClipShape.getFloatClipBounds())).isEmpty()) {
                                int n2 = (int)Math.floor(floatRect.getxMin());
                                int n3 = (int)Math.floor(floatRect.getyMin());
                                int n4 = (int)Math.ceil(floatRect.getxMax()) - n2;
                                int n5 = (int)Math.ceil(floatRect.getyMax()) - n3;
                                this.fGraphics.fillRect(n2, n3, n4, n5);
                            }
                            Object var7_15 = null;
                            this.setFillColor(colorValue2);
                            return;
                        }
                    }
                    if (!bl2 && !bl && n == 2 && complexPolygon.size() == 1 && this.cur_state.fClipShape.isRectangular() && (object = this.cur_state.fClipShape.getFloatClipBounds()) == null) {
                        break block11;
                    }
                    object = (ClipShape)this.cur_state.fClipShape.clone();
                    ((ClipShape)object).setClip(complexPolygon, n);
                    if (!bl2) {
                        ((ClipShape)object).fillClipPath(this, bl);
                        break block12;
                    }
                    try {
                        Rectangle rectangle = this.getClipBounds().intersection(((ClipShape)object).getClipBounds());
                        if (!rectangle.isEmpty()) {
                            SidecarImage sidecarImage = colorValue.patternImage(this.getInitialTransform(), rectangle);
                            this.drawImage(sidecarImage, null, (ClipShape)object, false);
                        }
                        break block12;
                    }
                    catch (Exception exception) {
                    }
                    break block12;
                }
                catch (Throwable throwable) {
                    Object var7_18 = null;
                    this.setFillColor(colorValue2);
                    throw throwable;
                }
            }
            Object var7_16 = null;
            this.setFillColor(colorValue2);
            return;
        }
        Object var7_17 = null;
        this.setFillColor(colorValue2);
    }

    public void fillPath(boolean bl) {
        this.fillPath(this.fCPath, this.fCWinding, this.cur_state.fillColor, bl);
    }

    public void fillRect(double d, double d2, double d3, double d4) {
        double[] dArray = new double[4];
        double[] dArray2 = new double[4];
        int[] nArray = new int[5];
        int[] nArray2 = new int[5];
        this.flushText();
        dArray[0] = d;
        dArray2[0] = d2;
        dArray[1] = d + d3;
        dArray2[1] = d2;
        dArray[2] = d + d3;
        dArray2[2] = d2 + d4;
        dArray[3] = d;
        dArray2[3] = d2 + d4;
        AffineTransform affineTransform = this.getCurrentTransform();
        affineTransform.transformPoints(dArray, dArray2, 4);
        int n = 0;
        while (n < 4) {
            nArray[n] = (int)Math.round(dArray[n]);
            nArray2[n] = (int)Math.round(dArray2[n]);
            ++n;
        }
        nArray[4] = nArray[0];
        nArray2[4] = nArray2[0];
        Polygon polygon = new Polygon(nArray, nArray2, 5);
        this.fGraphics.fillPolygon(polygon);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.fillRect((double)n, (double)n2, (double)n3, (double)n4);
    }

    public void fillShadedPath(Shading shading) throws Exception {
        this.flushText();
        ClipShape clipShape = this.cur_state.fClipShape;
        Rectangle rectangle = this.getClipBounds();
        SidecarImage sidecarImage = shading.shadingImage(this.getCurrentTransform(), rectangle);
        this.drawImage(sidecarImage, null, clipShape, false);
        this.setPath(null);
    }

    public void fillString(String string, FontADV fontADV, double[] dArray, FloatRect floatRect) throws Exception {
        this.drawFillOutlineString(string, fontADV, dArray, floatRect, 1);
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public void flush() {
        this.flushText();
    }

    public void flushText() {
        if (this.inFlushText) {
            return;
        }
        this.inFlushText = true;
        if (this.fTextCache != null) {
            try {
                try {
                    this.fTextCache.renderText(this);
                }
                catch (FontException fontException) {
                    Log.clog("FontException");
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    throw outOfMemoryError;
                }
                catch (InterruptedException interruptedException) {
                }
                Object var2_2 = null;
                this.inFlushText = false;
                this.fTextCache = null;
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.inFlushText = false;
                this.fTextCache = null;
                throw throwable;
            }
        }
        this.inFlushText = false;
    }

    public Rectangle getClipBounds() {
        Rectangle rectangle = null;
        Rectangle rectangle2 = this.cur_state.fClipShape.getClipBounds();
        if (this.fImage != null) {
            if (this.fImage instanceof SidecarImage) {
                Rectangle rectangle3 = ((SidecarImage)this.fImage).getRect();
                rectangle = new Rectangle(rectangle3.x - this.fOrigin.x, rectangle3.y - this.fOrigin.y, rectangle3.width, rectangle3.height);
            } else {
                rectangle = new Rectangle(-this.fOrigin.x, -this.fOrigin.y, this.fImage.getWidth(null), this.fImage.getHeight(null));
            }
        } else {
            rectangle = this.fGraphics.getClipBounds();
        }
        if (rectangle != null) {
            rectangle2 = rectangle2.intersection(rectangle);
        }
        return rectangle2;
    }

    public ClipShape getClipShape() {
        return this.cur_state.fClipShape;
    }

    public AffineTransform getCurrentTransform() {
        return this.cur_state.getCurrentTransform();
    }

    public ColorValue getFillColor() {
        return this.cur_state.fillColor;
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.fGraphics.getFontMetrics(font);
    }

    public Graphics getGraphics() {
        return this.fGraphics;
    }

    public Image getImage() {
        return this.fImage;
    }

    public AffineTransform getInitialTransform() {
        if (this.fInitialTransform == null) {
            this.fInitialTransform = AffineTransform.getIdentityMatrix();
        }
        return this.fInitialTransform;
    }

    public Point getOrigin() {
        return this.fOrigin;
    }

    public boolean getPrinting() {
        return this.printing;
    }

    public Stroke getStroke() {
        return this.cur_state.stroke;
    }

    public ColorValue getStrokeColor() {
        return this.cur_state.strokeColor;
    }

    public void greekText(double d, boolean bl) {
        this.flushText();
        Color color = this.fGraphics.getColor();
        if (color.getRed() < 64 && color.getGreen() < 64 && color.getBlue() < 64) {
            this.fGraphics.setColor(Color.gray);
        } else {
            color = null;
        }
        BezierPath bezierPath = new BezierPath(5);
        if (bl) {
            bezierPath.moveTo(0.0, 0.0);
            bezierPath.lineTo(0.0, -d);
            bezierPath.lineTo(0.1, -d);
            bezierPath.lineTo(0.1, 0.0);
        } else {
            bezierPath.moveTo(0.0, 0.0);
            bezierPath.lineTo(0.0, 0.6);
            bezierPath.lineTo(d, 0.6);
            bezierPath.lineTo(d, 0.0);
        }
        bezierPath.closePath();
        this.fillPath(bezierPath);
        this.fGraphics.setColor(color);
    }

    public boolean hitPath(FloatRect floatRect, BezierPath bezierPath, int n) {
        return false;
    }

    public void init() {
        this.fImage = null;
        this.fOrigin = new Point(0, 0);
        this.reset();
    }

    public boolean isOffscreen() {
        return this.fImage != null;
    }

    public boolean isPolygonVisible(PolygonADV polygonADV) {
        Rectangle rectangle = this.getClipBounds();
        Rectangle rectangle2 = polygonADV.getBoundingBox().toEnclosingRect();
        Rectangle rectangle3 = rectangle.intersection(rectangle2);
        return rectangle3.isEmpty() ^ true;
    }

    public void prePendXform(AffineTransform affineTransform) {
        this.cur_state.prePendXform(affineTransform);
    }

    public void purge() {
    }

    public void removeFirstTransform() {
        this.cur_state.removeFirstTransform();
    }

    public void removeLastTransform() {
        this.cur_state.removeLastTransform();
    }

    public void reset() {
        this.cur_state = new State();
        this.cur_state.fClipShape = new ClipShape(null);
        this.fInitialTransform = null;
        this.fcBezPath = null;
        this.fCPath = null;
        this.fTextCache = null;
        this.inFlushText = false;
    }

    public void restore() {
        this.flushText();
        this.cur_state = this.cur_state.restore();
        this.setFillColor(this.cur_state.fillColor);
        this.setStrokeColor(this.cur_state.strokeColor);
    }

    public void restoreAll() {
        this.flushText();
        this.cur_state = this.cur_state.restoreAll();
        this.setFillColor(this.cur_state.fillColor);
        this.setStrokeColor(this.cur_state.strokeColor);
    }

    public void save() {
        this.cur_state = this.cur_state.save();
    }

    public void setClip() {
        this.flushText();
        if (this.fCPath != null && this.fCclipWinding != 0) {
            this.cur_state.fClipShape.setClip(this.fCPath, this.fCclipWinding);
        }
    }

    public void setClip(BezierPath bezierPath) {
        this.flushText();
        this.setPath(bezierPath);
        this.setClip();
        this.setPath(null);
    }

    public void setClip(ClipShape clipShape) {
        this.flushText();
        this.cur_state.fClipShape.setClip(clipShape);
    }

    public void setClip(Region region) {
        this.flushText();
        this.cur_state.fClipShape.setClip(region);
    }

    public void setFillColor(ColorValue colorValue) {
        if (colorValue.paintIsComplex() || this.cur_state.fillColor.paintIsComplex()) {
            this.flushText();
        }
        this.cur_state.fillColor = colorValue;
        this.fGraphics.setColor(colorValue.getRGBColor());
    }

    public void setPath(BezierPath bezierPath) {
        this.fcBezPath = bezierPath;
        this.fCPath = null;
        if (bezierPath != null) {
            this.fCWinding = bezierPath.getWinding();
            this.fCclipWinding = bezierPath.getClipWinding();
            AffineTransform affineTransform = this.getCurrentTransform();
            BezierPath bezierPath2 = bezierPath.transform(affineTransform);
            this.fCPath = bezierPath2.flattenBezierPath();
        }
    }

    public void setPrinting(boolean bl) {
        this.printing = bl;
    }

    public void setStroke(Stroke stroke) {
        this.cur_state.stroke = stroke;
    }

    public void setStrokeColor(ColorValue colorValue) {
        this.cur_state.strokeColor = colorValue;
        this.fGraphics.setColor(colorValue.getRGBColor());
    }

    public void setTransform(AffineTransform affineTransform) {
        if (this.fInitialTransform == null) {
            this.fInitialTransform = affineTransform;
        }
        this.cur_state.setXform(affineTransform);
    }

    public void setXORMode(boolean bl) {
        this.cur_state.xor = bl;
        if (bl) {
            this.fGraphics.setColor(Color.black);
            this.fGraphics.setXORMode(Color.white);
        } else {
            this.fGraphics.setPaintMode();
            this.setStrokeColor(this.cur_state.strokeColor);
        }
    }

    public void transformPoint(FloatPoint floatPoint, FloatPoint floatPoint2) {
        AffineTransform affineTransform = this.getCurrentTransform();
        affineTransform.transformPoint(floatPoint, floatPoint2);
    }

    public void translate(double d, double d2) {
        this.setTransform(this.getCurrentTransform().translate(d, d2));
    }

    public void translate(int n, int n2) {
        this.fOrigin = new Point(n, n2);
        this.fGraphics.translate(n, n2);
    }
}

