/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.util;

import com.adobe.acrobat.gui.ErrorDialog;
import com.adobe.acrobat.gui.ReaderPrefs;
import com.adobe.acrobat.sidecar.AWTOutlines;
import com.adobe.acrobat.sidecar.FontException;
import com.adobe.acrobat.util.Log;
import com.adobe.acrobat.util.Session;
import com.adobe.acrobat.util.Util;
import com.adobe.util.MemUtil;
import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import netscape.security.PrivilegeManager;

public class FontCache
implements Serializable {
    private static final String SER = "FontCache.ser";
    private static final String ACROBAT_FONTS_DIR = "AcrobatFonts";
    private static final String FONT_FILE_SEEN = "_Invalid_Font_File_";
    private static FontCache theFontCache;
    private String localFilename;
    private String searchDirList;
    private String fontIgnoreFileExtensionList;
    private Vector searchDirs = new Vector();
    private Vector ignoreFileExtensions = new Vector();
    private Properties fonts = new Properties();
    private transient boolean isFilesystemCacheUptodate = false;
    private transient boolean isCacheLoaded = false;
    private transient CacheBuilder worker;
    private transient Vector listeners;
    private transient int badFont = 0;
    private static transient boolean setFontServerWarning;
    private transient Properties fontNotFoundOnServer = new Properties();
    private transient File fontFileBeingWritten;
    private transient boolean cache = true;
    private transient boolean acrobatFontsDirectoryExists = false;
    private transient Frame reporterFrame;
    private static final int STATUS_UPDATE = 0;
    private static final int UPDATE_ENDED = 1;

    static {
        setFontServerWarning = false;
    }

    protected FontCache() {
        this.listeners = new Vector();
        this.setPathsAndExtensions();
    }

    static /* synthetic */ boolean access$2(FontCache fontCache) {
        return fontCache.isFilesystemCacheUptodate;
    }

    public void addFontCacheListener(FontCacheListener fontCacheListener) {
        this.listeners.addElement(fontCacheListener);
    }

    public Vector areSearchDirsValid(String string) {
        Session session = Session.getTheSession();
        if (session.isIE()) {
            PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
        } else if (session.isNetscape()) {
            PrivilegeManager.enablePrivilege((String)"UniversalFileRead");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            try {
                boolean bl;
                File file = new File(string2);
                boolean bl2 = bl = file.exists() && file.canRead() && file.isDirectory();
                if (bl) continue;
                vector.addElement(string2);
            }
            catch (Exception exception) {
                vector.addElement(string2);
            }
        }
        return vector;
    }

    private void buildCache() {
        this.updateListeners(new FontCacheEvent(this, Util.getErrorString("Status:BuildFontCache")), 0);
        try {
            this.load();
        }
        catch (Exception exception) {
            this.createSnapShot();
        }
        this.updateListeners(new FontCacheEvent(this), 1);
    }

    public void buildCache(boolean bl) {
        if (this.worker != null && this.worker.isAlive()) {
            this.updateListeners(new FontCacheEvent(this), 1);
            this.worker.stop();
            this.clearCache();
        }
        this.worker = new CacheBuilder(bl);
        this.worker.start();
    }

    private void clearCache() {
        ((Hashtable)this.fonts).clear();
    }

    public void clearCachedAcrobatFonts() {
        block8: {
            Session session = Session.getTheSession();
            if (session.isIE()) {
                PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
            } else if (session.isNetscape()) {
                PrivilegeManager.enablePrivilege((String)"UniversalFileRead");
                PrivilegeManager.enablePrivilege((String)"UniversalFileDelete");
                PrivilegeManager.enablePrivilege((String)"UniversalPropertyRead");
            }
            try {
                String string = this.getAcrobatFontsLocation();
                File file = new File(string);
                if (!file.exists() || !file.canRead() || !file.isDirectory()) break block8;
                String[] stringArray = file.list();
                int n = 0;
                while (n < stringArray.length) {
                    try {
                        File file2 = new File(string, stringArray[n]);
                        file2.delete();
                    }
                    catch (Exception exception) {
                        new ErrorDialog(this.reporterFrame, exception);
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                new ErrorDialog(this.reporterFrame, exception);
            }
        }
    }

    private void createAcrobatFontsDirectory() {
        if (this.acrobatFontsDirectoryExists || !this.getCacheFiles()) {
            return;
        }
        Session session = Session.getTheSession();
        if (session.isIE()) {
            PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
        } else if (session.isNetscape()) {
            PrivilegeManager.enablePrivilege((String)"UniversalFileRead");
            PrivilegeManager.enablePrivilege((String)"UniversalFileWrite");
        }
        try {
            boolean bl;
            String string = this.getAcrobatFontsLocation();
            File file = new File(string);
            boolean bl2 = bl = file.exists() && file.canRead() && file.isDirectory();
            if (!bl) {
                file.mkdir();
            }
        }
        catch (Exception exception) {
            Log.clog("Unable to create the AcrobatFonts directory");
        }
        this.acrobatFontsDirectoryExists = true;
    }

    private void createCacheDirs(String string) {
        File file = new File(string);
        this.depthFirstSearch(file, ".");
    }

    private synchronized void createCacheFromFileSystem() {
        this.updateListeners(new FontCacheEvent(this, Util.getErrorString("Status:SearchingForFonts")), 0);
        if (this.searchDirs != null && this.searchDirs.size() > 0) {
            int n = 0;
            while (n < this.searchDirs.size()) {
                String string = (String)this.searchDirs.elementAt(n);
                String string2 = "Searching for new fonts in: " + string;
                this.updateListeners(new FontCacheEvent(this, string2), 0);
                this.createCacheDirs(string);
                ++n;
            }
        } else if (this.searchDirList.trim().equals("")) {
            this.clearCache();
        }
        this.isFilesystemCacheUptodate = true;
        this.updateListeners(new FontCacheEvent(this), 1);
    }

    private void createSnapShot() {
        this.createCacheFromFileSystem();
    }

    private String decodeName(String string) {
        int n;
        String string2 = Util.decodeURL(string);
        int n2 = string2.length();
        StringBuffer stringBuffer = MemUtil.allocStringBuffer(n2);
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n = string2.charAt(n4);
            if (n != 32) {
                ++n3;
                stringBuffer.append((char)n);
            }
            ++n4;
        }
        n = n3;
        while (n < n2) {
            stringBuffer.append(' ');
            ++n;
        }
        return stringBuffer.toString().trim();
    }

    private void depthFirstSearch(File file, String string) {
        File file2 = new File(file, string);
        String[] stringArray = file2.list();
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            File file3 = new File(file2, stringArray[n]);
            String string2 = file3.getName();
            if (file3.isDirectory()) {
                String string3 = "Searching for new fonts in: " + file3.getAbsolutePath();
                this.updateListeners(new FontCacheEvent(this, string3), 0);
                this.depthFirstSearch(file2, stringArray[n]);
            } else if (file3.isFile() && this.isValidFontFilename(string2.toLowerCase())) {
                this.reportFontFileFound(file3);
            }
            ++n;
        }
    }

    private String findCacheFilename() throws Exception {
        return String.valueOf(this.getAcrobatFontsLocation()) + File.separator + SER;
    }

    public InputStream findFont(String string) {
        InputStream inputStream = null;
        try {
            this.worker.join();
        }
        catch (InterruptedException interruptedException) {}
        try {
            inputStream = this.findLocalFont(string);
        }
        catch (Exception exception) {
            inputStream = this.findRemoteFont(string);
        }
        return inputStream;
    }

    private InputStream findLocalFont(String string) throws FontException, Exception {
        String string2;
        if (!this.getCacheFiles()) {
            return null;
        }
        if (!this.acrobatFontsDirectoryExists) {
            this.createAcrobatFontsDirectory();
        }
        if ((string2 = this.getFontFileByMatching(string)) == null) {
            return this.refreshFilesystemCacheAndTryAgain(string);
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(string2);
            return fileInputStream;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return this.refreshFilesystemCacheAndTryAgain(string);
        }
    }

    private InputStream findRemoteFont(String string) {
        if (this.isBase13Font(string)) {
            return null;
        }
        try {
            Session session = Session.getTheSession();
            if (session.isIE()) {
                PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
            } else if (session.isNetscape()) {
                PrivilegeManager.enablePrivilege((String)"UniversalFileRead");
            }
            String string2 = String.valueOf(this.getAcrobatFontsLocation()) + File.separator + string;
            File file = new File(string2);
            if (file.exists() && file.canRead()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                return bufferedInputStream;
            }
            String string3 = ReaderPrefs.getAcrobatFontsSource();
            if (string3 == null || string3.trim().length() == 0) {
                if (this.reporterFrame != null && !setFontServerWarning) {
                    setFontServerWarning = true;
                    new ErrorDialog(this.reporterFrame, Util.getErrorString("Warning:NoFontServer", string));
                } else {
                    Log.clog("Unable to find font (" + string + ") Font server has not been set.");
                }
            } else {
                String string4 = String.valueOf(string3) + "/" + string;
                URL uRL = new URL(string4);
                this.loadAcrobatFontFile(uRL, string);
                string2 = String.valueOf(this.getAcrobatFontsLocation()) + File.separator + string;
                file = new File(string2);
                if (file.exists() && file.canRead()) {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                    return bufferedInputStream;
                }
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    public String getAcrobatFontsLocation() throws IOException {
        Session session = Session.getTheSession();
        if (session.isIE()) {
            PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
        } else if (session.isNetscape()) {
            PrivilegeManager.enablePrivilege((String)"UniversalPropertyRead");
        }
        return String.valueOf(System.getProperty("user.home")) + File.separator + ACROBAT_FONTS_DIR;
    }

    public boolean getCacheFiles() {
        return this.cache;
    }

    public String[] getCachedAcrobatFonts() {
        Session session = Session.getTheSession();
        if (session.isIE()) {
            PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
        } else if (session.isNetscape()) {
            PrivilegeManager.enablePrivilege((String)"UniversalFileRead");
            PrivilegeManager.enablePrivilege((String)"UniversalPropertyRead");
        }
        try {
            String string = this.getAcrobatFontsLocation();
            File file = new File(string);
            if (file.exists() && file.canRead() && file.isDirectory()) {
                return file.list();
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getFontFileByMatching(String string) {
        String string2;
        String string3 = this.fonts.getProperty(string, null);
        if (string3 == null && !(string2 = this.decodeName(string)).equals(string)) {
            string3 = this.fonts.getProperty(string2, null);
        }
        return string3;
    }

    public String getFontIgnoreFileExtensionList() {
        return this.fontIgnoreFileExtensionList;
    }

    private String getFontName(RandomAccessFile randomAccessFile) throws Exception {
        AWTOutlines aWTOutlines = new AWTOutlines(randomAccessFile, (int)randomAccessFile.length(), true);
        String string = aWTOutlines.getFontName();
        return string;
    }

    private String getIndexedName(String string, int n) {
        return String.valueOf(string) + "[" + n + "]";
    }

    public Properties getLocalFonts() {
        return this.fonts;
    }

    public String getSearchDirs() {
        return this.searchDirList;
    }

    public static FontCache getTheFontCache() {
        if (theFontCache == null) {
            theFontCache = new FontCache();
        }
        return theFontCache;
    }

    private String getUnindexedName(String string) {
        int n = string.lastIndexOf(91);
        if (n == -1 || !string.endsWith("]")) {
            return string;
        }
        String string2 = string.substring(n + 1, string.length() - 1);
        try {
            Integer.parseInt(string2, 10);
            return string.substring(0, n);
        }
        catch (NumberFormatException numberFormatException) {
            return string;
        }
    }

    private String getValidSearchDirs(String string) {
        Session session = Session.getTheSession();
        if (session.isIE()) {
            PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
        } else if (session.isNetscape()) {
            PrivilegeManager.enablePrivilege((String)"UniversalFileRead");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
        Vector vector = new Vector();
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            try {
                boolean bl;
                File file = new File(string3);
                boolean bl2 = bl = file.exists() && file.canRead() && file.isDirectory();
                if (!bl) continue;
                string2 = String.valueOf(string2) + ";" + string3;
            }
            catch (Exception exception) {}
        }
        return string2.startsWith(";") ? string2.substring(1) : "";
    }

    public boolean isAcrobatFontAvailable(String string) throws IOException {
        Session session = Session.getTheSession();
        if (session.isIE()) {
            PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
        } else if (session.isNetscape()) {
            PrivilegeManager.enablePrivilege((String)"UniversalFileRead");
            PrivilegeManager.enablePrivilege((String)"UniversalPropertyRead");
        }
        String string2 = String.valueOf(this.getAcrobatFontsLocation()) + File.separator + string;
        File file = new File(string2);
        return file.exists() && file.canRead();
    }

    private boolean isBase13Font(String string) {
        String string2 = string.toLowerCase();
        return string2.startsWith("times") || string2.startsWith("arial") || string2.startsWith("helvetica") || string2.startsWith("courier");
    }

    private boolean isFileNew(String string) {
        return ((Hashtable)this.fonts).contains(string) ^ true;
    }

    private boolean isValidFontFilename(String string) {
        String string2 = string.toLowerCase();
        int n = 0;
        while (n < this.ignoreFileExtensions.size()) {
            if (string2.endsWith((String)this.ignoreFileExtensions.elementAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void load() throws Exception {
        this.localFilename = this.findCacheFilename();
        Log.clog("FontCache.load - " + this.localFilename);
        FileInputStream fileInputStream = new FileInputStream(this.localFilename);
        Log.clog("FontCache.load - " + fileInputStream);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(fileInputStream);
        ObjectInputStream objectInputStream = new ObjectInputStream(gZIPInputStream);
        Object object = objectInputStream.readObject();
        theFontCache = (FontCache)object;
        this.searchDirs = FontCache.theFontCache.searchDirs;
        this.ignoreFileExtensions = FontCache.theFontCache.ignoreFileExtensions;
        this.fonts = FontCache.theFontCache.fonts;
        this.searchDirList = FontCache.theFontCache.searchDirList;
        this.fontIgnoreFileExtensionList = FontCache.theFontCache.fontIgnoreFileExtensionList;
        FontCache.theFontCache.listeners = this.listeners;
        FontCache.theFontCache.worker = this.worker;
        FontCache.theFontCache.fontNotFoundOnServer = this.fontNotFoundOnServer;
        FontCache.theFontCache.cache = true;
        objectInputStream.close();
        this.isCacheLoaded = true;
    }

    private synchronized void loadAcrobatFontFile(URL uRL, String string) throws Exception {
        File file;
        if (this.fontNotFoundOnServer.getProperty(string) != null) {
            throw new FontException("Error:NoFont", string);
        }
        this.updateListeners(new FontCacheEvent(this, Util.getErrorString("Status:LoadingFont", string, uRL.toExternalForm())), 0);
        Session session = Session.getTheSession();
        if (session.isIE()) {
            PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
        } else if (session.isNetscape()) {
            PrivilegeManager.enablePrivilege((String)"UniversalFileRead");
            PrivilegeManager.enablePrivilege((String)"UniversalPropertyRead");
            PrivilegeManager.enablePrivilege((String)"UniversalFileWrite");
        }
        String string2 = String.valueOf(this.getAcrobatFontsLocation()) + File.separator + string;
        this.fontFileBeingWritten = file = new File(string2);
        long l = System.currentTimeMillis();
        try {
            block10: {
                try {
                    InputStream inputStream = uRL.openStream();
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    byte[] byArray = MemUtil.allocByte(2048);
                    while (true) {
                        int n;
                        if ((n = inputStream.read(byArray)) > 0) {
                            fileOutputStream.write(byArray, 0, n);
                            continue;
                        }
                        if (n < 0) break;
                    }
                    fileOutputStream.close();
                    inputStream.close();
                    Log.clog("Read font " + string + " @ " + uRL + " cached in " + string2 + " in " + (System.currentTimeMillis() - l));
                }
                catch (Exception exception) {
                    boolean bl;
                    Log.clog("Exception reading font " + string + " in " + (System.currentTimeMillis() - l) + " - " + exception);
                    ((Hashtable)this.fontNotFoundOnServer).put(string, uRL.toExternalForm());
                    if (!file.exists() || (bl = file.delete())) break block10;
                    Log.clog("unable to delete " + file.getName());
                }
            }
            Object var9_13 = null;
            this.updateListeners(new FontCacheEvent(this), 1);
            this.fontFileBeingWritten = null;
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            this.updateListeners(new FontCacheEvent(this), 1);
            this.fontFileBeingWritten = null;
            throw throwable;
        }
    }

    private String matchFontName(String string) {
        Enumeration enumeration = ((Hashtable)this.fonts).keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = this.decodeName(string);
            String string4 = this.decodeName(string2);
            if (!string3.toLowerCase().startsWith(string4.toLowerCase())) continue;
            return string2;
        }
        return null;
    }

    private void rebuildCache() {
        this.updateListeners(new FontCacheEvent(this, Util.getErrorString("Status:RebuildFontCache")), 0);
        this.createSnapShot();
        this.updateListeners(new FontCacheEvent(this), 1);
    }

    private InputStream refreshFilesystemCacheAndTryAgain(String string) throws FontException, Exception {
        if (this.isFilesystemCacheUptodate) {
            throw new FontException("Error:NoFont", string);
        }
        this.createCacheFromFileSystem();
        return this.findLocalFont(string);
    }

    public void removeFontCacheListener(FontCacheListener fontCacheListener) {
        this.listeners.removeElement(fontCacheListener);
    }

    private void reportFontFileFound(File file) {
        String string = "";
        try {
            String string2 = null;
            try {
                string2 = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                string2 = file.getAbsolutePath();
            }
            string = string2.replace(File.separatorChar, '/');
            if (this.isFileNew(string)) {
                RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
                String string3 = this.getFontName(randomAccessFile);
                if (string3 != null) {
                    this.storeFont(string3, string, -1);
                } else {
                    this.storeFont(FONT_FILE_SEEN, string, this.badFont++);
                }
                randomAccessFile.close();
            }
        }
        catch (Exception exception) {
            Log.clog("FontCache.reportFontFileFound exception in " + file.getAbsolutePath());
            this.storeFont(FONT_FILE_SEEN, string, this.badFont++);
        }
    }

    public synchronized void save() throws Exception {
        Object object;
        if (this.worker != null) {
            this.worker.join();
        }
        if (this.listeners != null) {
            this.listeners.removeAllElements();
        }
        Log.clog("FontCache.save - " + this.localFilename);
        if (this.fontFileBeingWritten != null) {
            object = Session.getTheSession();
            if (((Session)object).isIE()) {
                PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
            } else if (((Session)object).isNetscape()) {
                PrivilegeManager.enablePrivilege((String)"UniversalFileRead");
                PrivilegeManager.enablePrivilege((String)"UniversalPropertyRead");
                PrivilegeManager.enablePrivilege((String)"UniversalFileDelete");
            }
            try {
                if (this.fontFileBeingWritten.exists() && !this.fontFileBeingWritten.delete()) {
                    new ErrorDialog(this.reporterFrame, "Unable to delete a corrupt cached font file " + this.fontFileBeingWritten.getAbsolutePath() + ". Please delete this file.");
                }
            }
            catch (Exception exception) {
                new ErrorDialog(this.reporterFrame, "Unable to delete a corrupt cached font file due to an exception. Please delete the file: " + this.fontFileBeingWritten.getAbsolutePath());
            }
        }
        if (this.localFilename != null) {
            object = new FileOutputStream(this.localFilename);
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream((OutputStream)object);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
            objectOutputStream.writeObject(theFontCache);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
    }

    public void setCacheFiles(boolean bl) {
        this.cache = bl;
    }

    public void setFontIgnoreFileExtensions(String string) {
        this.fontIgnoreFileExtensionList = string;
        this.ignoreFileExtensions.removeAllElements();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
        while (stringTokenizer.hasMoreTokens()) {
            this.ignoreFileExtensions.addElement(stringTokenizer.nextToken());
        }
    }

    private void setPathsAndExtensions() {
        String string = "C:\\Windows\\Fonts;C:\\Winnt\\Fonts;C:\\Win98\\Fonts;C:\\Win95\\Fonts;C:\\Winnt40\\Fonts;C:\\PSFONTS";
        String string2 = "/JavaOS/FONTS";
        String string3 = "/usr/openwin/lib/X11/fonts;/usr/lib/X11/fonts";
        String string4 = "/Preferences";
        String string5 = ".fon;.pfm;.ini;.lst;.txt;.doc;.ttmap;.z;.enc;.dir;.afm;.f3b;.pfa;.spd;.ps;.bepf;.map;.alias;.scale;.all;.upr";
        try {
            Session session = Session.getTheSession();
            if (session.isIE()) {
                PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
            } else if (session.isNetscape()) {
                PrivilegeManager.enablePrivilege((String)"UniversalPropertyRead");
                PrivilegeManager.enablePrivilege((String)"UniversalFileRead");
            }
            Properties properties = System.getProperties();
            String string6 = properties.getProperty("os.name");
            String string7 = properties.getProperty("user.home");
            if (string7.endsWith(string4)) {
                string4 = String.valueOf(string7.substring(0, string7.lastIndexOf(string4))) + "/Fonts";
                System.out.println(string4);
            } else {
                string4 = "";
            }
            ReaderPrefs.initialize();
            String string8 = ReaderPrefs.getProperty("com.adobe.acrobat.util.fontDirectories", null);
            String string9 = ReaderPrefs.getProperty("com.adobe.acrobat.util.fontIgnoreExtensions", null);
            this.setFontIgnoreFileExtensions(string9 == null ? string5 : string9);
            String string10 = string8 == null ? String.valueOf(string3) + ";" + string + ";" + string4 + ";" + string2 : string8;
            string10 = this.getValidSearchDirs(string10);
            this.setSearchDirs(string10);
        }
        catch (Exception exception) {
            this.setSearchDirs("");
            this.setFontIgnoreFileExtensions("");
        }
    }

    public void setReporterFrame(Frame frame) {
        this.reporterFrame = frame;
    }

    public void setSearchDirs(String string) {
        this.searchDirList = string;
        this.searchDirs.removeAllElements();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
        while (stringTokenizer.hasMoreTokens()) {
            this.searchDirs.addElement(stringTokenizer.nextToken());
        }
    }

    private void storeFont(String string, String string2, int n) {
        String string3 = n == -1 ? string : this.getIndexedName(string, n);
        String string4 = this.fonts.getProperty(string3, null);
        if (string4 == null) {
            this.updateListeners(new FontCacheEvent(this, Util.getErrorString("Status:FoundFont", string3, string2)), 0);
            ((Hashtable)this.fonts).put(string3, string2);
        } else if (!string4.equals(string2)) {
            this.storeFont(string, string2, ++n);
        }
    }

    private void updateListeners(FontCacheEvent fontCacheEvent, int n) {
        int n2 = 0;
        while (n2 < this.listeners.size()) {
            FontCacheListener fontCacheListener = (FontCacheListener)this.listeners.elementAt(n2);
            switch (n) {
                case 0: {
                    fontCacheListener.statusUpdate(fontCacheEvent);
                    break;
                }
                case 1: {
                    fontCacheListener.updateEnded(fontCacheEvent);
                    break;
                }
            }
            ++n2;
        }
    }

    public class FontCacheEvent
    extends EventObject {
        private String text;

        public FontCacheEvent(FontCache fontCache2) {
            super(fontCache2);
        }

        public FontCacheEvent(FontCache fontCache2, String string) {
            super(fontCache2);
            this.text = string;
        }

        public String getText() {
            return this.text;
        }
    }

    public static interface FontCacheListener
    extends EventListener {
        public void statusUpdate(FontCacheEvent var1);

        public void updateEnded(FontCacheEvent var1);
    }

    public class CacheBuilder
    extends Thread {
        private boolean rebuild;

        public CacheBuilder(boolean bl) {
            super("Font Cache Builder");
            this.rebuild = bl;
            this.setPriority(1);
        }

        public void run() {
            if (FontCache.this.getCacheFiles()) {
                if (this.rebuild) {
                    FontCache.this.rebuildCache();
                } else {
                    FontCache.this.buildCache();
                }
            } else {
                FontCache.this.isFilesystemCacheUptodate = true;
            }
        }
    }
}

