/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pe.awt;

import com.adobe.pe.awt.StrobeContainer;
import com.adobe.pe.awt.StrobeUtils;
import com.adobe.pe.awt.VMenuBarObserver;
import com.adobe.pe.awt.VWindowTitleObserver;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.Transactor;
import com.adobe.pe.notify.VSynchronizer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;

public class PEFrame
extends Frame
implements WindowListener {
    private StrobeContainer menubar;
    private StrobeContainer windowTitle;
    private boolean disposeOnClose;
    private Vector strobeContainers = new Vector();
    private boolean done = false;
    private boolean domenus = true;
    static final int kCreating = 0;
    static final int kOpening = 1;
    static final int kClosing = 2;
    private VSynchronizer openCloseSynchronizer = new VSynchronizer();

    public PEFrame(String string, boolean bl) {
        super(string);
        ((Component)this).setCursor(Cursor.getDefaultCursor());
        this.commoninit(bl);
    }

    public PEFrame(boolean bl) {
        this.commoninit(bl);
    }

    private void commoninit(boolean bl) {
        this.disposeOnClose = bl;
        this.addWindowListener(this);
    }

    private void computeMenus() {
        this.openCloseSynchronizer.setTransactor(null, new PEFrameTransactor(0));
        Dimension dimension = this.getSize();
        this.pack();
        ((Component)this).setSize(dimension.width, dimension.height);
    }

    public void registerStrobeContainer(StrobeContainer strobeContainer) {
        this.strobeContainers.addElement(strobeContainer);
    }

    public void registerStrobes(VWindowTitleObserver vWindowTitleObserver, VMenuBarObserver vMenuBarObserver) {
        this.menubar = vMenuBarObserver;
        this.windowTitle = vWindowTitleObserver;
        this.registerStrobeContainer(vMenuBarObserver);
        this.registerStrobeContainer(vWindowTitleObserver);
    }

    public void show() {
        if (this.domenus) {
            this.computeMenus();
            this.domenus = false;
        }
        super.show();
    }

    public void update(Graphics graphics) {
        ((Container)this).paint(graphics);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.openCloseSynchronizer.setTransactor(null, new PEFrameTransactor(2));
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
        if (this.done) {
            return;
        }
        this.openCloseSynchronizer.setTransactor(null, new PEFrameTransactor(1));
        this.done = true;
    }

    class PEFrameTransactor
    extends Transactor {
        private int selector;

        public PEFrameTransactor(int n) {
            this.selector = n;
        }

        protected final void buildChanges(Transaction transaction) throws Exception {
            switch (this.selector) {
                case 0: {
                    if (PEFrame.this.menubar == null) break;
                    PEFrame.this.menubar.setStrobeActive(transaction, true);
                    break;
                }
                case 1: {
                    int n = 0;
                    while (n < PEFrame.this.strobeContainers.size()) {
                        StrobeContainer strobeContainer = (StrobeContainer)PEFrame.this.strobeContainers.elementAt(n);
                        strobeContainer.setStrobeActive(transaction, true);
                        ++n;
                    }
                    transaction.notifyStrobes();
                    PEFrame.this.validate();
                    StrobeUtils.setAllStrobesActive(transaction, PEFrame.this, true);
                    break;
                }
                case 2: {
                    int n = 0;
                    while (n < PEFrame.this.strobeContainers.size()) {
                        StrobeContainer strobeContainer = (StrobeContainer)PEFrame.this.strobeContainers.elementAt(n);
                        strobeContainer.setStrobeActive(transaction, false);
                        ++n;
                    }
                    StrobeUtils.setAllStrobesActive(transaction, PEFrame.this, false);
                    if (!PEFrame.this.disposeOnClose) break;
                    PEFrame.this.dispose();
                    break;
                }
            }
        }
    }
}

