/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.util;

import com.adobe.util.Assert;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.util.Vector;

public class ImageUtil {
    private static Vector rootComponentList = new Vector();
    private static Canvas lastCanvas = null;

    public static Image createImage(int n, int n2) {
        n = Math.max(n, 1);
        n2 = Math.max(n2, 1);
        Image image = null;
        if (lastCanvas != null) {
            image = lastCanvas.createImage(n, n2);
        }
        if (image == null) {
            int n3 = 0;
            while (image == null && n3 < rootComponentList.size()) {
                Component component = (Component)rootComponentList.elementAt(n3);
                image = ImageUtil.digForImage(component, n, n2);
                ++n3;
            }
        }
        if (image != null) {
            Graphics graphics = image.getGraphics();
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, n, n2);
            graphics.dispose();
        }
        Assert.notFalse(image != null);
        return image;
    }

    public static Image createImage(ImageProducer imageProducer) {
        return Toolkit.getDefaultToolkit().createImage(imageProducer);
    }

    private static Image digForImage(Component component, int n, int n2) {
        if (component instanceof Canvas) {
            Image image = component.createImage(n, n2);
            if (image != null) {
                lastCanvas = (Canvas)component;
            }
            return image;
        }
        if (component instanceof Frame) {
            Image image = component.createImage(n, n2);
            return image;
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            int n3 = 0;
            while (n3 < container.getComponentCount()) {
                Component component2 = container.getComponent(n3);
                Image image = ImageUtil.digForImage(component2, n, n2);
                if (image != null) {
                    return image;
                }
                ++n3;
            }
        }
        return null;
    }

    public static Component getRegisteredComponent() {
        if (rootComponentList.size() > 0) {
            return (Component)rootComponentList.elementAt(0);
        }
        return null;
    }

    public static void registerRootComponent(Component component) {
        Assert.notFalse(component != null);
        rootComponentList.addElement(component);
    }

    public static void unregisterRootComponent(Component component) {
        rootComponentList.removeElement(component);
    }
}

