#!/usr/bin/env python
#
# $Id: hdformatter_null.py,v 1.1 2001/02/18 14:38:06 doughellmann Exp $
#
# Time-stamp: <01/02/17 15:27:13 dhellmann>
#
# Copyright 2001 Doug Hellmann.
#
#
#                         All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and
# its documentation for any purpose and without fee is hereby
# granted, provided that the above copyright notice appear in all
# copies and that both that copyright notice and this permission
# notice appear in supporting documentation, and that the name of Doug
# Hellmann not be used in advertising or publicity pertaining to
# distribution of the software without specific, written prior
# permission.
#
# DOUG HELLMANN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
# INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
# NO EVENT SHALL DOUG HELLMANN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
# CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
# OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
# CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#

"""Null output formatter used for profiling.

"""

__rcs_info__ = {
    #
    #  Creation Information
    #
    'module_name'  : '$RCSfile: hdformatter_null.py,v $',
    'rcs_id'       : '$Id: hdformatter_null.py,v 1.1 2001/02/18 14:38:06 doughellmann Exp $',
    'creator'      : 'Doug Hellmann <DougHellmann@bigfoot.com>',
    'project'      : 'UNSPECIFIED',
    'created'      : 'Sat, 17-Feb-2001 12:15:35 EST',

    #
    #  Current Information
    #
    'author'       : '$Author: doughellmann $',
    'version'      : '$Revision: 1.1 $',
    'date'         : '$Date: 2001/02/18 14:38:06 $',
}

#
# Import system modules
#


#
# Import Local modules
#
import hdformatter_htmlfile

#
# Module
#


def entryPoint():
    "Return information about this module to the dynamic loader."
    return {
        'name':'null',
        'factory':NullFormatter,
        }

class NullFile:

    def __init__(self, name):
        self.name = name
        return

    def write(self, *ignored, **ignoredToo):
        return

    def close(self, *ignored, **ignoredToo):
        return
    

class NullFormatter(hdformatter_htmlfile.HTMLTableFormatter):

    def openOutput(self, name, title1, title2=None):
        self.open_root_file = NullFile(name)
        return self.open_root_file

