#!/usr/local/bin/ruby

require 'property'

def test1
  # load default properties
  puts("[load default properties]")
  default = Properties.new
  default.load("test.default")
  # create user properties
  puts("[create user properties]")
  prop = Properties.new(default)
  prop.addComment(<<"HEADER_END")
; This configuration file was generated by #{$0} program.
; You must change this file after program termination.
HEADER_END
  # access properties
  puts("[access properties]")
  print("dict_file = "); p(prop.dict_file)
  print("fg_color = "); p(prop.fg_color)  # used default properties
  # set values to some properties
  puts("[modify properties]")
  prop.dict_file = "~/lib/chasen/chadic"
  prop.morpheme_cost = 100
  # save user properties
  puts("[save user properties]")
  prop.save("dot.testrc")
end

def test2
  # load default properties
  puts("[load default properties]")
  default = Properties.new
  default.load('test.default')
  puts("[dump default properties]")
  default.list
  default.each do |key, value| print("  "); p([key, value]) end
  # load user properties
  puts("[load user properties]")
  prop = Properties.new(default)
  prop.load('dot.testrc')
  puts("[dump user properties]")
  prop.list
  prop.each do |key, value| print("  "); p([key, value]) end
  # access properties
  puts("[access properties]")
  print("dict_file = "); p(prop.dict_file)
  print("fg_color = "); p(prop.fg_color)  # used default properties
end

test1
test2
