eval 'exec perl -x $0 ${1+"$@"}' # -*-perl-*-
  if 0;
#!perl -w
#
# ======================================================================
# This file is Copyright 1998,1999 by the Purdue Research Foundation and
# may only be used under license.  For terms of the license, see the
# file named COPYRIGHT included with this software release.
# AAFID is a trademark of the Purdue Research Foundation.
# All rights reserved.
# ======================================================================
#
# AAFID2 system
# Agent name:        CheckInetPeriodic
# Agent description: Report number of connections to services
# Author:            Diego Zamboni
#
# History of modifications:
# 
# Known bugs:
# 
# Things to do:
# - Add the capability of monitoring multiple services.
# 
# Future work:
# 
# Suggestions made by people:
# 
# Generated automatically by ../bin/makeagent.pl on Tue Sep  7 23:55:44 1999.
# 
###### AUTOMATICALLY GENERATED FILE --- DO NOT EDIT ##########
#

# 10 "CheckInetPeriodic.aas"
package CheckInetPeriodic;

# Version number
# 13 "CheckInetPeriodic.aas"
$VERSION=eval {do { my @r = (q$Revision: 1.6 $ =~ /\d+/g); sprintf "%d."."%02d" x $#r, @r }}; $VERSION=$VERSION;

# Agent parameters
%PARAMETERS=(
             Description        => "Report number of connections to services",
             CheckPeriod        => eval {10},
# 27 "CheckInetPeriodic.aas"
             SumPeriod => 300,
# 30 "CheckInetPeriodic.aas"
             FiltersNeeded => {   Ftcpw => [{ }] }
            );

# Package loading
use AAFID::Agent;
use AAFID::Log;
use AAFID::Common;
# 20 "CheckInetPeriodic.aas"
use Util::NumQueue;

use vars qw (
             @ISA
             $VERSION
             %PARAMETERS
            );

# Define the superclass.
 @ISA=qw(AAFID::Agent);

=head1 CheckInetPeriodic


Count and report the number of connections to a service that have occured
during the last 'SumPeriod' seconds.

=cut

# Preamble code


# The Check function.
sub Check {
  my $self=checkref(shift);
# 33 "CheckInetPeriodic.aas"
  my $svc=$Params{MyService};

  my ($month,$day,$hour,$min,$sec,$host,$prog,$t1,$t2,$wherefrom);

  if ($svc) {
    my $count=$Params{'MyCount_'.$svc} || 0;
    my $queue=$self->getParameter('SumQueue_'.$svc, Util::NumQueue->new);
    $queue->timelength($Params{SumPeriod});

    while ($_=$self->readFilter('Ftcpw')) {
      $self->Log("debug", "Line read: $_");
      chop;
      ($month,$day,$hour,$min,$sec,$host,$prog,$t1,$t2,$wherefrom)=
	split(/[\s:]+/);
      if ($wherefrom =~ /@/) {
	$wherefrom=(split(/@/, $wherefrom))[1];
      }
      # We don't need this check with the filters in place.
      $count++;
      $queue->add(1);
      $Params{'MyCount_'.$svc}=$count;
    }
    my $sum=$queue->sum;
    my $status=$sum;
    $status=10 if $status>10;
    $self->Log("debug", "Returning ($status, Requests to $svc: $count)\n");
    return ($status, "$sum (Total requests to $svc: $count)");
  }
  return (0, "No service to monitor has been specified");
}
# Agent commands

sub command_SETSERVICE {
  my $self=checkref(shift);
  my ($message, %p)=@_;
  if (exists($p{Service}) && 1) {
    my $Service = $p{Service};
# 64 "CheckInetPeriodic.aas"
# Syntax: SETSERVICE Service => 'svc'
    $self->Log("debug", "Setting service to monitor: $Service\n");
    $self->setFilterPattern('Ftcpw', { Daemon => $Service });
    $Params{MyService}=$Service;
    # By default, return undef
    return undef;
  }
}

# End of entity marker
_EndOfEntity;
