eval 'exec perl -x $0 ${1+"$@"}' # -*-perl-*-
  if 0;
#!perl -w
#
# ======================================================================
# This file is Copyright 1998,1999 by the Purdue Research Foundation and
# may only be used under license.  For terms of the license, see the
# file named COPYRIGHT included with this software release.
# AAFID is a trademark of the Purdue Research Foundation.
# All rights reserved.
# ======================================================================
#
# AAFID project, COAST Laboratory, CERIAS, 1998-1999.
#
# Diego Zamboni, March 30, 1999.
#
# $Id: CPUload.pm,v 1.6 1999/09/08 04:45:14 zamboni Exp $
#
# NOTE: This file is in Perl's POD format. For more information, see the 
#       manual page for perlpod(1).
#

package Filter::CPUload;

use strict;
use AAFID::Filter;
use AAFID::Entity;
use AAFID::Common;
use vars qw(
	%PARAMETERS
	@ISA
	$ps
	    );

  sub makefield;
  sub makeline;

  %PARAMETERS=(
		Period  => 30
	      );

@ISA=qw(AAFID::Filter);

# The following variables are specific of the logfile and name of
# the socket that is wanted.

=pod

This filter executes the "uptime" command periodically and reports the
three system loads. The three loads are referred to by fields called
"ShortTerm", "MediumTerm" and "LongTerm".

=cut

sub Init_log {
  my $self=checkref(shift);
  my $uptime=IO::File->new("uptime |") or return undef;;
  Comm::Reactor::add_acceptor($uptime, 
	      sub {
		my ($fh)=shift;
		my $msg=<$fh>;
		if (!defined($msg)) {
		  Comm::Reactor::remove_handle($fh);
		  $fh->close;
		  # Reawake in a little bit.
		  Comm::Reactor::add_event(time()+$self->getParameter('Period'),
					   sub {$self->Init_log});
		}
		else {
		  chomp $msg;
		  # Only process appropriate lines.
		  if ($msg =~ /load average/) {
		    $self->processLine($fh, $msg);
		  }
		}
	      });
  return $self;
}

=head1 Processing lines

This is really simple. Just extract the three loads.
=cut

	
sub makefield {
  my $self=checkref(shift);
  my $line=shift;
  
  if ($line =~ /load average:\s*([\d.]+),\s*([\d.]+),\s*([\d.]+)/) {
    return { ShortTerm => $1,
	     MediumTerm => $2,
	     LongTerm => $3
	   };
  }
  else {
    return undef;
  }
}

sub makeline{
  my $self=checkref(shift);
  my $line=shift;
  my %line=%$line;
  return "$line{ShortTerm} $line{MediumTerm} $line{LongTerm}";
}

_EndOfEntity;

#
# $Log: CPUload.pm,v $
# Revision 1.6  1999/09/08 04:45:14  zamboni
# Made Init_log return the appropriate value (undef if error, $self otherwise)
#
# Revision 1.5  1999/09/03 17:08:59  zamboni
# Changed the start line to something that is path-independent, and
# updated the copyright notice.
#
# Revision 1.4  1999/09/03 17:03:47  zamboni
# Added std comment block.
#
# Revision 1.3  1999/06/08 05:02:05  zamboni
# Merged branch a06-raw-data-collection into main trunk
#
# Revision 1.2.2.1  1999/06/07 20:03:09  zamboni
# - Changed the period from 5 to 30 seconds
#
# Revision 1.2  1999/04/01 02:45:43  zamboni
# - Made the callback that receives the output of the command not block
#   when waiting between executions of the command (it was using
#   sleep()), but instead schedule a timed event into the future using
#   Reactor time events. This allows the process to still receive input
#   from other channels, even while it is waiting.
#
# Revision 1.1  1999/03/31 07:26:11  zamboni
# Added.
#
#
