/*************************************************
* Barrett Reducer Header File                    *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_BARRETT_H__
#define BOTAN_BARRETT_H__

#include <botan/reducer.h>

namespace Botan {

/*************************************************
* Barrett Reduction                              *
*************************************************/
class BarrettReducer : public ModularReducer
   {
   public:
      BigInt reduce(const BigInt&) const;

      BarrettReducer(const BigInt&);
   private:
      u32bit max_bits, k;
      BigInt mu, b_to_k1;
      mutable BigInt a, b;
   };

}

#endif
