/*************************************************
* CFB Mode Header File                           *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_CFB_H__
#define BOTAN_CFB_H__

#include <botan/modebase.h>

namespace Botan {

/*************************************************
* CFB Encryption                                 *
*************************************************/
class CFB_Encryption : public BlockCipherMode
   {
   public:
      void write(const byte[], u32bit);

      CFB_Encryption(const std::string&, const SymmetricKey&,
                     const BlockCipherModeIV&, u32bit = 0);
   private:
      void feedback();
      const u32bit FEEDBACKSIZE;
   };

/*************************************************
* CFB Decryption                                 *
*************************************************/
class CFB_Decryption : public BlockCipherMode
   {
   public:
      void write(const byte[], u32bit);

      CFB_Decryption(const std::string&, const SymmetricKey&,
                     const BlockCipherModeIV&, u32bit = 0);
   private:
      void feedback();
      const u32bit FEEDBACKSIZE;
   };

}

#endif
