/*************************************************
* DSA Header File                                *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_DSA_H__
#define BOTAN_DSA_H__

#include <botan/bigint.h>
#include <botan/pk_keys.h>
#include <botan/mod_exp.h>
#include <botan/dl_parm.h>

namespace Botan {

/*************************************************
* DSA Public Key                                 *
*************************************************/
class DSA_PublicKey : public PK_Verifying_wo_MR_Key
   {
   public:
      bool verify(const byte[], u32bit, const byte[], u32bit) const;

      u32bit max_input_bits() const { return q.bits(); }

      bool check_params() const;
      const BigInt& get_p() const { return p; }
      const BigInt& get_q() const { return q; }
      const BigInt& get_g() const { return g; }
      const BigInt& get_y() const { return y; }

      DSA_PublicKey(const DL_Group&, const BigInt&);
      DSA_PublicKey(const DSA_PublicKey&);
   protected:
      DL_Group group;
      const BigInt &p, &q, &g;
      BigInt y;
      FixedBase_Exp powermod_g_p, powermod_y_p;
   };

/*************************************************
* DSA Private Key                                *
*************************************************/
class DSA_PrivateKey : public DSA_PublicKey, public PK_Signing_Key
   {
   public:
      SecureVector<byte> sign(const byte[], u32bit) const;

      bool check_params() const;
      const BigInt& get_x() const { return x; }

      DSA_PrivateKey(const DL_Group&);
      DSA_PrivateKey(const DL_Group&, const BigInt&, const BigInt&);
   private:
      BigInt x;
   };

}

#endif
