/*************************************************
* EMAC Header File                               *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_EMAC_H__
#define BOTAN_EMAC_H__

#include <botan/base.h>

namespace Botan {

/*************************************************
* EMAC                                           *
*************************************************/
class EMAC : public MessageAuthenticationCode
   {
   public:
      void clear() throw();
      std::string name() const { return "EMAC(" + f1->name() + ")"; }
      MessageAuthenticationCode* clone() const;
      EMAC(const std::string&);
      ~EMAC() { delete f1; delete f2; }
   private:
      void add_data(const byte[], u32bit);
      void final_result(byte[]);
      void key(const byte[], u32bit);
      BlockCipher* f1;
      BlockCipher* f2;
      SecureVector<byte> state;
      u32bit position;
   };

}

#endif
