/*************************************************
* EMSA1 Header File                              *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_EMSA1_H__
#define BOTAN_EMSA1_H__

#include <botan/pk_misc.h>

namespace Botan {

/*************************************************
* EMSA1                                          *
*************************************************/
class EMSA1 : public EMSA
   {
   public:
      EMSA1(const std::string&);
      ~EMSA1() { delete hash; }
   private:
      void update(const byte[], u32bit);
      SecureVector<byte> encoding_of(const SecureVector<byte>&, u32bit);
      SecureVector<byte> raw_data();
      HashFunction* hash;
   };

}

#endif
