/*************************************************
* Fork Header File                               *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_FORK_H__
#define BOTAN_FORK_H__

#include <botan/filter.h>

namespace Botan {

/*************************************************
* Fork                                           *
*************************************************/
class Fork : public Filter
   {
   public:
      void write(const byte input[], u32bit length) { send(input, length); }
      void set_port(u32bit n) { set_port(n); }

      Fork(Filter*, Filter*, Filter* = 0, Filter* = 0);
      Fork(Filter*[], u32bit);
   };

}

#endif
