/*************************************************
* Hex Encoder/Decoder Header File                *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_HEX_H__
#define BOTAN_HEX_H__

#include <botan/filter.h>

namespace Botan {

/*************************************************
* Hex Encoder                                    *
*************************************************/
class Hex_Encoder : public Filter
   {
   public:
      enum Case { Uppercase, Lowercase };
      static void encode(byte, byte[2], Case = Uppercase);

      void write(const byte[], u32bit);
      void end_msg();
      Hex_Encoder(bool = false, u32bit = 72, Case = Uppercase);
   private:
      void encode_and_send(const byte[], u32bit);
      const Case casing;
      const bool LINEBREAKS;
      const u32bit LINELENGTH;
      SecureVector<byte> in_buffer, out_buffer;
      u32bit position, counter;
   };

/*************************************************
* Hex Decoder                                    *
*************************************************/
class Hex_Decoder : public Filter
   {
   public:
      static byte decode(const byte[2]);
      static bool is_valid(byte in) { return (HEX_TO_BIN[in] != 0x80); }

      void write(const byte[], u32bit);
      void end_msg();
      Hex_Decoder();
   private:
      void decode_and_send(const byte[], u32bit);
      static const byte HEX_TO_BIN[256];
      SecureVector<byte> in_buffer, out_buffer;
      u32bit position;
   };

}

#endif
