/*************************************************
* MDx Hash Function Header File                  *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_MDX_BASE_H__
#define BOTAN_MDX_BASE_H__

#include <botan/base.h>

namespace Botan {

/*************************************************
* MDx Hash Function Base Class                   *
*************************************************/
class MDx_HashFunction : public HashFunction
   {
   public:
      MDx_HashFunction(u32bit, u32bit);
      virtual ~MDx_HashFunction() {}
   protected:
      SecureVector<byte> buffer;
      u64bit count, position;
   private:
      virtual void hash(const byte[]) = 0;
      void add_data(const byte[], u32bit);
   };

}

#endif
