/*************************************************
* MISTY1 Header File                             *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_MISTY1_H__
#define BOTAN_MISTY1_H__

#include <botan/base.h>

namespace Botan {

/*************************************************
* MISTY1                                         *
*************************************************/
class MISTY1 : public BlockCipher
   {
   public:
      void clear() throw() { EK.clear(); DK.clear(); }
      std::string name() const { return "MISTY1"; }
      BlockCipher* clone() const { return new MISTY1; }
      MISTY1() : BlockCipher(8, 16) {}
   private:
      void enc(const byte[], byte[]) const;
      void dec(const byte[], byte[]) const;
      void key(const byte[], u32bit);
      void FL_E(u16bit&, u16bit&, u16bit&, u16bit&, u32bit) const;
      void FL_D(u16bit&, u16bit&, u16bit&, u16bit&, u32bit) const;
      void FO_E(u16bit,  u16bit,  u16bit&, u16bit&, u32bit) const;
      void FO_D(u16bit,  u16bit,  u16bit&, u16bit&, u32bit) const;
      static u16bit FI(u16bit, u16bit, u16bit);
      static const byte S7[128], EK_ORDER[100], DK_ORDER[100];
      static const u16bit S9[512];
      SecureBuffer<u16bit, 100> EK, DK;
   };

}

#endif
