/*************************************************
* BigInt Algorithms Header File                  *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_MP_CORE_H__
#define BOTAN_MP_CORE_H__

#include <botan/mp_types.h>

extern "C" {

using Botan::word;
using Botan::dword;
using Botan::u32bit;
using Botan::s32bit;
using Botan::MP_WORD_MAX;
using Botan::MP_RADIX;

#define MP_LOW_WORD(x)  ((x                ) & MP_WORD_MAX)
#define MP_HIGH_WORD(x) ((x >> MP_WORD_BITS) & MP_WORD_MAX)

/*************************************************
* Two Argument MP Core                           *
*************************************************/
void bigint_add2(word* const, u32bit, const word*, u32bit);
void bigint_sub2(word* const, u32bit, const word*, u32bit);
void bigint_linmul2(word* const, u32bit, word);

/*************************************************
* Two Argument Addition Without Carry            *
*************************************************/
word bigint_add2_nc(word* const, u32bit, const word*, u32bit);

/*************************************************
* Three Argument MP Core                         *
*************************************************/
void bigint_add3(word* const, const word*, u32bit, const word*, u32bit);
void bigint_sub3(word* const , const word*, u32bit, const word*, u32bit);
void bigint_linmul3(word* const, const word*, u32bit, word);

/*************************************************
* MP Shifting                                    *
*************************************************/
void bigint_shl1(word*, u32bit, u32bit, u32bit);
void bigint_shl2(word*, const word*, u32bit, u32bit, u32bit);
void bigint_shr1(word*, u32bit, u32bit, u32bit);
void bigint_shr2(word*, const word*, u32bit, u32bit, u32bit);

/*************************************************
* Other MP Algorithms                            *
*************************************************/
bool bigint_divcore(word, word, word, word, word, word);
s32bit bigint_cmp(const word*, u32bit, const word*, u32bit);


}

namespace Botan {

/*************************************************
* MP Multiplication                              *
*************************************************/
void bigint_mul3(word* const, u32bit,
                 const word*, u32bit, u32bit,
                 const word*, u32bit, u32bit);

void bigint_comba4(word[8], const word[4], const word[4]);
void bigint_comba8(word[16], const word[8], const word[8]);
void bigint_karat16(word[32], const word[16], const word[16]);
void bigint_karat32(word[64], const word[32], const word[32]);
void bigint_karat64(word[128], const word[64], const word[64]);
void bigint_karat128(word[256], const word[128], const word[128]);

}

#endif
