/*************************************************
* Nyberg-Rueppel Header File                     *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_NYBERG_RUEPPEL_H__
#define BOTAN_NYBERG_RUEPPEL_H__

#include <botan/bigint.h>
#include <botan/pk_keys.h>
#include <botan/mod_exp.h>
#include <botan/dl_parm.h>

namespace Botan {

/*************************************************
* Nyberg-Rueppel Public Key                      *
*************************************************/
class NR_PublicKey : public PK_Verifying_with_MR_Key
   {
   public:
      SecureVector<byte> verify(const byte[], u32bit) const;

      u32bit max_input_bits() const { return (q.bits()-1); }

      bool check_params() const;
      const BigInt& get_p() const { return p; }
      const BigInt& get_q() const { return q; }
      const BigInt& get_g() const { return g; }
      const BigInt& get_y() const { return y; }

      NR_PublicKey(const DL_Group&, const BigInt&);
      NR_PublicKey(const NR_PublicKey&);
   protected:
      DL_Group group;
      const BigInt &p, &q, &g;
      BigInt y;
      FixedBase_Exp powermod_g_p, powermod_y_p;
   };

/*************************************************
* Nyberg-Rueppel Private Key                     *
*************************************************/
class NR_PrivateKey : public NR_PublicKey, public PK_Signing_Key
   {
   public:
      SecureVector<byte> sign(const byte[], u32bit) const;

      bool check_params() const;
      const BigInt& get_x() const { return x; }

      NR_PrivateKey(const DL_Group&);
      NR_PrivateKey(const DL_Group&, const BigInt&, const BigInt&);
   private:
      BigInt x;
   };

}

#endif
