/*************************************************
* S2K Base Class Header File                     *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_S2K_H__
#define BOTAN_S2K_H__

#include <botan/base.h>
#include <botan/symkey.h>

namespace Botan {

/*************************************************
* S2K Base Class                                 *
*************************************************/
class S2K
   {
   public:
      virtual SymmetricKey derive_key(const std::string&, u32bit) const = 0;

      bool can_change_iterations() const { return variable_iterations; }
      u32bit iterations() const { return iter; }
      void set_iterations(u32bit);

      virtual void change_salt(const byte[], u32bit);
      void change_salt(const SecureVector<byte>&);
      void new_random_salt(u32bit);

      SecureVector<byte> current_salt() const { return salt; }

      S2K(bool var_iter) : variable_iterations(var_iter) { iter = 1; }
      virtual ~S2K() {}
   protected:
      SecureVector<byte> salt;
   private:
      const bool variable_iterations;
      u32bit iter;
   };

}

#endif
